/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.smtp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.LimitedWaitOutputStream;
import org.eclipse.aperi.server.util.smtp.BadRecipientException;
import org.eclipse.aperi.server.util.smtp.Email;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class SmtpTransmitter {
    private static final String CRLF = "\r\n";
    private static final int MAX_TEXT_LINE = 998;
    private static final int TIMEOUT_IN_SECONDS = 120;
    private static final String HELO_CMD = "HELO ";
    private static final String MAIL_CMD = "MAIL FROM:";
    private static final String RCPT_CMD = "RCPT TO:";
    private static final String DATA_CMD = "DATA ";
    private static final String QUIT_CMD = "QUIT ";
    private static final String RSET_CMD = "RSET ";
    private static final String[] monthTable = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private Socket socket;
    private String smtpServerName;
    private int smtpServerPort;
    private String localHostName;
    private String date;
    private BufferedReader reader;
    private BufferedWriter writer;
    private String lastCmd = "";
    private String reply;
    private int replyCode;

    public SmtpTransmitter(String string, int n) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"SmtpTransmitter", (String)"smtpServerName, smtpServerPort");
        }
        this.smtpServerName = string;
        this.smtpServerPort = n;
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n2 = gregorianCalendar.get(2);
        String string2 = monthTable[n2];
        int n3 = gregorianCalendar.get(15);
        n3 = n3 < 0 ? (n3 += gregorianCalendar.get(16)) : (n3 -= gregorianCalendar.get(16));
        long l = (n3 /= 60000) / 60 * 100 + n3 % 60;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd '" + string2 + "' yy HH:mm ");
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(simpleDateFormat.format(date));
        DecimalFormat decimalFormat = new DecimalFormat("+0000;-0000");
        stringBuffer.append(decimalFormat.format(l));
        this.date = stringBuffer.toString();
        this.localHostName = HardwareID.getLocalHostName();
        try {
            this.socket = new Socket(this.smtpServerName, this.smtpServerPort);
            this.socket.setSoTimeout(120000);
            InputStream inputStream = this.socket.getInputStream();
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            OutputStream outputStream = this.socket.getOutputStream();
            outputStream = new LimitedWaitOutputStream(outputStream, 120);
            this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        }
        catch (UnknownHostException unknownHostException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"SmtpTransmitter", (Throwable)unknownHostException);
            }
            this.closeIO();
            this.throwException("GEN0113E", unknownHostException);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"SmtpTransmitter", (Throwable)iOException);
            }
            this.closeIO();
            Object[] objectArray = new Object[]{this.smtpServerName, new Integer(this.smtpServerPort)};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"SmtpTransmitter");
            }
            throw new NestableException("GEN0114E", objectArray, (Exception)iOException);
        }
        try {
            this.getReply();
            this.checkReplyCode();
            this.sendCmd(HELO_CMD, this.localHostName);
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"SmtpTransmitter", (Throwable)localizableException);
            }
            this.close();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"SmtpTransmitter");
            }
            throw localizableException;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"SmtpTransmitter");
        }
    }

    public void close() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"");
        }
        if (this.reader != null && this.writer != null) {
            try {
                this.sendCmd(QUIT_CMD, null);
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)localizableException);
                }
                localizableException.print();
            }
        }
        this.closeIO();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close");
        }
    }

    private void closeIO() {
        IOException iOException;
        block19: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"closeIO", (String)"");
            }
            boolean bl = this.socket == null;
            iOException = null;
            if (this.writer != null) {
                try {
                    this.writer.close();
                    bl = true;
                }
                catch (IOException iOException2) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"closeIO", (Throwable)iOException2);
                    }
                    iOException = iOException2;
                }
            }
            this.writer = null;
            if (!bl) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException3) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"closeIO", (Throwable)iOException3);
                    }
                    if (iOException == null) break block19;
                    iOException = iOException3;
                }
            }
        }
        this.socket = null;
        if (iOException != null) {
            MessageLog.logException((String)"GEN0021E", (Exception)iOException, (Object)this.smtpServerName);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeIO");
        }
    }

    public void sendMail(Email email) throws LocalizableException {
        block26: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"sendMail", (String)"email");
            }
            try {
                String[] stringArray = this.copyRecipients(email);
                String string = email.returnPath;
                String string2 = email.replyTo;
                this.sendPath(MAIL_CMD, string);
                this.checkReplyCode();
                int n = stringArray.length;
                String[] stringArray2 = new String[n];
                String[] stringArray3 = new String[n];
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    String string3 = stringArray[n3];
                    this.sendPath(RCPT_CMD, string3);
                    if (this.replyCode >= 550 && this.replyCode <= 553) {
                        stringArray2[n2] = string3;
                        stringArray3[n2++] = this.reply;
                    } else {
                        this.checkReplyCode();
                    }
                    ++n3;
                }
                if (n2 == n) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"sendMail");
                    }
                    throw new BadRecipientException(this.smtpServerName, stringArray2, stringArray3, false);
                }
                this.sendData(email, string, string2, stringArray);
                this.sendCRLF();
                this.send('.');
                this.sendCRLF();
                this.getReply();
                this.checkReplyCode();
                if (n2 == 0) break block26;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"sendMail");
                }
                throw new BadRecipientException(this.smtpServerName, stringArray2, stringArray3, true);
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"sendMail", (Throwable)localizableException);
                }
                try {
                    this.sendCmd(RSET_CMD, null);
                }
                catch (LocalizableException localizableException2) {}
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"sendMail");
                }
                throw localizableException;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendMail");
        }
    }

    private String[] copyRecipients(Email email) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"copyRecipients", (String)"email");
        }
        Vector<String> vector = email.recipientList;
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = vector.elementAt(n);
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"copyRecipients", (Object)stringArray);
        }
        return stringArray;
    }

    private void sendData(Email email, String string, String string2, String[] stringArray) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendData", (String)"email, returnPath, replyTo, recipientList");
        }
        this.sendCmd(DATA_CMD, null);
        this.checkReplyCode();
        this.send("Date: ");
        this.send(this.date);
        this.sendCRLF();
        MutableBoolean mutableBoolean = new MutableBoolean();
        this.send("From: ");
        if (email.from == null) {
            this.send(string2);
        } else {
            String string3 = SmtpTransmitter.possiblyEncodeHeaderLine(email.from, 6, mutableBoolean);
            if (mutableBoolean.value) {
                if (string3.charAt(0) != '\"') {
                    this.send('\"');
                }
                this.send(string3);
                if (string3.charAt(0) != '\"') {
                    this.send('\"');
                }
            } else {
                this.send(string3);
                this.send(' ');
            }
            this.send('<');
            this.send(string2);
            this.send('>');
        }
        this.sendCRLF();
        if (email.subject != null) {
            this.send("Subject: ");
            this.send(SmtpTransmitter.possiblyEncodeHeaderLine(email.subject, 9, mutableBoolean));
            this.sendCRLF();
        }
        this.send("To: ");
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                this.send(',');
                this.sendCRLF();
                this.send(' ');
            }
            this.send(stringArray[n]);
            ++n;
        }
        this.sendCRLF();
        this.send("Mime-Version: 1.0");
        this.sendCRLF();
        this.send("Content-Type: text/plain; charset=UTF-8");
        this.sendCRLF();
        String string4 = SmtpTransmitter.possiblyEncodeBody(email.text, mutableBoolean);
        if (!mutableBoolean.value) {
            this.send("Content-Transfer-Encoding: quoted-printable");
            this.sendCRLF();
        }
        this.sendCRLF();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < string4.length()) {
            int n5;
            if (string4.charAt(n2) == '.') {
                this.send('.');
            }
            if ((n5 = string4.indexOf(10, n2)) != -1 && n5 - n2 < 998) {
                n4 = n5 - n2;
                if (n4 > 0 && string4.charAt(n5 - 1) == '\r') {
                    --n4;
                }
                n3 = n5 + 1;
            } else {
                n4 = string4.length() - n2;
                if (n4 <= 998) {
                    n3 = string4.length();
                } else {
                    n5 = n2 + 998 - 1;
                    while (n5 > n2) {
                        if (Character.isWhitespace(string4.charAt(n5))) break;
                        --n5;
                    }
                    if (n5 == n2) {
                        n5 = n2 + 998;
                    }
                    n4 = n5 - n2;
                    n3 = n5;
                }
            }
            this.send(string4, n2, n4);
            this.sendCRLF();
            n2 = n3;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendData");
        }
    }

    private static String possiblyEncodeHeaderLine(String string, int n, MutableBoolean mutableBoolean) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"possiblyEncodeHeaderLine", (String)"s, pos, unchanged");
        }
        if (SmtpTransmitter.fineAsIs(string, mutableBoolean)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"possiblyEncodeHeaderLine", (Object)string);
            }
            return string;
        }
        int n2 = string.length();
        short[] sArray = new short[3];
        StringBuffer stringBuffer = new StringBuffer(200);
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            int n6;
            if (bl) {
                stringBuffer.append("=?UTF-8?Q?");
                n += 10;
                bl = false;
            }
            if ((n6 = SmtpTransmitter.getUTF8CharacterSize(n5 = string.charAt(n3))) != 1) {
                n4 = n6 * 3;
            } else {
                switch (n5) {
                    case 61: 
                    case 63: 
                    case 95: {
                        n4 = 3;
                        break;
                    }
                    case 32: {
                        n5 = 95;
                    }
                    default: {
                        n4 = 1;
                    }
                }
            }
            if (n + n4 > 74) {
                stringBuffer.append("?=\r\n ");
                n = 1;
                bl = true;
                continue;
            }
            if (n4 == 1) {
                stringBuffer.append((char)n5);
            } else {
                SmtpTransmitter.appendEscapedUTF8(stringBuffer, n5, n6, sArray);
            }
            ++n3;
            n += n4;
        }
        stringBuffer.append("?=");
        String string2 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"possiblyEncodeHeaderLine", (Object)string2);
        }
        return string2;
    }

    private static String possiblyEncodeBody(String string, MutableBoolean mutableBoolean) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"possiblyEncodeBody", (String)"s, unchanged");
        }
        if (SmtpTransmitter.fineAsIs(string, mutableBoolean)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"possiblyEncodeBody", (Object)string);
            }
            return string;
        }
        short[] sArray = new short[3];
        StringBuffer stringBuffer = new StringBuffer(1000);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            char c = string.charAt(n2);
            int n3 = SmtpTransmitter.getUTF8CharacterSize(c);
            boolean bl2 = bl = n3 > 1 || c == '=';
            if (bl) {
                SmtpTransmitter.appendEscapedUTF8(stringBuffer, c, n3, sArray);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"possiblyEncodeBody", (Object)string2);
        }
        return string2;
    }

    private static boolean fineAsIs(String string, MutableBoolean mutableBoolean) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fineAsIs", (String)"s, unchanged");
        }
        int n = string.length();
        mutableBoolean.value = true;
        int n2 = 0;
        while (mutableBoolean.value && n2 < n) {
            if (string.charAt(n2) < '\u0080') {
                ++n2;
                continue;
            }
            mutableBoolean.value = false;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fineAsIs", (boolean)mutableBoolean.value);
        }
        return mutableBoolean.value;
    }

    private static int getUTF8CharacterSize(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getUTF8CharacterSize", (String)"c");
        }
        int n2 = n < 128 ? 1 : (n < 2048 ? 2 : 3);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getUTF8CharacterSize", (int)n2);
        }
        return n2;
    }

    private static void appendEscapedUTF8(StringBuffer stringBuffer, int n, int n2, short[] sArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendEscapedUTF8", (String)"buf, c, characterSize, array");
        }
        switch (n2) {
            case 1: {
                sArray[0] = (short)n;
                break;
            }
            case 2: {
                sArray[1] = (short)(0x80 | n & 0x3F);
                sArray[0] = (short)(0xC0 | (n >>= 6));
                break;
            }
            default: {
                sArray[2] = (short)(0x80 | n & 0x3F);
                sArray[1] = (short)(0x80 | (n >>= 6) & 0x3F);
                sArray[0] = (short)(0xE0 | (n >>= 6));
            }
        }
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append('=');
            n = sArray[n3];
            stringBuffer.append(SmtpTransmitter.toHexDigit(n >> 4));
            stringBuffer.append(SmtpTransmitter.toHexDigit(n & 0xF));
            ++n3;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendEscapedUTF8");
        }
    }

    private static char toHexDigit(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"toHexDigit", (String)"x");
        }
        char c = n < 10 ? (char)(48 + n) : (char)(65 + n - 10);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"toHexDigit", (char)c);
        }
        return c;
    }

    private void getReply() throws LocalizableException {
        block14: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getReply", (String)"");
            }
            this.replyCode = 0;
            try {
                do {
                    this.reply = this.reader.readLine();
                    if (this.reply != null) continue;
                    this.replyCode = -1;
                    break block14;
                } while (this.reply.charAt(3) != ' ');
                int n = 0;
                while (n < 3) {
                    char c = this.reply.charAt(n);
                    if (c < '0' || c > '9') {
                        this.replyCode = -1;
                        break;
                    }
                    this.replyCode = 10 * this.replyCode + (c - 48);
                    ++n;
                }
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getReply", (Throwable)iOException);
                }
                this.throwException("GEN0110E", iOException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReply");
        }
    }

    private void checkReplyCode() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkReplyCode", (String)"");
        }
        if (this.replyCode < 200 || this.replyCode > 399) {
            if (this.reply == null) {
                this.reply = "";
            }
            Object[] objectArray = new Object[]{this.lastCmd, this.reply};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkReplyCode");
            }
            throw new LocalizableException("GEN0111E", objectArray);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkReplyCode");
        }
    }

    private void sendCmd(String string, String string2) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendCmd", (String)"cmd, arg");
        }
        this.lastCmd = string;
        this.send(string);
        if (string2 != null) {
            this.send(string2);
        }
        this.sendCRLF();
        this.getReply();
        this.checkReplyCode();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendCmd");
        }
    }

    private void sendPath(String string, String string2) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendPath", (String)"cmd, path");
        }
        this.lastCmd = string;
        this.send(string);
        this.send('<');
        this.send(string2);
        this.send('>');
        this.sendCRLF();
        this.getReply();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendPath");
        }
    }

    private void send(String string) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"send", (String)"s");
        }
        this.send(string, 0, string.length());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"send");
        }
    }

    private void send(String string, int n, int n2) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"send", (String)"s, offset, length");
        }
        try {
            this.writer.write(string, n, n2);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"send", (Throwable)iOException);
            }
            this.throwException("GEN0112E", iOException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"send");
        }
    }

    private void send(char c) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"send", (String)"c");
        }
        try {
            this.writer.write(c);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"send", (Throwable)iOException);
            }
            this.throwException("GEN0112E", iOException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"send");
        }
    }

    private void sendCRLF() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendCRLF", (String)"");
        }
        try {
            this.writer.write(CRLF, 0, 2);
            this.writer.flush();
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"sendCRLF", (Throwable)iOException);
            }
            this.throwException("GEN0112E", iOException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendCRLF");
        }
    }

    private void throwException(String string, Exception exception) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"throwException", (String)"msgID, e");
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.SmtpTransmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"throwException");
        }
        Object[] objectArray = new Object[]{this.smtpServerName};
        throw new NestableException(string, objectArray, exception);
    }
}

