/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.ParameterAttributeBean;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class BaseAttributeBean {
    protected String category;
    protected Exception exception = null;
    protected HashMap parameters = null;
    protected boolean missingParameter = false;
    protected ParameterAttributeBean parameterBean = null;
    protected IViewerReportDesignHandle reportDesignHandle = null;
    protected String reportDesignName = null;
    protected String reportDocumentName = null;
    protected String reportTitle = null;
    protected String reportPage = null;
    protected Locale locale = null;
    protected boolean masterPageContent = true;
    protected boolean isDesigner = false;
    protected String bookmark = null;
    protected String reportletId = null;
    protected String format = "html";
    protected Map configMap = null;
    protected Map parameterMap = null;
    protected boolean rtl = false;
    protected boolean isToc = false;
    public boolean documentInUrl = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract void __init(HttpServletRequest var1) throws Exception;

    protected abstract IViewerReportService getReportService();

    protected abstract void __finalize() throws Throwable;

    public BaseAttributeBean() {
    }

    public BaseAttributeBean(HttpServletRequest httpServletRequest) {
        try {
            this.init(httpServletRequest);
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    protected void init(HttpServletRequest httpServletRequest) throws Exception {
        this.locale = ParameterAccessor.getLocale(httpServletRequest);
        this.rtl = ParameterAccessor.isRtl(httpServletRequest);
        this.reportletId = ParameterAccessor.getReportletId(httpServletRequest);
        this.__init(httpServletRequest);
    }

    protected void __initParameters(HttpServletRequest httpServletRequest) throws Exception {
        IViewerReportDesignHandle iViewerReportDesignHandle = this.getDesignHandle(httpServletRequest);
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        inputOptions.setOption("locale", this.locale);
        inputOptions.setOption("rtl", new Boolean(this.rtl));
        Collection collection = this.getReportService().getParameterDefinitions(iViewerReportDesignHandle, inputOptions, false);
        this.parameters = (HashMap)this.getParsedParameters(iViewerReportDesignHandle, collection, httpServletRequest, inputOptions);
        this.missingParameter = BaseAttributeBean.validateParameters(collection, this.parameters);
    }

    protected IViewerReportDesignHandle getDesignHandle(HttpServletRequest httpServletRequest) {
        return new BirtViewerReportDesignHandle(null, this.reportDesignName);
    }

    public ParameterAttributeBean getParameterBean() {
        return this.parameterBean;
    }

    public void setParameterBean(ParameterAttributeBean parameterAttributeBean) {
        this.parameterBean = parameterAttributeBean;
    }

    public String getReportTitle() throws ReportServiceException {
        return this.reportTitle;
    }

    public String getReportPage() {
        return this.reportPage;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isDesigner() {
        return this.isDesigner;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getReportDocumentName() {
        return this.reportDocumentName;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public HashMap getParameters() {
        return this.parameters;
    }

    public boolean isMasterPageContent() {
        return this.masterPageContent;
    }

    public boolean isMissingParameter() {
        return this.missingParameter;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public String getCategory() {
        return this.category;
    }

    public String getReportDesignName() {
        return this.reportDesignName;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isRtl() {
        return this.rtl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.__finalize();
        }
        finally {
            super.finalize();
        }
    }

    protected static boolean validateParameters(Collection collection, Map map) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            String string2 = parameterDefinition.getName();
            Object v = map.get(string2);
            if (parameterDefinition.isHidden()) continue;
            if (v == null && !parameterDefinition.allowNull()) {
                bl = true;
                break;
            }
            if (1 != parameterDefinition.getDataType() || (string = (String)v) == null || string.length() > 0 || parameterDefinition.allowBlank()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected Map getParsedParameters(IViewerReportDesignHandle iViewerReportDesignHandle, Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            String string = parameterDefinition.getName();
            Object object = this.getParamValueObject(httpServletRequest, parameterDefinition);
            if (object == null) {
                object = this.getReportService().getParameterDefaultValue(iViewerReportDesignHandle, parameterDefinition.getName(), inputOptions);
            }
            hashMap.put(string, object);
        }
        return hashMap;
    }

    protected Object getParamValueObject(HttpServletRequest httpServletRequest, ParameterDefinition parameterDefinition) throws ReportServiceException {
        String string = parameterDefinition.getName();
        String string2 = parameterDefinition.getDisplayFormat();
        if (ParameterAccessor.isReportParameterExist(httpServletRequest, string)) {
            ReportParameterConverter reportParameterConverter = new ReportParameterConverter(string2, this.locale);
            String string3 = ParameterAccessor.getReportParameter(httpServletRequest, string, null);
            return reportParameterConverter.parse(string3, parameterDefinition.getDataType());
        }
        return null;
    }

    public IViewerReportDesignHandle getReportDesignHandle(HttpServletRequest httpServletRequest) {
        return this.reportDesignHandle;
    }

    public boolean isToc() {
        return this.isToc;
    }

    public String getReportletId() {
        return this.reportletId;
    }

    static {
        $assertionsDisabled = !BaseAttributeBean.class.desiredAssertionStatus();
    }
}

