/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

public class ArchiveWriter
implements IDocArchiveWriter {
    boolean shareArchive;
    ArchiveFile archive;

    public ArchiveWriter(String archiveName) throws IOException {
        this.archive = new ArchiveFile(archiveName, "rw");
        this.shareArchive = false;
    }

    public ArchiveWriter(ArchiveFile archive) throws IOException {
        this.archive = archive;
        this.shareArchive = true;
    }

    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        ArchiveEntry entry = this.archive.createEntry(relativePath);
        return new ArchiveEntryOutputStream(entry);
    }

    public boolean dropStream(String relativePath) {
        try {
            return this.archive.removeEntry(relativePath);
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean exists(String relativePath) {
        return this.archive.exists(relativePath);
    }

    public void finish() throws IOException {
        this.archive.flush();
        if (!this.shareArchive) {
            this.archive.close();
        }
    }

    public void flush() throws IOException {
        this.archive.flush();
    }

    public String getName() {
        return this.archive.getName();
    }

    public void initialize() throws IOException {
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
    }

    public Object lock(String stream) throws IOException {
        ArchiveEntry entry = this.archive.getEntry(stream);
        if (entry != null) {
            return this.archive.lockEntry(entry);
        }
        throw new IOException("can't find the entry " + stream);
    }

    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

