/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.equinox.http.servlet.internal.HttpSessionAdaptor;
import org.eclipse.equinox.http.servlet.internal.RequestDispatcherAdaptor;

public class HttpServletRequestAdaptor
extends HttpServletRequestWrapper {
    private String alias;
    private Servlet servlet;
    private boolean isRequestDispatcherInclude;
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";

    public HttpServletRequestAdaptor(HttpServletRequest httpServletRequest, String string, Servlet servlet) {
        super(httpServletRequest);
        this.alias = string;
        this.servlet = servlet;
        this.isRequestDispatcherInclude = httpServletRequest.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null;
    }

    public String getAuthType() {
        String string = (String)super.getAttribute("org.osgi.service.http.authentication.type");
        if (string != null) {
            return string;
        }
        return super.getAuthType();
    }

    public String getRemoteUser() {
        String string = (String)super.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (string != null) {
            return string;
        }
        return super.getRemoteUser();
    }

    public String getPathInfo() {
        if (this.isRequestDispatcherInclude) {
            return super.getPathInfo();
        }
        if (this.alias.equals("/")) {
            return super.getPathInfo();
        }
        String string = super.getPathInfo().substring(this.alias.length());
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getServletPath() {
        if (this.isRequestDispatcherInclude) {
            return super.getServletPath();
        }
        if (this.alias.equals("/")) {
            return "";
        }
        return this.alias;
    }

    public String getContextPath() {
        if (this.isRequestDispatcherInclude) {
            return super.getContextPath();
        }
        return String.valueOf(super.getContextPath()) + super.getServletPath();
    }

    public Object getAttribute(String string) {
        if (this.isRequestDispatcherInclude) {
            if (string.equals(INCLUDE_CONTEXT_PATH_ATTRIBUTE)) {
                String string2;
                String string3 = (String)super.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
                if (string3 == null || string3.equals("/")) {
                    string3 = "";
                }
                if ((string2 = (String)super.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE)) == null || string2.equals("/")) {
                    string2 = "";
                }
                return String.valueOf(string3) + string2;
            }
            if (string.equals(INCLUDE_SERVLET_PATH_ATTRIBUTE)) {
                if (this.alias.equals("/")) {
                    return "";
                }
                return this.alias;
            }
            if (string.equals(INCLUDE_PATH_INFO_ATTRIBUTE)) {
                String string4 = (String)super.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
                if (this.alias.equals("/")) {
                    return string4;
                }
                if ((string4 = string4.substring(this.alias.length())).length() == 0) {
                    return null;
                }
                return string4;
            }
        }
        return super.getAttribute(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return new RequestDispatcherAdaptor(super.getRequestDispatcher(String.valueOf(super.getServletPath()) + string));
    }

    public static String getDispatchPathInfo(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            return (String)httpServletRequest.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
        }
        return httpServletRequest.getPathInfo();
    }

    public static String getDispatchServletPath(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            String string = (String)httpServletRequest.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE);
            return string == null ? "" : string;
        }
        return httpServletRequest.getServletPath();
    }

    public HttpSession getSession() {
        HttpSession httpSession = super.getSession();
        if (httpSession != null) {
            return new HttpSessionAdaptor(httpSession, this.servlet);
        }
        return null;
    }

    public HttpSession getSession(boolean bl) {
        HttpSession httpSession = super.getSession(bl);
        if (httpSession != null) {
            return new HttpSessionAdaptor(httpSession, this.servlet);
        }
        return null;
    }
}

