/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cimxml.CIMXmlUtilFactory;
import org.sblim.wbem.client.indications.CIMEvent;
import org.sblim.wbem.client.indications.CIMListener;

public class CIMOMListener
implements CIMListener {
    public static Vector instanceIndicationVector;
    public static Vector processIndicationVector;
    private static final String IND_FILTER_LIST = "Indication.FilterList";
    private static final String IND_FILTER_MODE = "Indication.FilterMode";
    private static final String FILTER_MODE_INCLUDE = "include";
    private static final String DEV_SERVER_GROUP = "DeviceServer";
    private static List stFilterList;
    private static boolean stIncludeMode;
    private static final int listenerID = 100;
    private IEventMonitorService eventCorrelatorFactory = null;
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    private static String className;

    static {
        Class<?> clazz;
        instanceIndicationVector = new Vector();
        processIndicationVector = new Vector();
        stFilterList = null;
        stIncludeMode = false;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.CIMOMListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public static void addToInstanceIndicationVector(String string) {
        if (!instanceIndicationVector.contains(string)) {
            instanceIndicationVector.add(string);
        }
    }

    public static void addToProcessIndicationVector(String string) {
        if (!processIndicationVector.contains(string)) {
            processIndicationVector.add(string);
        }
    }

    public static boolean isInstanceIndication(String string) {
        return true;
    }

    public static boolean isProcessIndication(String string) {
        return processIndicationVector.contains(string);
    }

    public CIMOMListener(IEventMonitorService iEventMonitorService) {
        Object object;
        this.eventCorrelatorFactory = iEventMonitorService;
        if (msgLogger == null) {
            msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SanEventCorrelatorFactory");
            msgLogger.setMessageFile(LogConstants.MSG_FILE);
        }
        if (traceLogger == null) {
            traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SanEventCorrelatorFactory");
        }
        IConfigService iConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
        String string = iConfigService.getProperty(IND_FILTER_LIST, DEV_SERVER_GROUP);
        stFilterList = new ArrayList();
        if (string != null && string.trim().length() > 0) {
            object = string.split(";");
            int n = 0;
            while (n < ((String[])object).length) {
                stFilterList.add(object[n]);
                ++n;
            }
        }
        traceLogger.text(IRecordType.TYPE_WARN, (Object)"CIMOMListener", "CIMOMListener", "Using indication filter: " + stFilterList);
        object = iConfigService.getProperty(IND_FILTER_MODE, DEV_SERVER_GROUP);
        if (object != null && ((String)object).trim().length() > 0) {
            stIncludeMode = ((String)object).trim().toLowerCase().equals(FILTER_MODE_INCLUDE);
        }
    }

    public int hashCode() {
        return 100;
    }

    public void indicationOccured(CIMEvent cIMEvent) {
        String string = "indicationOccured";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "Indication occured ");
        }
        CIMInstance cIMInstance = cIMEvent.getIndication();
        String string2 = cIMInstance.getClassName().trim();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, string2);
        }
        try {
            if (CIMOMListener.isProcessIndication(string2)) {
                this.handleProcessIndication(cIMEvent);
            } else {
                this.handleInstanceIndication(cIMEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void handleProcessIndication(CIMEvent cIMEvent) throws Exception {
        String string = "handleProcessIndication";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        Vector vector = cIMEvent.getIndication().getAllProperties();
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            if (cIMProperty.getName().equals("SystemName") && cIMProperty.getValue() != null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "Alert Indication received from " + cIMProperty.getValue().getValue());
                }
                this.eventCorrelatorFactory.postIndicationEvent(cIMEvent);
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void handleInstanceIndication(CIMEvent cIMEvent) throws Exception {
        String string = "handleInstanceIndication";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (!this.isHandledIndication(cIMEvent)) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return;
        }
        Vector vector = cIMEvent.getIndication().getAllProperties();
        String string2 = cIMEvent.getIndication().getClassName().trim();
        CIMInstance cIMInstance = null;
        String string3 = null;
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            if (cIMProperty.getName().equals("SourceInstance") && cIMProperty.getValue() != null) {
                String[] stringArray;
                String string4;
                String string5 = (String)cIMProperty.getValue().getValue();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "InstanceXml1:=" + string5);
                }
                if (string5.startsWith("<C")) {
                    string4 = "";
                    int n2 = 0;
                    while (n2 < string5.length()) {
                        if (string5.charAt(n2) != '\\') {
                            string4 = String.valueOf(string4) + string5.charAt(n2);
                        }
                        ++n2;
                    }
                    stringArray = CIMXmlUtilFactory.getCIMXmlUtil();
                    cIMInstance = (CIMInstance)stringArray.getCIMElement(string4);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "Received indication of type: " + cIMInstance.getClassName() + " " + string2);
                    }
                    if (CIMOMListener.isInstanceIndication(string3 = cIMInstance.getClassName())) {
                        this.eventCorrelatorFactory.postIndicationEvent(cIMEvent);
                    }
                } else {
                    string4 = new CIMObjectPath(string5);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "Received an indication of type: " + string4.getObjectName() + " " + string2);
                    }
                    if (CIMOMListener.isInstanceIndication(string3 = (stringArray = string4.getObjectName().split("\\."))[0])) {
                        this.eventCorrelatorFactory.postIndicationEvent(cIMEvent);
                    }
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private boolean isHandledIndication(CIMEvent cIMEvent) {
        boolean bl;
        CIMInstance cIMInstance = cIMEvent.getIndication();
        String string = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"SourceInstance");
        boolean bl2 = stIncludeMode ? this.isContainedInFilterList(string) : (bl = !this.isContainedInFilterList(string));
        if (!bl && traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, "isHandledIndication", "Filtering out indication for " + string);
        }
        return bl;
    }

    private boolean isContainedInFilterList(String string) {
        if (string == null) {
            return false;
        }
        Iterator iterator = stFilterList.iterator();
        while (iterator.hasNext()) {
            if (string.indexOf((String)iterator.next()) <= 0) continue;
            return true;
        }
        return false;
    }

    private void printIndicationsProperties(CIMInstance cIMInstance) {
        String string = "printIndicationProperties";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "Indication: " + cIMInstance.getClassName());
        }
        Vector vector = cIMInstance.getProperties();
        int n = 0;
        while (n < vector.size()) {
            String string2;
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            String string3 = string2 = cIMProperty.getValue() != null ? cIMProperty.getValue().toString() : "null";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, String.valueOf(cIMProperty.getName()) + "=" + string2);
            }
            ++n;
        }
    }
}

