/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.dataservernotification.Notifier;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceOperationalStatusChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceStateChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.EntityEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.InbandEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.data.NewDeviceEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.NewRelationshipEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.PropertyChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.RelationshipStateChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SNMPTrapEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class EventHandler {
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;
    private static Notifier notifier;
    private static Hashtable errors;
    private static final String PROPERTY_GROUP = "DeviceServer";
    private static final String PROPERTY_SEND_ALERT_ON_CIM_INDICATION = "Indication.SendAlert";
    private static boolean alertOnIndicationSetingDetected;
    private static boolean sendAlertOnIndication;
    private EventCorrelatorFactory monitorService = null;

    static {
        Class<?> clazz;
        msgLogger = LogConstants.msgLogger;
        traceLogger = LogConstants.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.EventHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        notifier = null;
        errors = new Hashtable();
        alertOnIndicationSetingDetected = false;
        sendAlertOnIndication = true;
    }

    public EventHandler(EventCorrelatorFactory eventCorrelatorFactory) {
        this.monitorService = eventCorrelatorFactory;
    }

    public static boolean checkAlertOnIndication() {
        String string;
        if (alertOnIndicationSetingDetected) {
            return sendAlertOnIndication;
        }
        boolean bl = sendAlertOnIndication;
        IConfigService iConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
        if (iConfigService != null && (string = iConfigService.getProperty(PROPERTY_SEND_ALERT_ON_CIM_INDICATION, PROPERTY_GROUP)) != null) {
            sendAlertOnIndication = bl = Boolean.getBoolean(string);
            alertOnIndicationSetingDetected = true;
        }
        return bl;
    }

    public static void handleEventAlert(SRMEvent sRMEvent) {
        String string = "handleEventAlert";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string, (Object)sRMEvent.toString());
        }
        int n = EventDBAccessor.getComputerId(1);
        try {
            if (sRMEvent instanceof SNMPTrapEvent) {
                String string2 = ((SNMPTrapEvent)sRMEvent).getSource();
                String string3 = ((SNMPTrapEvent)sRMEvent).getType();
                int n2 = 178;
                int n3 = -1;
                short s = 128;
                int n4 = EventDBAccessor.getAlertIDByCondition(n2);
                if (n4 > 0) {
                    AlertDefinition alertDefinition = new AlertDefinition();
                    alertDefinition.aldAlertID = n4;
                    int[] nArray = null;
                    int n5 = -1;
                    Hashtable hashtable = null;
                    String string4 = null;
                    Hashtable hashtable2 = null;
                    String string5 = "ALR4100I";
                    Object[] objectArray = new Object[]{string2};
                    FabricAlert fabricAlert = new FabricAlert(n, n3, s, alertDefinition, nArray, n5, hashtable, string4, hashtable2, string5, objectArray);
                    EventHandler.getDataSenderProxy().sendAlert((Alert)fabricAlert);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Alert sent for " + sRMEvent.getEventName() + " with source= " + string3 + "|" + string2 + "|" + n2);
                } else {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "AlertId not found for " + sRMEvent.getEventName() + " with device= " + string3 + "|" + string2 + "|" + n2);
                }
            } else if (sRMEvent instanceof InbandEvent) {
                String string6 = ((InbandEvent)sRMEvent).getSource();
                String string7 = ((InbandEvent)sRMEvent).getType();
                int n6 = 178;
                int n7 = -1;
                short s = 128;
                int n8 = EventDBAccessor.getAlertIDByCondition(n6);
                if (n8 > 0) {
                    AlertDefinition alertDefinition = new AlertDefinition();
                    alertDefinition.aldAlertID = n8;
                    int[] nArray = null;
                    int n9 = -1;
                    Hashtable hashtable = null;
                    String string8 = null;
                    Hashtable hashtable3 = null;
                    String string9 = "ALR4101I";
                    Object[] objectArray = new Object[]{string6};
                    FabricAlert fabricAlert = new FabricAlert(n, n7, s, alertDefinition, nArray, n9, hashtable, string8, hashtable3, string9, objectArray);
                    EventHandler.getDataSenderProxy().sendAlert((Alert)fabricAlert);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Alert sent for " + sRMEvent.getEventName() + " with source= " + string7 + "|" + string6 + "|" + n6);
                } else {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "AlertId not found for " + sRMEvent.getEventName() + " with device= " + string7 + "|" + string6 + "|" + n6);
                }
            } else if (sRMEvent instanceof CIMIndicationEvent) {
                if (EventHandler.checkAlertOnIndication()) {
                    String string10 = ((CIMIndicationEvent)sRMEvent).getSource();
                    String string11 = ((CIMIndicationEvent)sRMEvent).getType();
                    int n10 = 178;
                    int n11 = -1;
                    short s = 128;
                    int n12 = EventDBAccessor.getAlertIDByCondition(n10);
                    if (n12 > 0) {
                        AlertDefinition alertDefinition = new AlertDefinition();
                        alertDefinition.aldAlertID = n12;
                        int[] nArray = null;
                        int n13 = -1;
                        Hashtable hashtable = null;
                        String string12 = null;
                        Hashtable hashtable4 = null;
                        String string13 = "ALR4102I";
                        Object[] objectArray = new Object[]{string10};
                        FabricAlert fabricAlert = new FabricAlert(n, n11, s, alertDefinition, nArray, n13, hashtable, string12, hashtable4, string13, objectArray);
                        EventHandler.getDataSenderProxy().sendAlert((Alert)fabricAlert);
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Alert sent for " + sRMEvent.getEventName() + " with source= " + string11 + "|" + string10 + "|" + n10);
                    } else {
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "AlertId not found for " + sRMEvent.getEventName() + " with device= " + string11 + "|" + string10 + "|" + n10);
                    }
                } else {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Alert for " + sRMEvent.getEventName() + " has been disabled in config table");
                }
            } else {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "Alert for " + sRMEvent.getEventName() + " not supported");
            }
        }
        catch (Exception exception) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "Failed to send alert for " + sRMEvent.getEventName());
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, (Object)sRMEvent.toString());
        }
    }

    public void publishEvents(String string, Vector vector) {
        Object object;
        String string2;
        String string3;
        String string4;
        Object object2;
        String string5 = "publishEvents";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string5, new Object[]{string, "allEvents"});
        }
        Iterator iterator = vector.iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Vector<Object> vector2 = new Vector<Object>();
        while (iterator.hasNext()) {
            object2 = (EntityEvent)iterator.next();
            string4 = object2.getType();
            string3 = object2.getUniqueId();
            try {
                Object object3;
                Object object4;
                int n;
                this.monitorService.publish((SRMEvent)object2);
                string2 = this.monitorService.getAlertPopulator(string4);
                if (string2 == null) {
                    if (errors.get(string4) != null) continue;
                    errors.put(string4, new Object());
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string5, "No alert populator found for " + string4 + string3);
                    continue;
                }
                if (object2 instanceof NewDeviceEvent || object2 instanceof NewRelationshipEvent) {
                    Alert alert = string2.populateNew(string3);
                    if (alert == null) continue;
                    EventHandler.getDataSenderProxy().sendAlert(alert);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Alert sent for " + object2.getEventName() + " with device= " + string4 + string3);
                    continue;
                }
                if (object2 instanceof DeviceStateChangeEvent) {
                    int n2 = ((DeviceStateChangeEvent)object2).getPreviousState();
                    n = ((DeviceStateChangeEvent)object2).getCurrentState();
                    object4 = ((DeviceStateChangeEvent)object2).getAttributeMap();
                    if (object4 == null || ((HashMap)object4).isEmpty()) {
                        object = string2.populateStateChange(string3, n, n2);
                        if (object == null) continue;
                        EventHandler.getDataSenderProxy().sendAlert((Alert)object);
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Alert sent for " + object2.getEventName() + " with device= " + string4 + string3);
                        continue;
                    }
                    if (string4.equals("datapath")) {
                        object = string2.populateStateChange(string3, n, n2, (HashMap)object4);
                        if (object == null) continue;
                        EventHandler.getDataSenderProxy().sendAlert((Alert)object);
                        object3 = "Alert sent for " + object2.getEventName() + " with device= " + string4 + string3;
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, object3);
                        continue;
                    }
                    hashMap.put(String.valueOf(string4) + string3, object4);
                    vector2.add(object2);
                    continue;
                }
                if (object2 instanceof PropertyChangeEvent) {
                    Hashtable hashtable = ((PropertyChangeEvent)object2).getNewValues();
                    Hashtable hashtable2 = ((PropertyChangeEvent)object2).getOldValues();
                    object4 = hashtable.keys();
                    while (object4.hasMoreElements()) {
                        object = (String)object4.nextElement();
                        object3 = hashtable.get(object);
                        Object v = hashtable2.get(object);
                        if (object3 == null || v == null) {
                            System.out.println("Error in change detection - " + (String)object + " has null value (new value=" + object3 + ", old value = " + v);
                            continue;
                        }
                        Hashtable hashtable3 = new Hashtable();
                        Hashtable hashtable4 = new Hashtable();
                        hashtable3.put(object, object3);
                        hashtable4.put(object, v);
                        Alert alert = null;
                        if (((String)object).equalsIgnoreCase("OPERATIONAL_STATUS")) {
                            if (!(object3 instanceof Integer) || !(v instanceof Integer)) {
                                System.out.println("Error in change detection - status values are NOT integers");
                                continue;
                            }
                            Vector vector3 = DBConstants.convertOperationalstatusBitValueToArray((int)((Integer)object3));
                            String string6 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)vector3);
                            Vector vector4 = DBConstants.convertOperationalstatusBitValueToArray((int)((Integer)v));
                            String string7 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)vector4);
                            String string8 = ((Integer)object3).toString();
                            String string9 = ((Integer)v).toString();
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Operational Status changed from " + string9 + " to " + string8 + " for device= " + string4 + string3);
                            if (string6.equals(string7)) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Consolidate Status " + string6 + " not changed for device= " + string4 + string3);
                            } else {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Consolidate Status changed from " + string7 + " to " + string6 + " for device= " + string4 + string3);
                                alert = string2.populateOperationalStatusChange(string3, Integer.parseInt(string7), Integer.parseInt(string6));
                            }
                        } else if (((String)object).equalsIgnoreCase("DETECTABLE")) {
                            int n3 = (Integer)object3;
                            int n4 = (Integer)v;
                            this.monitorService.publish((SRMEvent)new DeviceStateChangeEvent(string4, string3, n4, n3));
                            alert = string2.populateStateChange(string3, n3, n4);
                        } else {
                            alert = string2.populatePropertyChange(string3, hashtable4, hashtable3);
                        }
                        if (alert == null) continue;
                        EventHandler.getDataSenderProxy().sendAlert(alert);
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Alert sent for " + object2.getEventName() + " with device= " + string4 + string3);
                    }
                    continue;
                }
                if (object2 instanceof DeviceOperationalStatusChangeEvent) {
                    int n5 = ((DeviceOperationalStatusChangeEvent)object2).getPreviousStatus();
                    object4 = string2.populateOperationalStatusChange(string3, n5, n = ((DeviceOperationalStatusChangeEvent)object2).getCurrentStatus());
                    if (object4 == null) continue;
                    EventHandler.getDataSenderProxy().sendAlert((Alert)object4);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Alert sent for " + object2.getEventName() + " with device= " + string4 + string3);
                    continue;
                }
                if (!(object2 instanceof RelationshipStateChangeEvent)) continue;
                int n6 = ((RelationshipStateChangeEvent)object2).getPreviousState();
                n = ((RelationshipStateChangeEvent)object2).getCurrentState();
                object4 = ((RelationshipStateChangeEvent)object2).getAttributeMap();
                if (object4 == null || ((HashMap)object4).isEmpty()) {
                    object = string2.populateStateChange(string3, n, n6);
                    if (object == null) continue;
                    EventHandler.getDataSenderProxy().sendAlert((Alert)object);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Alert sent for " + object2.getEventName() + " with device= " + string4 + string3);
                    continue;
                }
                hashMap.put(String.valueOf(string4) + string3, object4);
                vector2.add(object2);
            }
            catch (AlertCreationException alertCreationException) {
                if (!traceLogger.isLogging()) continue;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string5, (Throwable)alertCreationException);
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string5, (Throwable)exception);
                }
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string5, "Failed to send alert for " + object2.getEventName() + " with device= " + string4 + string3);
            }
        }
        if (!vector2.isEmpty()) {
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string5, "Process hold Events: " + vector2);
        }
        object2 = vector2.elements();
        while (object2.hasMoreElements()) {
            string4 = (EntityEvent)object2.nextElement();
            string3 = string4.getType();
            string2 = string4.getUniqueId();
            IPopulator iPopulator = this.monitorService.getAlertPopulator(string3);
            if (iPopulator == null) {
                if (errors.get(string3) != null) continue;
                errors.put(string3, new Object());
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string5, "No alert populator found for " + string3 + string2);
                continue;
            }
            try {
                if (string4 instanceof DeviceStateChangeEvent) {
                    int n = ((DeviceStateChangeEvent)string4).getPreviousState();
                    int n7 = ((DeviceStateChangeEvent)string4).getCurrentState();
                    object = iPopulator.populateStateChange(string2, n7, n, hashMap);
                    if (object == null) continue;
                    EventHandler.getDataSenderProxy().sendAlert((Alert)object);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Alert sent for " + string4.getEventName() + " with device= " + string3 + string2);
                    continue;
                }
                if (!(string4 instanceof RelationshipStateChangeEvent)) continue;
                int n = ((RelationshipStateChangeEvent)string4).getPreviousState();
                int n8 = ((RelationshipStateChangeEvent)string4).getCurrentState();
                object = iPopulator.populateStateChange(string2, n8, n, hashMap);
                if (object == null) continue;
                EventHandler.getDataSenderProxy().sendAlert((Alert)object);
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, "Alert sent for " + string4.getEventName() + " with device= " + string3 + string2);
            }
            catch (AlertCreationException alertCreationException) {
                if (!traceLogger.isLogging()) continue;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string5, (Throwable)alertCreationException);
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string5, (Throwable)exception);
                }
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string5, "Failed to send alert for " + string4.getEventName() + " with device= " + string3 + string2);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5, (Object)string);
        }
    }

    private static Notifier getDataSenderProxy() {
        if (notifier == null) {
            notifier = new Notifier();
        }
        return notifier;
    }

    private static void handleAlert(Alert alert) {
        String string = "handleAlert";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string, (Object)alert.toString());
        }
        try {
            if (alert != null) {
                EventHandler.getDataSenderProxy().sendAlert(alert);
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Alert sent for " + alert.toString());
            }
        }
        catch (Exception exception) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "Failed to send alert for " + alert.toString());
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }
}

