/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class FabricAlertPopulator
implements IPopulator {
    public static final String deviceType = "fabric";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.FabricAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public FabricAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getFabricData(string3, hashtable, hashtable2)) {
            int n = Integer.parseInt(string);
            short s = 114;
            int n2 = 103;
            int n3 = EventDBAccessor.getAlertIDByCondition(n2);
            if (n3 > 0) {
                String string4;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n3;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldType = (short)30;
                alertDefinition.aldCondition = (short)n2;
                int n4 = 1;
                int n5 = EventDBAccessor.getComputerId(n4);
                int n6 = 104;
                int[] nArray = MIBConstants.BTAsanRegionEvent;
                int[][] nArray2 = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string5 = "TPC_NEW_DEVICE_EVENT";
                hashtable.put("eventType", string5);
                hashtable2.put("eventType", string5);
                int n7 = 0;
                while (n7 < nArray2.length) {
                    String string6 = this.getSRValue(n7, hashtable);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashtable3.put(nArray2[n7], string6);
                    ++n7;
                }
                String string7 = "SANRegionEvent";
                int n8 = 0;
                while (n8 < srTecSlotNames.length) {
                    string4 = (String)hashtable2.get(srTecSlotNames[n8]);
                    if (string4 == null) {
                        string4 = "";
                    }
                    hashtable4.put(srTecSlotNames[n8], string4);
                    ++n8;
                }
                String string8 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string8);
                string4 = "ALR4046I";
                Object[] objectArray = null;
                objectArray = new Object[]{hashtable.get("label")};
                fabricAlert = new FabricAlert(n5, n, s, alertDefinition, nArray, n6, hashtable3, string7, hashtable4, string4, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: fabric" + string);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: fabric" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getFabricData(string3, hashtable, hashtable2)) {
            short s;
            int n3 = Integer.parseInt(string);
            short s2 = 114;
            int n4 = 91;
            int n5 = n3;
            short s3 = s2;
            int n6 = EventDBAccessor.getAlertIDByResource(s2, n3, n4);
            if (n6 <= 0) {
                int n7 = -1;
                s = 114;
                n6 = EventDBAccessor.getAlertIDByResource(s, n7, n4);
            }
            if (n6 > 0) {
                String string4;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n6;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = (short)n4;
                s = 1;
                int n8 = EventDBAccessor.getComputerId(s);
                int n9 = 101;
                if (n == 1) {
                    n9 = 112;
                }
                int[] nArray = MIBConstants.BTAsanRegionEvent;
                int[][] nArray2 = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string5 = n == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                hashtable.put("eventType", string5);
                hashtable2.put("eventType", string5);
                int n10 = 0;
                while (n10 < nArray2.length) {
                    String string6 = this.getSRValue(n10, hashtable);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashtable3.put(nArray2[n10], string6);
                    ++n10;
                }
                String string7 = "SANRegionEvent";
                int n11 = 0;
                while (n11 < srTecSlotNames.length) {
                    string4 = (String)hashtable2.get(srTecSlotNames[n11]);
                    if (string4 == null) {
                        string4 = "";
                    }
                    hashtable4.put(srTecSlotNames[n11], string4);
                    ++n11;
                }
                String string8 = n == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(hashtable4, string8);
                string4 = "ALR4047W";
                if (n == 1) {
                    string4 = "ALR4048I";
                }
                Object[] objectArray = null;
                objectArray = new Object[]{hashtable.get("label")};
                fabricAlert = new FabricAlert(n8, n5, s3, alertDefinition, nArray, n9, hashtable3, string7, hashtable4, string4, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: fabric" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: fabric" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getFabricData(string3, hashtable, hashtable2)) {
            short s;
            int n3 = Integer.parseInt(string3);
            short s2 = 114;
            int n4 = n3;
            short s3 = s2;
            int n5 = n2 == 0 ? 114 : 113;
            int n6 = EventDBAccessor.getAlertIDByResource(s2, n3, n5);
            if (n6 <= 0) {
                int n7 = -1;
                s = 114;
                n6 = EventDBAccessor.getAlertIDByResource(s, n7, n5);
            }
            if (n6 > 0) {
                String string4;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n6;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = (short)n5;
                s = 1;
                int n8 = EventDBAccessor.getComputerId(s);
                int n9 = 116;
                int[] nArray = MIBConstants.BTAsanRegionEvent;
                int[][] nArray2 = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string5 = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
                hashtable.put("eventType", string5);
                hashtable2.put("eventType", string5);
                int n10 = 0;
                while (n10 < nArray2.length) {
                    String string6 = this.getSRValue(n10, hashtable);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashtable3.put(nArray2[n10], string6);
                    ++n10;
                }
                String string7 = "SEOperationalStatusChangeEvent";
                int n11 = 0;
                while (n11 < srTecSlotNames.length) {
                    string4 = (String)hashtable2.get(srTecSlotNames[n11]);
                    if (string4 == null) {
                        string4 = "";
                    }
                    hashtable4.put(srTecSlotNames[n11], string4);
                    ++n11;
                }
                String string8 = "MINOR";
                this.addCommonTecAttributes(hashtable4, string8);
                this.addOperationalStatusData(hashtable3, hashtable4, n, n2);
                string4 = "ALR4049W";
                if (n2 == 0) {
                    string4 = "ALR4050I";
                }
                Object[] objectArray = null;
                objectArray = new Object[]{hashtable.get("label")};
                fabricAlert = new FabricAlert(n8, n4, s3, alertDefinition, nArray, n9, hashtable3, string7, hashtable4, string4, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: fabric" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: fabric" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private void addOperationalStatusData(Hashtable hashtable, Hashtable hashtable2, int n, int n2) {
        hashtable.put(MIBConstants.BTAOldStatus, "" + n);
        hashtable.put(MIBConstants.BTANewStatus, "" + n2);
        hashtable2.put("oldStatus", "" + n);
        hashtable2.put("oldStatus", "" + n2);
    }

    private String getSRValue(int n, Hashtable hashtable) {
        if (srVarNames[n].equals("description")) {
            return srVarNames[n];
        }
        if (peVarNames[n].equals("messageId")) {
            return srVarNames[n];
        }
        return (String)hashtable.get(srVarNames[n]);
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

