/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class FifoQueue {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    private Vector queue;
    private static int queueSize;
    private static FifoQueue fifoQueue;

    static {
        Class<?> clazz;
        msgLogger = LogConstants.msgLogger;
        traceLogger = LogConstants.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.FifoQueue");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        queueSize = 10;
        fifoQueue = null;
    }

    private FifoQueue(int n) {
        queueSize = n;
        this.queue = new Vector(n);
    }

    public static FifoQueue getQueue() {
        return FifoQueue.getQueue(queueSize);
    }

    public static FifoQueue getQueue(int n) {
        String string = "getQueue";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Input Parameter= " + n));
        }
        if (fifoQueue == null) {
            fifoQueue = new FifoQueue(n);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return fifoQueue;
    }

    public void add(Object object) {
        String string = "add";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Input Parameter= " + object));
        }
        if (queueSize == this.queue.size()) {
            this.queue.removeElementAt(0);
        }
        this.queue.add(object);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public boolean contains(Object object) {
        String string = "contains";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Input Parameter= " + object));
        }
        boolean bl = this.queue.contains(object);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "In FifoQueue.contains: checking if the object is present in the queue.. Result=\"" + bl + "\"");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }
}

