/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class HostAlertPopulator
implements IPopulator {
    public static final String deviceType = "host";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.HostAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public HostAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getHostData(string3, hashtable, hashtable2)) {
            int n = Integer.parseInt(string);
            short s = 1;
            int n2 = 31;
            int n3 = EventDBAccessor.getAlertIDByCondition(n2);
            if (n3 > 0) {
                String string4;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n3;
                alertDefinition.aldProductID = 0;
                int n4 = 1;
                int n5 = EventDBAccessor.getComputerId(n4);
                int n6 = 104;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string5 = "TPC_NEW_DEVICE_EVENT";
                hashtable.put("eventType", string5);
                hashtable2.put("eventType", string5);
                int n7 = 0;
                while (n7 < nArray2.length) {
                    String string6 = this.getPEValue(n7, hashtable);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashtable3.put(nArray2[n7], string6);
                    ++n7;
                }
                String string7 = "PhysicalEntityEvent";
                int n8 = 0;
                while (n8 < peTecSlotNames.length) {
                    string4 = (String)hashtable2.get(peTecSlotNames[n8]);
                    if (string4 == null) {
                        string4 = "";
                    }
                    hashtable4.put(peTecSlotNames[n8], string4);
                    ++n8;
                }
                String string8 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string8);
                string4 = "ALR4041I";
                Object[] objectArray = null;
                String string9 = (String)hashtable.get("label");
                objectArray = new Object[]{string9};
                fabricAlert = new FabricAlert(n5, n, s, alertDefinition, nArray, n6, hashtable3, string7, hashtable4, string4, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined for device: host" + string3);
            }
        } else {
            throw new AlertCreationException("No object found for device: host" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getHostData(string3, hashtable, hashtable2)) {
            int n3 = Integer.parseInt(string3);
            short s = 1;
            short s2 = -1;
            int n4 = -1;
            if (n == 1) {
                s2 = 31;
                n4 = EventDBAccessor.getAlertIDByCondition(s2);
            } else {
                s2 = 15;
                n4 = this.getAlertId(s, n3, s2, string3);
            }
            if (n4 > 0) {
                String string4;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 101;
                if (n == 1) {
                    n7 = 112;
                }
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string5 = n == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                hashtable.put("eventType", string5);
                hashtable2.put("eventType", string5);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string6 = this.getPEValue(n8, hashtable);
                    hashtable3.put(nArray2[n8], string6);
                    ++n8;
                }
                String string7 = "PhysicalEntityEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string4 = (String)hashtable2.get(peTecSlotNames[n9]);
                    hashtable4.put(peTecSlotNames[n9], string4);
                    ++n9;
                }
                String string8 = n == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(hashtable4, string8);
                string4 = "ALR4042W";
                if (n == 1) {
                    string4 = "ALR4043I";
                }
                Object[] objectArray = null;
                String string9 = (String)hashtable.get("label");
                objectArray = new Object[]{string9};
                fabricAlert = new FabricAlert(n6, n3, s, alertDefinition, nArray, n7, hashtable3, string7, hashtable4, string4, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined for device: host" + string3);
            }
        } else {
            throw new AlertCreationException("No object found for device: host" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getHostData(string3, hashtable, hashtable2)) {
            short s;
            short s2 = 1;
            int n3 = Integer.parseInt(string);
            int n4 = this.getAlertId(s2, n3, s = n2 == 0 ? (short)173 : 172, string3);
            if (n4 > 0) {
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 116;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable hashtable4 = new Hashtable();
                String string4 = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
                hashtable.put("eventType", string4);
                hashtable2.put("eventType", string4);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string5 = this.getPEValue(n8, hashtable);
                    if (string5 == null) {
                        string5 = "";
                    }
                    hashtable3.put(nArray2[n8], string5);
                    ++n8;
                }
                String string6 = "PEOperationalStatusChangeEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    hashtable4.put(peTecSlotNames[n9], hashtable2.get(peTecSlotNames[n9]));
                    ++n9;
                }
                String string7 = "MINOR";
                this.addCommonTecAttributes(hashtable4, string7);
                this.addOperationalStatusData(hashtable3, hashtable4, n, n2);
                String string8 = "ALR4044W";
                if (n2 == 0) {
                    string8 = "ALR4045I";
                }
                Object[] objectArray = null;
                String string9 = (String)hashtable.get("label");
                objectArray = new Object[]{string9};
                fabricAlert = new FabricAlert(n6, n3, s2, alertDefinition, nArray, n7, hashtable3, string6, hashtable4, string8, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined for device: host" + string3);
            }
        } else {
            throw new AlertCreationException("No object found for device: host" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    private void addOperationalStatusData(Hashtable hashtable, Hashtable hashtable2, int n, int n2) {
        hashtable.put(MIBConstants.BTAOldStatus, "" + n);
        hashtable.put(MIBConstants.BTANewStatus, "" + n2);
        hashtable2.put("oldStatus", "" + n);
        hashtable2.put("oldStatus", "" + n2);
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private String getPEValue(int n, Hashtable hashtable) {
        if (peVarNames[n].equals("description")) {
            return peVarNames[n];
        }
        if (peVarNames[n].equals("messageId")) {
            return peVarNames[n];
        }
        return (String)hashtable.get(peVarNames[n]);
    }

    private int getAlertId(short s, int n, short s2, String string) {
        int n2 = -1;
        n2 = EventDBAccessor.getAlertIDByResource(s, n, s2);
        if (n2 <= 0) {
            String string2 = EventDBAccessor.getFabricIdForHost(string);
            if (string2 != null && !string2.equals("")) {
                n2 = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(string2), s2);
            }
            if (n2 <= 0) {
                n2 = EventDBAccessor.getAlertIDByResource(s, -1, s2);
            }
        }
        return n2;
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

