/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.aperi.monitor.snmp.Snmp;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.TimeTicks;

public class SnmpPublisher
extends Thread {
    private static SnmpPublisher alerter;
    private static PrintWriter logWriter;
    private static final int STOP_WAIT_TIME = 300000;
    private static final int MIN_EVENT_CATEGORY = 1;
    private static final int MIN_EVENT_ID = 64;
    private static final int ID_ALLOC_SIZE = 64;
    private static int currentID;
    private static SnmpVarBind serverLocation;
    private static String tecBufEvtPath;
    private static Set destinations;
    public static final int[] ALERT_TYPE_OID;
    public static final String ALERT_TYPE_SLOT = "alertType";
    private Snmp snmpList;
    private boolean snmpInitialized;
    private Connection dbc;
    private StringBuffer msgBuffer = new StringBuffer(512);
    private long osLogHandle;
    private String tecServer;
    private int tecPort;
    private boolean alertError;
    private byte shutdownMode;
    private File tempDir;

    static {
        currentID = 1;
        destinations = Collections.synchronizedSet(new HashSet());
        ALERT_TYPE_OID = new int[]{1, 1, 3};
    }

    protected static void startThreads(ThreadGroup threadGroup) {
        alerter = new SnmpPublisher();
        alerter.start();
    }

    protected static void stopThreads(byte by) {
        if (alerter == null) {
            return;
        }
        SnmpPublisher.alerter.shutdownMode = by;
        try {
            alerter.join(300000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void addDestination(String string, int n) {
        Snmp snmp = new Snmp(string, n);
        destinations.add(snmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set set = destinations;
        synchronized (set) {
            Iterator iterator = destinations.iterator();
            while (iterator.hasNext()) {
                try {
                    Snmp snmp = (Snmp)iterator.next();
                    snmp.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            destinations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTrap(SnmpTrap snmpTrap) {
        Set set = destinations;
        synchronized (set) {
            Iterator iterator = destinations.iterator();
            while (iterator.hasNext()) {
                try {
                    Snmp snmp = (Snmp)iterator.next();
                    snmp.send(snmpTrap);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        SnmpPublisher snmpPublisher = new SnmpPublisher();
        snmpPublisher.addDestination("localhost", 162);
        SnmpTrap snmpTrap = new SnmpTrap();
        snmpTrap.agentAddr = new IPAddress("1.2.3.4");
        snmpTrap.enterprise = new OID("1.3.6.1.3.94");
        snmpTrap.genericTrap = 6;
        snmpTrap.specificTrap = 6;
        snmpTrap.senderAddr = new IPAddress("1.2.3.4");
        snmpTrap.timeStamp = new TimeTicks(System.currentTimeMillis());
        snmpTrap.addVarBind(new OID("1.3.6.1.3.94.1.10.1.7.16.0.0.96.105.32.72.24.0.0.0.0.0.0.0.0.1"), (Serializable)((Object)"3"));
        snmpTrap.addVarBind(new OID("1.3.6.1.3.94.1.10.1.6.16.0.0.96.105.32.72.24.0.0.0.0.0.0.0.0.1"), (Serializable)((Object)"2"));
        snmpPublisher.sendTrap(snmpTrap);
        snmpPublisher.close();
    }
}

