/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.core.format.NumberFormatter;

public class StringUtil {
    public static String trimString(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public static String toRgbText(int rgb) {
        if (rgb > 0xFFFFFF) {
            rgb = 0xFFFFFF;
        }
        if (rgb < 0) {
            rgb = 0;
        }
        String str = "000000" + Integer.toHexString(rgb);
        return "#" + str.substring(str.length() - 6);
    }

    public static boolean isValidLocale(String locale) {
        return true;
    }

    public static boolean isBlank(String str) {
        return StringUtil.trimString(str) == null;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isEqual(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }

    public static boolean isEqualIgnoreCase(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equalsIgnoreCase(str2);
    }

    public static String doubleToString(double d, int fNumber) {
        if (fNumber < 0) {
            fNumber = 0;
        }
        String pattern = null;
        switch (fNumber) {
            case 0: {
                pattern = "#0";
                break;
            }
            default: {
                pattern = "#0.";
                StringBuffer b = new StringBuffer(pattern);
                for (int i = 0; i < fNumber; ++i) {
                    b.append('#');
                }
                pattern = b.toString();
            }
        }
        NumberFormatter formatter = new NumberFormatter(ULocale.ENGLISH);
        formatter.applyPattern(pattern);
        String value = formatter.format(d);
        return value;
    }

    public static String extractFileName(String filePathName) {
        if (filePathName == null) {
            return null;
        }
        int dotPos = filePathName.lastIndexOf(46);
        int slashPos = filePathName.lastIndexOf(92);
        if (slashPos == -1) {
            slashPos = filePathName.lastIndexOf(47);
        }
        if (dotPos > slashPos) {
            return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0, dotPos);
        }
        return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0);
    }

    public static String extractFileNameWithSuffix(String filePathName) {
        if (filePathName == null) {
            return null;
        }
        int slashPos = filePathName.lastIndexOf(92);
        if (slashPos == -1) {
            slashPos = filePathName.lastIndexOf(47);
        }
        return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0);
    }

    public static String extractNamespace(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int pos = qualifiedName.indexOf(46);
        if (pos == -1) {
            return null;
        }
        return StringUtil.trimString(qualifiedName.substring(0, pos));
    }

    public static String extractName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int pos = qualifiedName.indexOf(46);
        if (pos == -1) {
            return qualifiedName;
        }
        return StringUtil.trimString(qualifiedName.substring(pos + 1));
    }

    public static String buildQualifiedReference(String namespace, String value) {
        if (StringUtil.isBlank(namespace)) {
            return value;
        }
        return namespace + "." + value;
    }

    public static String trimQuotes(String value) {
        if (value == null) {
            return value;
        }
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

