/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.parser.EncryptedPropertyState;
import org.eclipse.birt.report.model.parser.ExpressionState;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.SimplePropertyListState;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.parser.TextPropertyState;
import org.eclipse.birt.report.model.parser.XmlPropertyState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserHandler;

public abstract class DesignParseState
extends AbstractParseState {
    protected ModuleParserHandler handler = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DesignParseState(ModuleParserHandler theHandler) {
        this.handler = theHandler;
    }

    public XMLParserHandler getHandler() {
        return this.handler;
    }

    public abstract DesignElement getElement();

    protected void setProperty(String propName, String value) {
        DesignElement element = this.getElement();
        ElementPropertyDefn prop = element.getPropertyDefn(propName);
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (prop == null) {
            return;
        }
        Object propValue = null;
        try {
            propValue = prop.validateXml(this.handler.getModule(), value);
        }
        catch (PropertyValueException ex) {
            ex.setElement(element);
            ex.setPropertyName(propName);
            this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
            return;
        }
        element.setProperty(propName, propValue);
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("property")) {
            return new PropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("list-property")) {
            return new ListPropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("expression")) {
            return new ExpressionState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("xml-property")) {
            return new XmlPropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("structure")) {
            return new StructureState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("method")) {
            return new PropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("text-property")) {
            return new TextPropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("html-property")) {
            return new TextPropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("encrypted-property")) {
            return new EncryptedPropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("simple-property-list")) {
            return new SimplePropertyListState(this.handler, this.getElement());
        }
        return super.startElement(tagName);
    }

    static {
        $assertionsDisabled = !DesignParseState.class.desiredAssertionStatus();
    }
}

