/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Stack;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class XMLWriter {
    protected static final String OUTPUT_ENCODING = "UTF-8";
    protected PrintStream out = null;
    protected Stack elementStack = new Stack();
    private boolean elementActive = false;
    private int attrCount = 0;
    protected Stack pendingElementStack = new Stack();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected XMLWriter() {
    }

    public XMLWriter(File outputFile, String signature) throws IOException {
        FileOutputStream stream = new FileOutputStream(outputFile);
        this.out = new PrintStream((OutputStream)stream, false, OUTPUT_ENCODING);
        this.init(signature);
    }

    public XMLWriter(OutputStream os, String signature) throws IOException {
        this.out = new PrintStream(os, false, OUTPUT_ENCODING);
        this.init(signature);
    }

    private void init(String signature) {
        this.writeUTFSignature(signature);
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    protected void writeUTFSignature(String signature) {
        if (OUTPUT_ENCODING.equals(signature)) {
            this.out.write(239);
            this.out.write(187);
            this.out.write(191);
        }
        if ("UnicodeBig".equals(signature)) {
            this.out.write(254);
            this.out.write(255);
        }
        if ("UnicodeLittle".equals(signature)) {
            this.out.write(255);
            this.out.write(254);
        }
        if ("UCS-4Big".equals(signature)) {
            this.out.write(0);
            this.out.write(0);
            this.out.write(254);
            this.out.write(255);
        }
        if ("UnicodeLittle".equals(signature)) {
            this.out.write(0);
            this.out.write(0);
            this.out.write(255);
            this.out.write(254);
        }
    }

    public void close() {
        if (!$assertionsDisabled && this.elementStack.size() != 0) {
            throw new AssertionError();
        }
        this.out.close();
        this.out = null;
    }

    public void startElement(String tagName) {
        this.flushPendingElements();
        this.closeTag();
        this.emitStartTag(tagName);
    }

    protected void emitStartTag(String tagName) {
        this.elementStack.push(tagName);
        this.elementActive = true;
        this.out.print("<");
        this.out.print(tagName);
        this.attrCount = 0;
    }

    private void checkAttribute() {
        this.flushPendingElements();
        if (this.attrCount++ == 3) {
            this.out.print('\n');
            this.attrCount = 0;
        }
    }

    private void flushPendingElements() {
        while (!this.pendingElementStack.isEmpty()) {
            this.closeTag();
            this.emitStartTag((String)this.pendingElementStack.remove(0));
        }
    }

    public void attribute(String attrName, String value) {
        if (value == null) {
            return;
        }
        this.checkAttribute();
        if (!$assertionsDisabled && !this.elementActive) {
            throw new AssertionError();
        }
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                this.out.print("&amp;");
                continue;
            }
            if (c == '<') {
                this.out.print("&lt;");
                continue;
            }
            if (c == '\"') {
                this.out.print("&quot;");
                continue;
            }
            if (c < ' ') {
                this.out.print("&#x");
                this.out.print(Integer.toHexString(c));
                this.out.print(';');
                continue;
            }
            this.out.print(c);
        }
        this.out.print("\"");
    }

    public void attribute(String attrName, int value) {
        if (!$assertionsDisabled && !this.elementActive) {
            throw new AssertionError();
        }
        this.checkAttribute();
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        this.out.print(value);
        this.out.print("\"");
    }

    public void attribute(String attrName, double value) {
        if (!$assertionsDisabled && !this.elementActive) {
            throw new AssertionError();
        }
        this.checkAttribute();
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        this.out.print(value);
        this.out.print("\"");
    }

    public void attribute(String attrName, boolean value) {
        if (!$assertionsDisabled && !this.elementActive) {
            throw new AssertionError();
        }
        this.checkAttribute();
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        this.out.print(value ? "true" : "false");
        this.out.print("\"");
    }

    public void endElement() {
        if (!this.pendingElementStack.isEmpty()) {
            this.pendingElementStack.pop();
            return;
        }
        if (!$assertionsDisabled && this.elementStack.size() <= 0) {
            throw new AssertionError();
        }
        String tagName = (String)this.elementStack.pop();
        if (this.elementActive) {
            this.out.println("/>");
        } else {
            this.out.print("</");
            this.out.print(tagName);
            this.out.println(">");
        }
        this.elementActive = false;
    }

    public void text(String text) {
        this.closeTextTag();
        if (text == null) {
            return;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                this.out.print("&amp;");
                continue;
            }
            if (c == '<') {
                this.out.print("&lt;");
                continue;
            }
            this.out.print(c);
        }
    }

    public void textCDATA(String text) {
        this.closeTextTag();
        if (text == null) {
            return;
        }
        this.out.print("<![CDATA[");
        this.out.print(text);
        this.out.print("]]>");
    }

    public void literal(String text) {
        this.out.print(text);
    }

    private void closeTag() {
        if (!this.elementActive) {
            return;
        }
        this.elementActive = false;
        this.out.println(">");
    }

    protected void closeTextTag() {
        if (!this.elementActive) {
            return;
        }
        this.elementActive = false;
        this.out.print(">");
    }

    public void taggedText(String tag, String text) {
        if (text == null) {
            return;
        }
        this.startElement(tag);
        this.text(text);
        this.endElement();
    }

    public void conditionalStartElement(String element) {
        this.pendingElementStack.push(element);
    }

    public void rgbAttribute(String attrName, int rgb) {
        if (!$assertionsDisabled && !this.elementActive) {
            throw new AssertionError();
        }
        this.checkAttribute();
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        this.out.print(StringUtil.toRgbText(rgb));
        this.out.print("\"");
    }

    static {
        $assertionsDisabled = !XMLWriter.class.desiredAssertionStatus();
    }
}

