/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import com.ibm.log.Level;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DiskProgressLogger
extends ProgressLogger
implements IProgressLogger {
    private LogTraceHelper cLTH;

    public DiskProgressLogger(LogTraceHelper logTraceHelper, String string, String string2, String string3, String string4, String string5) {
        super(null, string, string2, string3, string4, string5);
        this.cLTH = logTraceHelper;
    }

    public void entry() {
        this.cElementCount = 0;
        this.cComplete = false;
        this.log(IRecordType.TYPE_INFO, "entry", this.cEntryMessage, this.cSystemName);
    }

    public void elementDiscovered() {
        if (!this.isHierarchical()) {
            this.advance();
        }
    }

    protected void advance() {
        if (++this.cElementCount % this.getInterval() == 0) {
            this.log(IRecordType.TYPE_INFO, "increment", this.cProgressMessage, Integer.toString(this.cElementCount));
        }
    }

    public void complete() {
        this.cComplete = true;
        this.log(IRecordType.TYPE_INFO, "complete", this.cCompleteMessage, Integer.toString(this.cElementCount));
    }

    public void exit() {
        if (!this.cComplete) {
            this.log(IRecordType.TYPE_ERROR, "exit", this.cFailedMessage, Integer.toString(this.cElementCount));
        }
    }

    protected void log(Level level, String string, String string2, Object object) {
        this.log(level, string, string2, new Object[]{object});
    }

    protected void log(Level level, String string, String string2, Object[] objectArray) {
        if (string2 != null && string2.length() > 0) {
            this.cLTH.logMsg(string2, objectArray);
        }
    }
}

