/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.interfaces.ParameterException;

public class SvcPostCollectionProcess
extends DiscoverProcess {
    public SvcPostCollectionProcess() {
        Class<?> clazz;
        String[] stringArray = new String[1];
        try {
            clazz = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz.getName();
        super("SVC Post Collection Process", false, new String[]{"DEVICEID"}, stringArray);
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"SvcPostCollectionProcess", null);
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result process(Request request, Map map) throws ParameterException, Exception {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{request, map});
        Result result = new Result(1);
        try {
            try {
                DBConnection dBConnection = ServiceUtils.getConnection();
                try {
                    String string = (String)map.get("SUBSYSTEMID");
                    StorageSubsystem storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string, (DBConnection)dBConnection);
                    if (storageSubsystem.getType() == null) throw new ParameterException("Subsystem is null.");
                    result = this.processSVC(storageSubsystem, dBConnection, logTraceHelper);
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (dBConnection == null) throw throwable;
                    dBConnection.close();
                    throw throwable;
                }
                {
                    Object var8_11 = null;
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        logTraceHelper.exit((Object)result);
        return result;
    }

    private Result processSVC(StorageSubsystem storageSubsystem, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        try {
            List list = this.getExtentEntries(storageSubsystem, dBConnection);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StorageExtent storageExtent = (StorageExtent)iterator.next();
                logTraceHelper.traceInfo("StorageExtent : " + storageExtent.getStorageExtentId());
                try {
                    this.UpdateMdisk_Freespace(dBConnection, storageExtent);
                }
                catch (SQLException sQLException) {
                    logTraceHelper.traceAlways("Problem with MDISK FreeSpace update :" + storageExtent.getStorageExtentId());
                }
            }
            int n = storageSubsystem.getSubsystemId();
            String string = "SELECT SUM(TOTAL_MANAGED_SPACE), SUM(REMAINING_MANAGED_SPACE) FROM " + StoragePool.getTablename() + " WHERE (" + "SUBSYSTEM_ID" + " = " + n + " AND " + "PRIMORDIAL" + " = 0 AND " + "DETECTABLE" + " = 1)";
            logTraceHelper.traceInfo("Sending DB2 complex query for VG_Capacity&VG_FreeSpace: " + string);
            DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string, null);
            double d = 0.0;
            double d2 = 0.0;
            while (dBResultSet.next()) {
                d = dBResultSet.getDouble(1);
                d2 = dBResultSet.getDouble(2);
                logTraceHelper.traceInfo("Result: " + Double.toString(d) + "/" + Double.toString(d2));
            }
            dBResultSet.close();
            StorageSubsystem storageSubsystem2 = new StorageSubsystem();
            storageSubsystem2.setName(storageSubsystem.getName());
            storageSubsystem2.setNameFormat(storageSubsystem.getNameFormat());
            storageSubsystem2.setVgCapacity((long)d);
            storageSubsystem2.setVgFreespace((long)d2);
            storageSubsystem2.update(dBConnection);
            dBConnection.commit();
            return new Result(0);
        }
        catch (Exception exception) {
            try {
                dBConnection.rollback();
            }
            catch (SQLException sQLException) {}
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)exception, (LogTraceHelper)logTraceHelper);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getExtentEntries(StorageSubsystem storageSubsystem, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getExtentEntries", (Object[])new Object[]{storageSubsystem, dBConnection});
        LinkedList<StorageExtent> linkedList = new LinkedList<StorageExtent>();
        try {
            try {
                Class<?> clazz;
                ColumnInfo columnInfo = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, Integer.toString(storageSubsystem.getSubsystemId()));
                StorageExtent.StorageExtentCursor storageExtentCursor = StorageExtent.getCursor((DBConnection)dBConnection, hashtable, null);
                while (true) {
                    block8: {
                        if (storageExtentCursor.next()) break block8;
                        storageExtentCursor.close();
                        dBConnection.commit();
                        break;
                    }
                    StorageExtent storageExtent = storageExtentCursor.getObject();
                    logTraceHelper.traceInfo("Found :" + storageExtent.getName());
                    linkedList.add(storageExtent);
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        logTraceHelper.exit(linkedList);
        return linkedList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void UpdateMdisk_Freespace(DBConnection dBConnection, StorageExtent storageExtent) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"UpdateMDisk_Freespace", (Object[])new Object[]{dBConnection, storageExtent});
        String string = String.valueOf(storageExtent.getStorageExtentId());
        double d = storageExtent.getTotalCapacity();
        try {
            String string2 = dBConnection.getSchema();
            String string3 = "select SUM(" + Volume2extent.getTablename() + "." + "TOTAL_NUM_EXTENTS" + " * " + StoragePool.getTablename() + "." + "EXTENT_SIZE" + ") from " + string2 + "." + StorageExtent.getTablename() + " inner join " + Volume2extent.getTablename() + " on " + Volume2extent.getTablename() + "." + "STORAGE_EXTENT_ID" + " = " + StorageExtent.getTablename() + "." + "STORAGE_EXTENT_ID" + " inner join " + StorageVolume.getTablename() + " on " + StorageVolume.getTablename() + "." + "SVID" + " = " + Volume2extent.getTablename() + "." + "VOLUME_ID" + " inner join " + StoragePool.getTablename() + " on " + StoragePool.getTablename() + "." + "POOL_ID" + " = " + StorageVolume.getTablename() + "." + "POOL_ID" + " where " + Volume2extent.getTablename() + "." + "STORAGE_EXTENT_ID" + " = " + string + " group by " + StorageExtent.getTablename() + "." + "STORAGE_EXTENT_ID";
            logTraceHelper.traceInfo("Sending DB2 complex query for calculating used Capacity: " + string3);
            DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string3, null);
            double d2 = 0.0;
            while (true) {
                block4: {
                    if (dBResultSet.next()) break block4;
                    dBResultSet.close();
                    dBConnection.commit();
                    double d3 = (d * 512.0 - d2) / 512.0;
                    StorageExtent storageExtent2 = new StorageExtent();
                    storageExtent2.setDeviceId(storageExtent.getDeviceId());
                    storageExtent2.setSubsystemId(storageExtent.getSubsystemId());
                    storageExtent2.setFreeSpace(d3);
                    storageExtent2.update(dBConnection);
                    dBConnection.commit();
                    break;
                }
                d2 = dBResultSet.getDouble(1) * 1024.0 * 1024.0;
                logTraceHelper.traceInfo("Result: " + Double.toString(d2));
            }
        }
        catch (Throwable throwable) {
            Object var15_13 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var15_14 = null;
        }
        logTraceHelper.exit(null);
    }
}

