/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.mapping.SMISIBMTSSVC_StorageVolumeToDBMapper;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;

public class SVCProtocolControllerPreparationStep
extends SimpleStep {
    protected String cInstanceName = null;
    protected String cMapName = null;

    public SVCProtocolControllerPreparationStep(String string, String string2) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"SVCProtocolControllerPreparationStep", (Object[])new Object[]{string, string2});
        this.cInstanceName = string;
        this.cMapName = string2;
        logTraceHelper.exit(null);
    }

    public boolean process(String string, Map map) throws Exception {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{string});
        boolean bl = true;
        HashMap hashMap = null;
        CIMInstance cIMInstance = (CIMInstance)map.get(this.cInstanceName);
        if (cIMInstance != null) {
            logTraceHelper.traceInfo("Found CIMInstance as step parameter " + this.cInstanceName);
            hashMap = (HashMap)map.get(this.cMapName);
            if (hashMap != null) {
                String string2 = cIMInstance.getObjectPath().toString();
                Hashtable hashtable = CIMProcessor.convertPropertiesToHashtable((Vector)cIMInstance.getAllProperties(), new Hashtable());
                String string3 = (String)map.get("DEVICEID");
                String string4 = (String)hashtable.get("SystemName".toLowerCase());
                String string5 = (String)hashtable.get("VolumeName".toLowerCase());
                String string6 = (String)hashtable.get("VolumeOID".toLowerCase());
                String string7 = (String)hashtable.get("VolumeUniqueID".toLowerCase());
                logTraceHelper.traceInfo("Getting volume info for " + string2.toString());
                String[] stringArray = this.getVolumeInfoFromDatabase(string3, string5, string7);
                if (stringArray[0] == null) {
                    logTraceHelper.traceError("No volume info found for " + string2.toString(), null);
                }
                String string8 = (String)hashtable.get("CollectionScsiID".toLowerCase());
                String string9 = stringArray[0];
                String string10 = String.valueOf(stringArray[1]) + "-" + string6;
                CIMObjectPath cIMObjectPath = new CIMObjectPath();
                cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMTSSVC_Controller", CIMDataType.getPredefinedType((int)8)));
                cIMObjectPath.addKey("DeviceID", new CIMValue((Object)string10, CIMDataType.getPredefinedType((int)8)));
                cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"IBMTSSVC", CIMDataType.getPredefinedType((int)8)));
                cIMObjectPath.addKey("SystemName", new CIMValue((Object)string4, CIMDataType.getPredefinedType((int)8)));
                cIMObjectPath.setNameSpace(new CIMNameSpace(((String[])map.get("CIMOM"))[0], "root/ibm"));
                cIMObjectPath.setObjectName("IBMTSSVC_Controller");
                Vector<String[]> vector = (Vector<String[]>)hashMap.remove(cIMObjectPath);
                if (vector == null) {
                    logTraceHelper.traceInfo("Creating new VolumeInfo list for new controller COP: " + cIMObjectPath.toString());
                    vector = new Vector<String[]>();
                } else {
                    logTraceHelper.traceInfo("Reusing existing VolumeInfo list for existing controller COP: " + cIMObjectPath.toString());
                }
                vector.add(new String[]{string9, string8});
                hashMap.put(cIMObjectPath, vector);
                logTraceHelper.traceInfo("Adding " + vector.size() + ". VolumeInfo [" + string9 + "," + string8 + "] for " + cIMObjectPath.toString() + " to map " + this.cMapName);
                map.put(this.cMapName, hashMap);
            } else {
                logTraceHelper.traceWarning("Did not find map as step parameter " + this.cMapName);
                bl = false;
            }
        } else {
            logTraceHelper.traceWarning("Did not find CIMInstance as step parameter " + this.cInstanceName);
            bl = false;
        }
        if (bl) {
            logTraceHelper.traceInfo("Processing next");
            bl = this.processNext(string, map);
            logTraceHelper.traceInfo("Done processing next");
        }
        logTraceHelper.exit((Object)new Boolean(bl));
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getVolumeInfoFromDatabase(String string, String string2, String string3) {
        LogTraceHelper logTraceHelper;
        String[] stringArray;
        block13: {
            stringArray = new String[2];
            DBConnection dBConnection = ServiceUtils.getConnection();
            logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getVolumeInfoFromDatabase", (Object[])new Object[]{string2, string3});
            string3 = SMISIBMTSSVC_StorageVolumeToDBMapper.transformSVCUniqueId((String)string3);
            try {
                try {
                    String string4 = dBConnection.getSchema();
                    String string5 = "TRSV";
                    String string6 = "TRIG";
                    String string7 = ".";
                    String string8 = "select " + string5 + string7 + "SVID" + "," + string6 + string7 + "GROUP_ID" + " from " + string4 + "." + TResStorageVolumeTable.getTablename() + " " + string5 + "," + string4 + "." + TResIoGroupTable.getTablename() + " " + string6 + " where " + string5 + string7 + "UNIQUE_ID" + " = '" + string3 + "' and " + string5 + string7 + "SUBSYSTEM_ID" + " = " + string + " and " + string5 + string7 + "ELEMENT_NAME" + " = '" + string2 + "' and " + string6 + string7 + "IO_GROUP_ID" + " = " + string5 + string7 + "IO_GROUP_ID";
                    logTraceHelper.traceInfo("Sending DB2 complex query for ExtentCOP to ExtentID: " + string8);
                    DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string8, null);
                    while (true) {
                        block14: {
                            if (dBResultSet.next()) break block14;
                            dBResultSet.close();
                            dBConnection.commit();
                            break;
                        }
                        stringArray[0] = dBResultSet.getString(1);
                        stringArray[1] = dBResultSet.getString(2);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        dBConnection.rollback();
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                    }
                    catch (SQLException sQLException2) {}
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                    }
                }
                logTraceHelper.exit((Object)stringArray);
                throw throwable;
            }
            {
                Object var13_16 = null;
                if (dBConnection == null) break block13;
            }
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            dBConnection.close();
        }
        logTraceHelper.exit((Object)stringArray);
        return stringArray;
    }
}

