/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.CIM.MappingManagementEMC11;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagementSMIS11;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginSMIS11;
import org.eclipse.aperi.disk.control.util.DeleteStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageConfigurationPluginEMC11
extends StorageConfigurationPluginSMIS11 {
    public long[] getDefaultSupportedVolumeSizeRange(StoragePool storagePool, CIMObjectPath cIMObjectPath) throws ServerException, InvalidParameterException, MissingParameterException {
        long[] lArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getDefaultSupportedVolumeSizeRange", (Object[])new Object[]{storagePool, cIMObjectPath});
        long[] lArray2 = new long[]{-1L, -1L, -1L};
        try {
            lArray2[0] = 1L;
            lArray2[1] = storagePool.getTotalAvailableSpace() * 512L;
            lArray2[2] = 1L;
            lArray = lArray2;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            logTraceHelper.exit((Object)lArray2);
            throw throwable;
        }
        logTraceHelper.exit((Object)lArray2);
        return lArray;
    }

    public MappingManagement getMappingManagement() {
        if (this.cMappingManagement == null) {
            this.cMappingManagement = this.cParams.getCapability().getOneHwIdPerView() == 0 ? new MappingManagementEMC11(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken()) : new MappingManagementEMC11(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cMappingManagement;
    }

    public PrivilegeManagement getPrivilegeManagement() {
        if (this.cPrivilegeManagement == null) {
            this.cPrivilegeManagement = new PrivilegeManagementSMIS11(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cPrivilegeManagement;
    }

    public AsyncResult[] deleteStorageVolumes(DeleteStorageVolumesParameter deleteStorageVolumesParameter) throws NotAvailableException, Exception {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)deleteStorageVolumesParameter.getToken(), (Object)this, (String)"deleteStorageVolumes", (Object[])new Object[]{deleteStorageVolumesParameter});
        CIMClientWrapper cIMClientWrapper = CIMClientPool.getClient((String)deleteStorageVolumesParameter.getCimom().getUserId(), (String)deleteStorageVolumesParameter.getCimom().getPassword(), (String)deleteStorageVolumesParameter.getCimom().getServiceUrl(), (String)deleteStorageVolumesParameter.getCimom().getInteropSchemaNamespace());
        cIMClientWrapper.setTimeout(1200000L);
        deleteStorageVolumesParameter.setCIMClientWrapper(cIMClientWrapper);
        CIMObjectPath[] cIMObjectPathArray = deleteStorageVolumesParameter.getStorageVolumeCIMOPs();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        arrayList = this.getMappingManagement().retrieveProtocolControllersForVolumes(cIMObjectPathArray, arrayList2);
        if (arrayList.size() > 0) {
            String[] stringArray = new String[cIMObjectPathArray.length];
            StorageVolume[] storageVolumeArray = deleteStorageVolumesParameter.getStorageVolumes();
            int n = 0;
            while (n < storageVolumeArray.length) {
                stringArray[n] = storageVolumeArray[n].getName();
                ++n;
            }
            CIMObjectPath[] cIMObjectPathArray2 = new CIMObjectPath[arrayList.size()];
            int n2 = 0;
            while (n2 < arrayList.size()) {
                cIMObjectPathArray2[n2] = ((ProtocolControllerToPrivileges)arrayList.get(n2)).getProtocolController();
                ++n2;
            }
            this.getMappingManagement().hidePaths(cIMObjectPathArray2, deleteStorageVolumesParameter.getCapability(), stringArray, null, null);
            n2 = 0;
            while (n2 < cIMObjectPathArray2.length) {
                ArrayList arrayList3 = this.getMappingManagement().retrieveProtocolControllerForUnit(cIMObjectPathArray2[n2]);
                if (arrayList3 == null || arrayList3.isEmpty()) {
                    deleteStorageVolumesParameter.getCIMClientWrapper().deleteInstance(cIMObjectPathArray2[n2], logTraceHelper);
                }
                ++n2;
            }
        }
        AsyncResult[] asyncResultArray = super.deleteStorageVolumes(deleteStorageVolumesParameter);
        return asyncResultArray;
    }
}

