/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSessionFactory;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class SessionSweeper
implements Wakeable {
    private static final int DEFAULT_INTERVAL = 1440;
    private static final int DEFAULT_IDLE_TIME = 720;
    Timer timer = TimerService.scheduleWakeUp(this.convertTime(1440), this);

    private int convertTime(int n) {
        return n * 60 * 1000;
    }

    public void wakeUp(Object object) {
        SnmpSession snmpSession;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("SessionSweeper - sweeping for stale sessions");
        }
        long l = this.convertTime(720);
        Hashtable hashtable = SnmpSessionFactory.getSessions();
        long l2 = System.currentTimeMillis();
        l2 -= l;
        Enumeration enumeration = hashtable.keys();
        hashtable.elements();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            long l3;
            String string = (String)enumeration.nextElement();
            snmpSession = (SnmpSession)hashtable.get(string);
            if (snmpSession == null) continue;
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("SessionSweeper - working on session - " + snmpSession.toString());
            }
            if ((l3 = snmpSession.stats.getLastUsed()) >= l2) continue;
            vector.addElement(string);
        }
        if (!vector.isEmpty()) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("SessionSweeper - removing session - " + vector.elementAt(n2));
                }
                snmpSession = (SnmpSession)hashtable.remove((String)vector.elementAt(n2));
                snmpSession.close();
                ++n2;
            }
        }
    }

    public void stop() {
        TimerService.cancelWakeUp(this.timer);
    }
}

