/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.eclipse.aperi.snmp.AbstractSnmpPoller;
import org.eclipse.aperi.snmp.BackupAlgorithm;
import org.eclipse.aperi.snmp.PollingDriver;
import org.eclipse.aperi.snmp.SessionInfo;
import org.eclipse.aperi.snmp.SessionInfoCommString;
import org.eclipse.aperi.snmp.SessionObservable;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSocket;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpStatistics;
import org.eclipse.aperi.snmp.SnmpTarget;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.Snmp_callback;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.utils.AddressChangeEvent;
import org.eclipse.aperi.snmp.utils.AddressChangeListener;
import org.eclipse.aperi.snmp.utils.Queue;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class SnmpSession
extends SnmpTarget
implements Wakeable,
Observer {
    private static byte[] timeoutData = new byte[1];
    private static Hashtable agents = new Hashtable();
    protected static Vector sessions = new Vector();
    protected String currentHostname;
    protected InetAddress currentAddress = null;
    protected String primaryAddress;
    protected SessionInfo securityInfo;
    protected int retries;
    protected int timeout;
    protected int remotePort;
    protected SnmpSocket socket;
    protected SnmpStatistics stats;
    protected boolean closed;
    protected Hashtable pollDrivers;
    protected int redshift;
    public static final String DEFAULT_COMM_NAME = "public";
    public static final String DEFAULT_SET_COMM = "public";
    public static final int DEFAULT_RETRIES = 3;
    public static final int DEFAULT_TIMEOUT = 1000;
    public static final int DEFAULT_REMOTEPORT = 161;
    private static DatagramSocket timeoutSock = null;
    private static InetAddress localAddr = null;
    private SessionObservable watchMe = null;
    private int max_consecutive_timeouts = 1;
    protected static final int SEND = 0;
    protected static final int TIMEOUT = 1;
    protected int transmit_state = 0;
    private int createTimeoutPeriod = 4000;
    private Timer createTimeoutPeriodTimer = null;
    private int timeoutCount = 0;
    private Vector backupAddresses = null;
    private Object backupAddressLock = new Object();
    private int nextBackup = 0;
    private BackupAlgorithm customBackupAlgorithm = null;
    protected boolean switchedDestination = false;
    protected Vector addressChangeListeners = null;
    protected Object addressChangeLock = new Object();
    private boolean switching = false;
    private boolean useActiveSwitcher = true;
    protected boolean isBroadcast = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpSession(SnmpSession snmpSession) {
        this.canReplayMessages = snmpSession.canReplayMessages;
        this.securityInfo = (SessionInfo)snmpSession.securityInfo.clone();
        this.currentHostname = snmpSession.currentHostname;
        this.currentAddress = snmpSession.currentAddress;
        this.primaryAddress = snmpSession.primaryAddress;
        this.retries = snmpSession.retries;
        this.timeout = snmpSession.timeout;
        this.remotePort = snmpSession.remotePort;
        this.socket = snmpSession.socket;
        this.stats = new SnmpStatistics();
        this.pollDrivers = null;
        this.closed = false;
        this.redshift = snmpSession.redshift;
        this.isBroadcast = snmpSession.isBroadcast;
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpSession(String string, String string2, String string3, int n, int n2, int n3, SnmpSocket snmpSocket) {
        this.canReplayMessages = true;
        this.securityInfo = new SessionInfoCommString(string2, string3);
        this.currentHostname = this.nameToAddr(string);
        this.currentAddress = this.getInetAddress();
        this.primaryAddress = string;
        this.retries = n;
        this.timeout = n2;
        this.remotePort = n3;
        this.socket = snmpSocket;
        this.stats = new SnmpStatistics();
        this.pollDrivers = null;
        this.closed = false;
        this.redshift = (int)(Math.random() * 599.0 + 1.0) * 100;
        if (this.currentAddress.isMulticastAddress()) {
            this.isBroadcast = true;
            this.timeout <<= this.retries - this.timeout;
        }
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpSession(String string, OctetString octetString, OctetString octetString2, int n, int n2, int n3, SnmpSocket snmpSocket) {
        this.canReplayMessages = true;
        this.securityInfo = new SessionInfoCommString(octetString, octetString2);
        this.currentHostname = this.nameToAddr(string);
        this.currentAddress = this.getInetAddress();
        this.primaryAddress = string;
        this.retries = n;
        this.timeout = n2;
        this.remotePort = n3;
        this.socket = snmpSocket;
        this.stats = new SnmpStatistics();
        this.pollDrivers = null;
        this.closed = false;
        this.redshift = (int)(Math.random() * 599.0 + 1.0) * 100;
        if (this.currentAddress.isMulticastAddress()) {
            this.isBroadcast = true;
            this.timeout <<= this.retries;
        }
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("IP:");
        stringBuffer.append(this.primaryAddress);
        stringBuffer.append(this.securityInfo.toString());
        stringBuffer.append(" retries:");
        stringBuffer.append(this.retries);
        stringBuffer.append(" timeout:");
        stringBuffer.append(this.timeout);
        stringBuffer.append(" port:");
        stringBuffer.append(this.port);
        stringBuffer.append(" is broadcast:");
        stringBuffer.append(this.isBroadcast);
        return stringBuffer.toString();
    }

    public void update(Observable observable, Object object) {
        SnmpSession snmpSession = (SnmpSession)object;
        this.retries = snmpSession.retries;
        this.timeout = snmpSession.timeout;
        this.remotePort = snmpSession.remotePort;
        this.redshift = snmpSession.redshift;
        this.changeCommName(snmpSession.getCommName());
        this.changeSetCommName(snmpSession.getSetCommName());
    }

    public synchronized void cancelRedShift() throws Exception {
        if (this.pollDrivers == null || this.pollDrivers.size() == 0) {
            this.redshift = 0;
            if (this.watchMe != null) {
                this.watchMe.parmsChanged(this);
            }
        } else {
            throw new Exception("red shift cannot be cancelled once pollers have been added");
        }
    }

    public static SnmpSession open(String string) throws SnmpUnknownHostException, SnmpSocketException {
        return SnmpSession.open(string, "public", "public", 3, 1000, 161);
    }

    public static SnmpSession open(String string, String string2) throws SnmpUnknownHostException, SnmpSocketException {
        return SnmpSession.open(string, string2, "public", 3, 1000, 161);
    }

    public static SnmpSession open(String string, String string2, String string3) throws SnmpUnknownHostException, SnmpSocketException {
        return SnmpSession.open(string, string2, string3, 3, 1000, 161);
    }

    public static SnmpSession open(String string, String string2, String string3, int n, int n2, int n3) throws SnmpUnknownHostException, SnmpSocketException {
        if (SnmpSession.validateInfo(string)) {
            String string4 = null;
            try {
                string4 = InetAddress.getByName(string).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new SnmpUnknownHostException(string);
            }
            SnmpSocket snmpSocket = SnmpSocket.getSocket(string4);
            return new SnmpSession(string, string2, string3, n, n2, n3, snmpSocket);
        }
        return null;
    }

    public static SnmpSession open(String string, OctetString octetString, OctetString octetString2, int n, int n2, int n3) throws SnmpUnknownHostException, SnmpSocketException {
        if (SnmpSession.validateInfo(string)) {
            String string2 = null;
            try {
                string2 = InetAddress.getByName(string).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new SnmpUnknownHostException(string);
            }
            SnmpSocket snmpSocket = SnmpSocket.getSocket(string2);
            return new SnmpSession(string, octetString, octetString2, n, n2, n3, snmpSocket);
        }
        return null;
    }

    protected static boolean validateInfo(String string) throws SnmpSocketException, SnmpUnknownHostException {
        if (!SnmpV1API.initialized) {
            throw new SnmpSocketException("SnmpV1API is not available");
        }
        if (localAddr == null) {
            SnmpSession.initCommonStuff();
        }
        return true;
    }

    private static synchronized void initCommonStuff() throws SnmpUnknownHostException, SnmpSocketException {
        block4: {
            try {
                localAddr = InetAddress.getLocalHost();
                timeoutSock = (DatagramSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new DatagramSocket();
                    }
                });
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("SnmpSession: unknown host exception consumed: fix me!!!!!");
                localAddr = null;
                timeoutSock = null;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof UnknownHostException) {
                    System.out.println("SnmpSession: unknown host exception consumed: fix me!!!!!");
                    localAddr = null;
                    timeoutSock = null;
                }
                if (!(exception instanceof SocketException)) break block4;
                localAddr = null;
                timeoutSock = null;
                throw new SnmpSocketException(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("SnmpSession closed to " + this.primaryAddress);
        }
        this.closed = true;
        this.socket.closedSession(this);
        Vector vector = sessions;
        synchronized (vector) {
            sessions.removeElement(this);
            if (sessions.isEmpty()) {
                SnmpSocket.closeSocket();
            }
        }
    }

    public void send(SnmpPDU snmpPDU, Queue queue) {
        this.socket.send(this, snmpPDU, queue, null, null, false);
    }

    public void send(SnmpPDU snmpPDU, Object object, Object object2) {
        this.socket.send(this, snmpPDU, null, object, object2, false);
    }

    public void send(SnmpPDU[] snmpPDUArray, Queue queue) {
        int n = snmpPDUArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (snmpPDUArray[n2] != null) {
                this.socket.send(this, snmpPDUArray[n2], queue, null, null, false);
            }
            ++n2;
        }
    }

    public void send(SnmpPDU snmpPDU, DatagramPacket datagramPacket, Queue queue) {
        this.socket.send(this, snmpPDU, datagramPacket, queue, null, null);
    }

    public void send(SnmpPDU[] snmpPDUArray, DatagramPacket[] datagramPacketArray, Queue queue) {
        int n = snmpPDUArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (snmpPDUArray[n2] != null) {
                this.socket.send(this, snmpPDUArray[n2], datagramPacketArray[n2], queue, null, null);
            }
            ++n2;
        }
    }

    public void send(SnmpPDU snmpPDU, DatagramPacket datagramPacket, Object object, Object object2) {
        this.socket.send(this, snmpPDU, datagramPacket, null, object, object2);
    }

    public void send(SnmpPDU[] snmpPDUArray, DatagramPacket[] datagramPacketArray, Object object, Object object2) {
        int n = snmpPDUArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (snmpPDUArray[n2] != null) {
                this.socket.send(this, snmpPDUArray[n2], datagramPacketArray[n2], null, object, object2);
            }
            ++n2;
        }
    }

    public SnmpPDU send(SnmpPDU snmpPDU) {
        SnmpPDU snmpPDU2 = null;
        Queue queue = new Queue(true);
        this.send(snmpPDU, queue);
        snmpPDU2 = (SnmpPDU)queue.dequeue();
        return snmpPDU2;
    }

    public SnmpV2PDU send(SnmpV2PDU snmpV2PDU) {
        SnmpV2PDU snmpV2PDU2 = null;
        Queue queue = new Queue(true);
        this.send((SnmpPDU)snmpV2PDU, queue);
        snmpV2PDU2 = (SnmpV2PDU)queue.dequeue();
        return snmpV2PDU2;
    }

    protected SnmpPDU send(SnmpPDU snmpPDU, boolean bl) {
        SnmpPDU snmpPDU2 = null;
        Queue queue = new Queue(true);
        this.socket.send(this, snmpPDU, bl, queue, null, null, false);
        snmpPDU2 = (SnmpPDU)queue.dequeue();
        return snmpPDU2;
    }

    public final SnmpStatistics getSnmpStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AbstractSnmpPoller abstractSnmpPoller, Object object) {
        PollingDriver pollingDriver;
        Object object2 = this;
        synchronized (object2) {
            if (this.pollDrivers == null) {
                this.pollDrivers = new Hashtable();
            }
        }
        object2 = new Integer(abstractSnmpPoller.interval.interval);
        Hashtable hashtable = this.pollDrivers;
        synchronized (hashtable) {
            pollingDriver = (PollingDriver)this.pollDrivers.get(object2);
            if (pollingDriver == null) {
                pollingDriver = new PollingDriver(this, abstractSnmpPoller.interval.interval);
                this.pollDrivers.put(object2, pollingDriver);
            }
        }
        pollingDriver.add(abstractSnmpPoller, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AbstractSnmpPoller[] abstractSnmpPollerArray, Object object) throws Exception {
        PollingDriver pollingDriver;
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this.pollDrivers == null) {
                this.pollDrivers = new Hashtable();
            }
        }
        boolean bl = true;
        int n = abstractSnmpPollerArray[0].interval.interval;
        int n2 = 1;
        while (bl && n2 < abstractSnmpPollerArray.length) {
            bl = n == abstractSnmpPollerArray[n2].interval.interval;
            ++n2;
        }
        if (!bl) {
            throw new Exception("all pollers in the array must have the same polling interval");
        }
        Integer n3 = new Integer(abstractSnmpPollerArray[0].interval.interval);
        Object object2 = this.pollDrivers;
        synchronized (object2) {
            pollingDriver = (PollingDriver)this.pollDrivers.get(n3);
            if (pollingDriver == null) {
                pollingDriver = new PollingDriver(this, n);
                this.pollDrivers.put(n3, pollingDriver);
            }
        }
        object2 = pollingDriver;
        synchronized (object2) {
            int n4 = 0;
            while (n4 < abstractSnmpPollerArray.length) {
                pollingDriver.add(abstractSnmpPollerArray[n4], object);
                ++n4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AbstractSnmpPoller abstractSnmpPoller) {
        Integer n = new Integer(abstractSnmpPoller.interval.interval);
        if (this.pollDrivers != null) {
            Hashtable hashtable = this.pollDrivers;
            synchronized (hashtable) {
                PollingDriver pollingDriver = (PollingDriver)this.pollDrivers.get(n);
                if (pollingDriver != null) {
                    pollingDriver.remove(abstractSnmpPoller);
                    if (pollingDriver.count() == 0) {
                        this.pollDrivers.remove(n);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AbstractSnmpPoller[] abstractSnmpPollerArray) throws Exception {
        Integer n = new Integer(abstractSnmpPollerArray[0].interval.interval);
        boolean bl = true;
        int n2 = abstractSnmpPollerArray[0].interval.interval;
        int n3 = 1;
        while (bl && n3 < abstractSnmpPollerArray.length) {
            bl = n2 == abstractSnmpPollerArray[n3].interval.interval;
            ++n3;
        }
        if (!bl) {
            throw new Exception("all pollers in the array must have the same polling interval");
        }
        if (this.pollDrivers != null) {
            Hashtable hashtable = this.pollDrivers;
            synchronized (hashtable) {
                PollingDriver pollingDriver = (PollingDriver)this.pollDrivers.get(n);
                if (pollingDriver != null) {
                    PollingDriver pollingDriver2 = pollingDriver;
                    synchronized (pollingDriver2) {
                        int n4 = 0;
                        while (n4 < abstractSnmpPollerArray.length) {
                            pollingDriver.remove(abstractSnmpPollerArray[n4]);
                            ++n4;
                        }
                    }
                    if (pollingDriver.count() == 0) {
                        this.pollDrivers.remove(n);
                    }
                }
            }
        }
    }

    public SnmpPDU makePDU() {
        if (this.securityInfo != null) {
            if (this.securityInfo.version == 2) {
                return new SnmpV2PDU();
            }
            return new SnmpPDU();
        }
        return new SnmpPDU();
    }

    public SnmpPDU makePDU(SnmpPDU snmpPDU) {
        if (this.securityInfo != null) {
            if (this.securityInfo.version == 2) {
                return new SnmpV2PDU((SnmpV2PDU)snmpPDU);
            }
            return new SnmpPDU(snmpPDU);
        }
        return new SnmpPDU(snmpPDU);
    }

    public SnmpPDU decodeMessage(byte[] byArray, int n) {
        if (this.securityInfo == null) {
            return null;
        }
        if (this.securityInfo.version == 2) {
            return SnmpAsn1.decodeV2PDU(byArray, n);
        }
        return SnmpAsn1.decodePDU(byArray, n);
    }

    private String nameToAddr(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public String getIpAddress() {
        return this.currentHostname;
    }

    public String getPrimaryIpAddress() {
        return this.primaryAddress;
    }

    public InetAddress getInetAddress() {
        if (this.currentAddress == null) {
            try {
                this.currentAddress = InetAddress.getByName(this.currentHostname);
            }
            catch (Exception exception) {}
        }
        return this.currentAddress;
    }

    public String getCommName() {
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return "";
        }
        return ((SessionInfoCommString)this.securityInfo).get_getCommunityName();
    }

    public String getSetCommName() {
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return "";
        }
        return ((SessionInfoCommString)this.securityInfo).get_setCommunityName();
    }

    public OctetString getCommNameOctet() {
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return null;
        }
        return ((SessionInfoCommString)this.securityInfo).get_getCommunityNameOctet();
    }

    public OctetString getSetCommNameOctet() {
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return null;
        }
        return ((SessionInfoCommString)this.securityInfo).get_setCommunityNameOctet();
    }

    public void changeCommName(String string) {
        boolean bl;
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return;
        }
        boolean bl2 = bl = !string.equals(((SessionInfoCommString)this.securityInfo).getCommunityName);
        if (!bl) {
            return;
        }
        ((SessionInfoCommString)this.securityInfo).set_getCommunityName(string);
        this.completeChange();
    }

    public void changeCommName(OctetString octetString) {
        boolean bl;
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return;
        }
        boolean bl2 = bl = !octetString.equals(((SessionInfoCommString)this.securityInfo).get_getCommunityNameOctet());
        if (!bl) {
            return;
        }
        ((SessionInfoCommString)this.securityInfo).set_getCommunityName(octetString);
        this.completeChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeChange() {
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
        this.transmit_state = 0;
        if (this.pollDrivers == null) {
            return;
        }
        Hashtable hashtable = this.pollDrivers;
        synchronized (hashtable) {
            Enumeration enumeration = this.pollDrivers.elements();
            while (enumeration.hasMoreElements()) {
                PollingDriver pollingDriver = (PollingDriver)enumeration.nextElement();
                pollingDriver.anyChanges = true;
            }
        }
    }

    public void changeSetCommName(String string) {
        boolean bl;
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return;
        }
        boolean bl2 = bl = !string.equals(((SessionInfoCommString)this.securityInfo).setCommunityName);
        if (!bl) {
            return;
        }
        ((SessionInfoCommString)this.securityInfo).set_setCommunityName(string);
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
        this.transmit_state = 0;
    }

    public void changeSetCommName(OctetString octetString) {
        boolean bl;
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return;
        }
        boolean bl2 = bl = !octetString.equals(((SessionInfoCommString)this.securityInfo).get_setCommunityNameOctet());
        if (!bl) {
            return;
        }
        ((SessionInfoCommString)this.securityInfo).set_setCommunityName(octetString);
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
        this.transmit_state = 0;
    }

    public int getVersion() {
        return this.securityInfo.version;
    }

    public void setVersion(int n) {
        this.securityInfo.version = n;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public int getRetries() {
        return this.retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void changeRetries(int n) {
        this.retries = n;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public void changeTimeout(int n) {
        this.timeout = n;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public void changeMaxconsecutiveTimeouts(int n) {
        this.max_consecutive_timeouts = n;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public void changeRemotePort(int n) {
        this.remotePort = n;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public final synchronized SessionObservable getObservable() {
        if (this.watchMe == null) {
            this.watchMe = new SessionObservable();
        }
        return this.watchMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(String string) {
        try {
            this.switchedDestination = true;
            this.socket = SnmpSocket.getSocket(string);
            if (this.pollDrivers != null) {
                Hashtable hashtable = this.pollDrivers;
                synchronized (hashtable) {
                    Enumeration enumeration = this.pollDrivers.elements();
                    while (enumeration.hasMoreElements()) {
                        PollingDriver pollingDriver = (PollingDriver)enumeration.nextElement();
                        pollingDriver.anyChanges = true;
                    }
                }
            }
            this.currentHostname = this.nameToAddr(string);
            this.currentAddress = null;
            if (this.watchMe != null) {
                this.watchMe.parmsChanged(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackupAddress(String string) {
        Object object = this.backupAddressLock;
        synchronized (object) {
            if (this.backupAddresses == null) {
                this.backupAddresses = new Vector();
                this.backupAddresses.addElement(string);
                this.nextBackup = 0;
            } else if (this.backupAddresses.indexOf(string) < 0) {
                this.backupAddresses.addElement(string);
            }
        }
    }

    public void addBackupAddresses(String string) {
        System.out.println("NOT ADDING ADDRESSES!!!!!!!!!!!!!! SnmpSession.java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackupAddresses(Vector vector) {
        int n = 0;
        if (vector == null) {
            return;
        }
        n = vector.size();
        Object object = this.backupAddressLock;
        synchronized (object) {
            int n2 = 0;
            while (n2 < n) {
                this.addBackupAddress((String)vector.elementAt(n2));
                ++n2;
            }
        }
    }

    public Vector getBackupAddresses() {
        return this.backupAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBackupAddresses() {
        Object object = this.backupAddressLock;
        synchronized (object) {
            if (this.backupAddresses != null) {
                this.backupAddresses.removeAllElements();
                this.nextBackup = 0;
            }
        }
    }

    public String getCurrentAddress() {
        return this.currentHostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddressChangeListener(AddressChangeListener addressChangeListener) {
        Object object = this.addressChangeLock;
        synchronized (object) {
            if (this.addressChangeListeners == null) {
                this.addressChangeListeners = new Vector();
            }
            if (!this.addressChangeListeners.contains(addressChangeListener)) {
                this.addressChangeListeners.addElement(addressChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddressChangeListener(AddressChangeListener addressChangeListener) {
        Object object = this.addressChangeLock;
        synchronized (object) {
            if (this.addressChangeListeners != null && this.addressChangeListeners.contains(addressChangeListener)) {
                this.addressChangeListeners.removeElement(addressChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBackupAddress(String string) {
        Object object = this.backupAddressLock;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.backupAddresses != null) break block5;
                    return false;
                }
                if (this.backupAddresses.indexOf(string) >= 0) break block6;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBackupAddress(String string) {
        Object object = this.backupAddressLock;
        synchronized (object) {
            if (this.backupAddresses != null) {
                int n = this.backupAddresses.indexOf(string);
                if (n < 0) {
                    return;
                }
                if (n < this.nextBackup) {
                    --this.nextBackup;
                }
                this.backupAddresses.removeElementAt(n);
            }
        }
    }

    public void setBackupAlgorithm(BackupAlgorithm backupAlgorithm) {
        this.customBackupAlgorithm = backupAlgorithm;
    }

    public void clearBackupAlgorithm() {
        this.customBackupAlgorithm = null;
    }

    public void invalidateCurrentDestination() {
        this.switchDest();
    }

    protected void timeoutReceived() {
        ++this.timeoutCount;
        if (this.timeoutCount > this.max_consecutive_timeouts) {
            this.switchDest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchDest() {
        if (this.backupAddresses != null || this.customBackupAlgorithm != null) {
            Object object;
            Object object2;
            Enumeration enumeration;
            String string = null;
            this.timeoutCount = 0;
            if (this.customBackupAlgorithm != null) {
                try {
                    string = this.customBackupAlgorithm.getBackupAddress();
                    this.socket.closedSession(this);
                    this.socket = SnmpSocket.getSocket(string);
                    this.switchedDestination = true;
                }
                catch (Exception exception) {
                    System.out.println("SnmpSession:Switch to backup failed");
                    exception.printStackTrace();
                }
            } else {
                if (this.useActiveSwitcher) {
                    if (!this.switching) {
                        this.switching = true;
                        ActiveSwitcher activeSwitcher = new ActiveSwitcher(this);
                        activeSwitcher.start();
                    }
                    return;
                }
                try {
                    enumeration = this.backupAddressLock;
                    synchronized (enumeration) {
                        if (this.nextBackup >= this.backupAddresses.size()) {
                            string = this.primaryAddress;
                            this.nextBackup = 0;
                        } else {
                            string = (String)this.backupAddresses.elementAt(this.nextBackup++);
                        }
                    }
                    this.socket.closedSession(this);
                    this.socket = SnmpSocket.getSocket(string);
                    this.switchedDestination = true;
                }
                catch (Exception exception) {
                    System.out.println("SnmpSession:Switch to backup failed");
                    exception.printStackTrace();
                }
            }
            if (this.pollDrivers != null) {
                enumeration = this.pollDrivers;
                synchronized (enumeration) {
                    object2 = this.pollDrivers.elements();
                    while (object2.hasMoreElements()) {
                        object = (PollingDriver)object2.nextElement();
                        ((PollingDriver)object).anyChanges = true;
                    }
                }
            }
            System.out.println("+++++++++++ SnmpSession: Switching to backup: new addr=" + string);
            if (this.watchMe != null) {
                this.watchMe.parmsChanged(this);
            }
            enumeration = null;
            object2 = this.addressChangeLock;
            synchronized (object2) {
                if (this.addressChangeListeners != null) {
                    enumeration = this.addressChangeListeners.elements();
                }
            }
            if (enumeration != null) {
                object = new AddressChangeEvent(this, this.currentHostname, string);
                while (enumeration.hasMoreElements()) {
                    try {
                        object2 = (AddressChangeListener)enumeration.nextElement();
                        object2.ipAddressChanged((AddressChangeEvent)object);
                    }
                    catch (Exception exception) {
                        System.out.println("Recovered from following exception:");
                        exception.printStackTrace();
                    }
                }
            }
            this.currentHostname = this.nameToAddr(string);
            this.currentAddress = null;
            this.securityInfo = this.getSecurityInfoForAddress(string);
        } else {
            this.transmit_state = 1;
            this.createTimeoutPeriodTimer = TimerService.scheduleWakeUp(this.createTimeoutPeriod, this, null);
        }
    }

    public void wakeUp(Object object) {
        this.transmit_state = 0;
        this.createTimeoutPeriodTimer = null;
    }

    protected void dataReceived() {
        this.timeoutCount = 0;
        this.transmit_state = 0;
        if (this.createTimeoutPeriodTimer != null) {
            TimerService.cancelWakeUp(this.createTimeoutPeriodTimer);
            this.createTimeoutPeriodTimer = null;
        }
    }

    private SessionInfo getSecurityInfoForAddress(String string) {
        System.out.println("SnmpSession: returning old securityInfo after address change");
        return this.securityInfo;
    }

    public SessionInfo getSecurityInfo() {
        return this.securityInfo;
    }

    protected boolean isSwitching() {
        return this.switching;
    }

    public void setMaxTimeouts(int n) {
        if (n > 0) {
            this.max_consecutive_timeouts = n;
        }
    }

    class ActiveSwitcher
    extends Thread
    implements Snmp_callback {
        private SnmpSession session;
        private int foundOne = -1;
        private int numBads = 0;
        private int numSends = 0;

        ActiveSwitcher(SnmpSession snmpSession2) {
            this.session = snmpSession2;
        }

        public synchronized void handle_response(int n, SnmpMetaPDU snmpMetaPDU, SnmpSession snmpSession, Object object) {
            if (this.foundOne > 0) {
                return;
            }
            System.out.println("In active Switcher callback+++++++++++++++");
            switch (((SnmpPDU)snmpMetaPDU).errorStatus) {
                case 100: 
                case 101: 
                case 102: 
                case 103: {
                    System.out.println("In active Switcher callback -- bad +++++++++++++++");
                    ++this.numBads;
                    break;
                }
                default: {
                    System.out.println("In active Switcher callback -- good +++++++++++++++");
                    this.foundOne = (Integer)object;
                    this.notifyAll();
                }
            }
            if (this.numBads >= this.numSends) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setName("ActiveSwitcher" + this.session.primaryAddress);
            System.out.println("In active Switcher");
            if (this.session.backupAddresses != null) {
                Object object;
                Object object2;
                Object object3;
                String string = null;
                try {
                    object3 = this.session.backupAddressLock;
                    synchronized (object3) {
                        object2 = null;
                        SnmpPDU snmpPDU = this.session.makePDU();
                        snmpPDU.operation = 0;
                        boolean bl = true;
                        snmpPDU.addVarBind("1.3.6.1.2.1.1.2.0");
                        SnmpSocket snmpSocket = SnmpSocket.getSocket(this.session.primaryAddress);
                        object = this.session.getSecurityInfoForAddress(this.session.primaryAddress);
                        if (bl) {
                            snmpPDU.communityString = ((SessionInfoCommString)object).getCommunityNameOctet;
                            object2 = this.session.securityInfo;
                            this.session.securityInfo = null;
                        } else {
                            this.session.securityInfo = object;
                        }
                        ActiveSwitcher activeSwitcher = this;
                        synchronized (activeSwitcher) {
                            System.out.println("Sending test to " + this.session.primaryAddress);
                            snmpSocket.send(this.session, snmpPDU, null, this, (Object)new Integer(0), true);
                            ++this.numSends;
                            if (bl) {
                                this.session.securityInfo = object2;
                            }
                            int n = this.session.backupAddresses.size();
                            int n2 = 0;
                            while (n2 < n) {
                                String string2 = (String)this.session.backupAddresses.elementAt(n2);
                                snmpSocket = SnmpSocket.getSocket(string2);
                                object = this.session.getSecurityInfoForAddress(string2);
                                if (bl) {
                                    snmpPDU.communityString = ((SessionInfoCommString)object).getCommunityNameOctet;
                                    object2 = this.session.securityInfo;
                                    this.session.securityInfo = null;
                                } else {
                                    this.session.securityInfo = object;
                                }
                                System.out.println("Sending test to " + string2);
                                snmpSocket.send(this.session, snmpPDU, null, this, (Object)new Integer(n2 + 1), true);
                                ++this.numSends;
                                if (bl) {
                                    this.session.securityInfo = object2;
                                }
                                ++n2;
                            }
                            this.wait();
                        }
                        if (this.foundOne >= 0) {
                            System.out.println("Found one = " + this.foundOne);
                            if (this.foundOne == 0) {
                                string = this.session.primaryAddress;
                                this.session.nextBackup = 0;
                            } else {
                                string = (String)this.session.backupAddresses.elementAt(this.foundOne - 1);
                                this.session.nextBackup = this.foundOne;
                            }
                            this.session.switchedDestination = true;
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("SnmpSession:Switch to backup failed");
                    exception.printStackTrace();
                }
                if (this.session.pollDrivers != null) {
                    object3 = this.session.pollDrivers;
                    synchronized (object3) {
                        Enumeration enumeration = this.session.pollDrivers.elements();
                        while (enumeration.hasMoreElements()) {
                            object2 = (PollingDriver)enumeration.nextElement();
                            ((PollingDriver)object2).anyChanges = true;
                        }
                    }
                }
                if (this.session.switchedDestination) {
                    object3 = this.session.socket;
                    try {
                        this.session.socket = SnmpSocket.getSocket(string);
                        ((SnmpSocket)object3).closedSession(this.session);
                    }
                    catch (Exception exception) {
                        this.session.socket = object3;
                        this.session.switching = false;
                        return;
                    }
                    System.out.println("+++++++++++ SnmpSession: Switching to backup: new addr=" + string);
                    if (this.session.watchMe != null) {
                        this.session.watchMe.parmsChanged(this.session);
                    }
                    Enumeration enumeration = null;
                    object2 = this.session.addressChangeLock;
                    synchronized (object2) {
                        if (this.session.addressChangeListeners != null) {
                            enumeration = this.session.addressChangeListeners.elements();
                        }
                    }
                    if (enumeration != null) {
                        object = new AddressChangeEvent(this, this.session.currentHostname, string);
                        while (enumeration.hasMoreElements()) {
                            try {
                                object2 = (AddressChangeListener)enumeration.nextElement();
                                object2.ipAddressChanged((AddressChangeEvent)object);
                            }
                            catch (Exception exception) {
                                System.out.println("Recovered from following exception:");
                                exception.printStackTrace();
                            }
                        }
                    }
                    this.session.currentHostname = SnmpSession.this.nameToAddr(string);
                    this.session.currentAddress = null;
                    this.session.securityInfo = this.session.getSecurityInfoForAddress(string);
                    this.session.timeoutCount = 0;
                }
            } else {
                this.session.transmit_state = 1;
                this.session.createTimeoutPeriodTimer = TimerService.scheduleWakeUp(this.session.createTimeoutPeriod, this.session, null);
            }
            this.session.switching = false;
        }
    }
}

