/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpV2PDU;

public class V2TrapReceiver
implements Runnable {
    private DatagramSocket sock;
    private byte[] buffer = new byte[1500];
    private DatagramPacket packet;
    private SnmpV2PDU trap;
    private Vector listeners = new Vector();

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            try {
                V2TrapReceiver v2TrapReceiver = new V2TrapReceiver(Integer.parseInt(stringArray[0]), -1);
                Thread thread = new Thread(v2TrapReceiver);
                thread.start();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        } else {
            System.out.println("usage : java V2TrapReceiver <port number>");
        }
    }

    public V2TrapReceiver() throws SocketException, RemoteException {
        this.initialize(162, 2099);
    }

    public V2TrapReceiver(int n) throws SocketException, RemoteException {
        this.initialize(n, 2099);
    }

    public V2TrapReceiver(int n, int n2) throws SocketException, RemoteException {
        this.initialize(n, n2);
    }

    private void initialize(int n, int n2) throws SocketException {
        final int n3 = n;
        try {
            this.sock = (DatagramSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new DatagramSocket(n3);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof SocketException) {
                throw (SocketException)exception;
            }
            exception.printStackTrace();
        }
    }

    public void terminate() {
        byte[] byArray = new byte[1];
        try {
            final DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getLocalHost(), this.sock.getLocalPort());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    V2TrapReceiver.this.sock.send(datagramPacket);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            System.out.println("V2TrapReceiver: not terminated:" + exception.toString());
        }
    }

    public void run() {
        Thread.currentThread().setName("V2TrapReceiver");
        while (true) {
            try {
                this.packet = (DatagramPacket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        DatagramPacket datagramPacket = new DatagramPacket(V2TrapReceiver.this.buffer, V2TrapReceiver.this.buffer.length);
                        V2TrapReceiver.this.sock.receive(datagramPacket);
                        return datagramPacket;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                System.out.println("Receive failed - error : " + privilegedActionException.getException().toString());
            }
            if (this.packet.getLength() == 1) {
                this.sock.close();
                return;
            }
            byte[] byArray = this.packet.getData();
            this.trap = SnmpAsn1.decodeV2PDU(byArray, this.packet.getLength());
            System.out.println("Received V2 PDU : " + this.trap.toString());
        }
    }
}

