/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.nls.Messages;

public class SortSpec {
    public static final int sortAsc = 0;
    public static final int sortDesc = 1;
    private int m_sortMode;
    private List m_sortKeys;

    public SortSpec(int sortMode) {
        if (sortMode != 0 && sortMode != 1 && sortMode != 2 && sortMode != 3) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sortSpec_INVALID_SORT_MODE_SPECIFIED, (Object)new Integer(sortMode)));
        }
        this.m_sortMode = sortMode;
        this.m_sortKeys = new ArrayList();
    }

    public void addSortKey(String columnName, int sortOrder) {
        SortKey sortKey;
        if (columnName == null) {
            throw new NullPointerException(Messages.sortSpec_NULL_COLUMN_NAME_SPECIFIED);
        }
        if (columnName.length() == 0) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sortSpec_INVALID_COLUMN_NAME_SPECIFIED, (Object)columnName));
        }
        if (sortOrder != 0 && sortOrder != 1) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sortSpec_INVALID_SORT_ORDER_SPECIFIED, (Object)new Integer(sortOrder)));
        }
        if (this.m_sortMode == 0) {
            throw new IllegalStateException(Messages.sortSpec_NO_DYNAMIC_SORT_KEY_FOR_SORTMODENONE);
        }
        if (this.m_sortMode == 3 && this.doGetSortKeyCount() > 0) {
            throw new IllegalStateException(Messages.sortSpec_ONE_SORTCOLUMN_FOR_SINGLE_COLUMN_MODE);
        }
        if (this.m_sortMode == 1 && this.doGetSortKeyCount() > 0 && (sortKey = (SortKey)this.m_sortKeys.get(0)).getSortOrder() != sortOrder) {
            throw new IllegalStateException(Messages.sortSpec_ONE_SORTORDER_FOR_SINGLE_ORDER_MODE);
        }
        sortKey = new SortKey(columnName, sortOrder);
        this.m_sortKeys.add(sortKey);
    }

    public int getSortMode() {
        return this.m_sortMode;
    }

    public int getSortKeyCount() {
        return this.doGetSortKeyCount();
    }

    private int doGetSortKeyCount() {
        return this.m_sortKeys.size();
    }

    public String getSortColumn(int index) {
        this.validateIndex(index);
        SortKey sortKey = (SortKey)this.m_sortKeys.get(index - 1);
        return sortKey.getColumnName();
    }

    public int getSortOrder(int index) {
        this.validateIndex(index);
        SortKey sortKey = (SortKey)this.m_sortKeys.get(index - 1);
        return sortKey.getSortOrder();
    }

    private void validateIndex(int index) {
        int count = this.doGetSortKeyCount();
        if (index < 1 || index > count) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Count: " + count);
        }
    }

    public String[] getSortColumns() {
        if (this.m_sortMode != 1) {
            throw new IllegalStateException(Messages.sortSpec_ONLY_IN_SINGLE_ORDER_MODE);
        }
        int size = this.doGetSortKeyCount();
        String[] sortColumns = new String[size];
        for (int i = 0; i < size; ++i) {
            String columnName;
            SortKey sortKey = (SortKey)this.m_sortKeys.get(i);
            sortColumns[i] = columnName = sortKey.getColumnName();
        }
        return sortColumns;
    }

    public int getSortOrder() {
        if (this.m_sortMode != 1) {
            throw new IllegalStateException(Messages.sortSpec_ONLY_IN_SINGLE_ORDER_MODE);
        }
        if (this.doGetSortKeyCount() == 0) {
            return 0;
        }
        SortKey sortKey = (SortKey)this.m_sortKeys.get(0);
        return sortKey.getSortOrder();
    }

    public void setLocale(ULocale locale) {
    }

    public String toString() {
        return "Sort Mode: " + SortSpec.sortModeAsString(this.m_sortMode) + ", Sort Keys: " + this.m_sortKeys;
    }

    private static String sortOrderAsString(int sortOrder) {
        switch (sortOrder) {
            case 0: {
                return "Ascending";
            }
            case 1: {
                return "Descending";
            }
        }
        return "";
    }

    private static String sortModeAsString(int sortMode) {
        switch (sortMode) {
            case 0: {
                return "sortModeNone";
            }
            case 1: {
                return "sortModeSingleOrder";
            }
            case 2: {
                return "sortModeColumnOrder";
            }
            case 3: {
                return "sortModeSingleColumn";
            }
        }
        return "";
    }

    private static final class SortKey {
        private String m_columnName;
        private int m_sortOrder;

        private SortKey(String columnName, int sortOrder) {
            this.m_columnName = columnName;
            this.m_sortOrder = sortOrder;
        }

        private String getColumnName() {
            return this.m_columnName;
        }

        private int getSortOrder() {
            return this.m_sortOrder;
        }

        public String toString() {
            return "{" + this.m_columnName + ", " + SortSpec.sortOrderAsString(this.m_sortOrder) + "}";
        }
    }
}

