/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.client;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.soap.Fault;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.transport.SOAPTransport;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.Constants;
import org.eclipse.aperi.connector.internal.MappingRegistry;
import org.eclipse.aperi.connector.internal.NotAuthorizedException;
import org.eclipse.aperi.connector.internal.NullUserException;
import org.eclipse.aperi.connector.internal.RetryFailedException;
import org.eclipse.aperi.connector.internal.SOAPNotAuthorizedException;
import org.eclipse.aperi.connector.internal.SecurityContext;
import org.eclipse.aperi.connector.internal.UserSecurityContext;
import org.eclipse.aperi.connector.internal.client.SOAPConnection;
import org.w3c.dom.Element;

public class SoapClient
implements Constants {
    private SecurityContext sc = null;
    private URL url = null;
    private Call call = null;
    private Vector<Parameter> params = null;
    private SOAPMappingRegistry smr = null;
    private String encodingStyleURI = "http://schemas.xmlsoap.org/soap/encoding/";

    public SoapClient(SecurityContext securityContext) {
        this.sc = securityContext;
    }

    public void init(String string, String string2) throws MalformedURLException {
        if (this.sc == null) {
            this.sc = SecurityContext.getDefaultContext();
            SecurityContext.setDefaultContext(this.sc);
        }
        this.smr = MappingRegistry.getInstance();
        this.call = new Call();
        SOAPConnection sOAPConnection = new SOAPConnection();
        this.call.setSOAPTransport((SOAPTransport)sOAPConnection);
        boolean cfr_ignored_0 = this.sc instanceof UserSecurityContext;
        this.call.setSOAPMappingRegistry(this.smr);
        this.call.setTargetObjectURI(string2);
        this.call.setEncodingStyleURI(this.encodingStyleURI);
        this.params = new Vector();
        String string3 = Config.getProperty("connector.ssl.enabled");
        String string4 = null;
        string4 = string3 == null || "false".equalsIgnoreCase(string3) ? "http://" : "https://";
        this.url = new URL(String.valueOf(string4) + string + "/ServiceManager");
    }

    public Object invoke() throws Throwable {
        String string = this.call.getFullTargetObjectURI();
        Object object = null;
        Response response = null;
        if (Thread.interrupted()) {
            throw new ThreadDeath();
        }
        response = this.call.invoke(this.url, null);
        if (Thread.interrupted()) {
            throw new ThreadDeath();
        }
        if (response != null) {
            if (!response.generatedFault()) {
                Parameter parameter = response.getReturnValue();
                if (parameter != null) {
                    object = parameter.getValue();
                }
            } else {
                object = this.handleFault(response, string);
            }
        }
        return object;
    }

    protected Object handleFault(Response response, String string) throws Throwable {
        Object object;
        Object object2;
        Object object3;
        Throwable throwable = null;
        Fault fault = response.getFault();
        Vector vector = fault.getDetailEntries();
        if (vector == null || vector.size() < 1) {
            throwable = new RuntimeException(fault.toString());
        } else {
            object3 = vector.get(0);
            if (object3 instanceof Element) {
                try {
                    object2 = ((Element)vector.get(0)).getFirstChild().getNodeValue();
                    object = null;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode((String)object2));
                    object = new ObjectInputStream(byteArrayInputStream);
                    throwable = (Throwable)((ObjectInputStream)object).readObject();
                }
                catch (Exception exception) {
                    throwable = new RuntimeException(fault.toString());
                }
            } else if (object3 instanceof Parameter) {
                object2 = (Parameter)object3;
                object = object2.getValue();
                if (object instanceof Throwable) {
                    throwable = (Throwable)object;
                }
            } else {
                throwable = new RuntimeException(fault.toString());
            }
        }
        if (throwable instanceof NullUserException) {
            object3 = (Vector)this.call.getParams().clone();
            object2 = this.call.getMethodName();
            response = null;
            this.setMethod((String)object2, (Vector)object3);
            this.call.setTargetObjectURI(string);
            if (Thread.interrupted()) {
                throw new ThreadDeath();
            }
            response = this.call.invoke(this.url, null);
            if (Thread.interrupted()) {
                throw new ThreadDeath();
            }
            if (response != null) {
                if (!response.generatedFault()) {
                    object = response.getReturnValue();
                    if (object != null) {
                        return object.getValue();
                    }
                    return null;
                }
                throwable = new RetryFailedException(throwable.getMessage());
            }
        }
        this.call.setFullTargetObjectURI(string);
        if (throwable instanceof SOAPNotAuthorizedException) {
            throwable = new NotAuthorizedException(throwable.getMessage());
        }
        throw throwable;
    }

    protected void setMethod(Method method, Object[] objectArray) throws Exception {
        if (this.params != null) {
            this.params.removeAllElements();
        } else {
            this.params = new Vector();
        }
        if (method != null) {
            this.call.setMethodName(method.getName());
            Class<?>[] classArray = method.getParameterTypes();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    this.params.addElement(new Parameter("arg" + n, classArray[n], objectArray[n], null));
                    ++n;
                }
            }
        } else {
            throw new Exception("Method is null");
        }
        this.call.setParams(this.params);
    }

    public void setMethod(String string, Vector vector) {
        if (vector != null && string != null) {
            this.call.setMethodName(string);
            this.call.setParams(vector);
        }
    }
}

