/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.eclipse.aperi.connector.SocketHandler;
import org.eclipse.aperi.connector.internal.server.BiModalHttpConnection;
import org.eclipse.aperi.connector.internal.server.SocketHandlerMgr;
import org.eclipse.aperi.connector.log.LogHelper;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.SocketListener;

public class BiModalSocketListener
extends SocketListener {
    private static final long serialVersionUID = -7719187749632876608L;
    private int lowResourcePersistTimeMs = 2000;

    BiModalSocketListener() {
    }

    public void handle(Object object) {
        Socket socket = (Socket)object;
        try {
            this.handleConnection(socket);
        }
        catch (Exception exception) {
            LogHelper.logException(exception, ((Object)((Object)this)).getClass(), "handle");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleConnection(Socket socket) throws IOException {
        BiModalHttpConnection biModalHttpConnection = this.createConnection(socket);
        try {
            if (this.lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                socket.setSoTimeout(this.lowResourcePersistTimeMs);
                biModalHttpConnection.setThrottled(true);
            } else {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
                biModalHttpConnection.setThrottled(false);
            }
        }
        catch (Exception exception) {
            LogHelper.traceException(exception, ((Object)((Object)this)).getClass(), "handleConnection");
        }
        biModalHttpConnection.readRequest();
        HttpRequest httpRequest = biModalHttpConnection.getRequest();
        String string = httpRequest.getHeader().get("Content-Type");
        if ("RawSocket".equals(string)) {
            String string2 = httpRequest.getHeader().get("RawSocket-Service");
            this.handleRawSocketRequest(string2, socket);
            return;
        }
        try {
            try {
                biModalHttpConnection.handle();
            }
            catch (RuntimeException runtimeException) {
                LogHelper.traceException(runtimeException, ((Object)((Object)this)).getClass(), "handleConnection");
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                socket.close();
                throw throwable;
            }
            catch (Exception exception) {
                LogHelper.traceException(exception, ((Object)((Object)this)).getClass(), "handleConnection");
            }
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        try {}
        catch (Exception exception) {
            LogHelper.traceException(exception, ((Object)((Object)this)).getClass(), "handleConnection");
            return;
        }
        socket.close();
    }

    public int getLowResourcePersistTimeMs() {
        return this.lowResourcePersistTimeMs;
    }

    public void setLowResourcePersistTimeMs(int n) {
        this.lowResourcePersistTimeMs = n;
    }

    private void handleRawSocketRequest(String string, Socket socket) {
        try {
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            printWriter.println("OK");
            SocketHandler socketHandler = null;
            SocketHandlerMgr socketHandlerMgr = SocketHandlerMgr.getInstance();
            socketHandler = socketHandlerMgr.getSocketHandler(string);
            socketHandler.handleSocket(socket);
        }
        catch (Throwable throwable) {
            Exception exception = new Exception(throwable);
            LogHelper.logException(exception, ((Object)((Object)this)).getClass(), "handleRawSocketRequest");
        }
    }

    protected BiModalHttpConnection createConnection(Socket socket) throws IOException {
        BiModalHttpConnection biModalHttpConnection = new BiModalHttpConnection((HttpListener)this, socket.getInetAddress(), socket.getInputStream(), socket.getOutputStream(), socket);
        return biModalHttpConnection;
    }
}

