/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.script;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.AuthChecker;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class AbstractScriptHandler
implements IAgentRequestHandler {
    public static final String HEADER_LINE = "--------------------- BEGIN OUTPUT ---------------------";
    private static File scriptsDir = new File(JobUtil.scriptsDir);

    public abstract IAssignable makeRunner(RunScriptReq var1, String var2, PrintWriter var3, boolean var4);

    public void handle(Request request, Response response, Socket socket) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, response, connection");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.agent.req.RunScriptReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle");
            }
            return;
        }
        if (!AuthChecker.check(request, response, socket)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"handle");
            }
            return;
        }
        RunScriptReq runScriptReq = (RunScriptReq)request.requestData;
        String string = JobUtils.generateLogFileName((RunReq)runScriptReq, (String)Agent.logFileDirectory);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz5.getName(), (String)"handle", (Throwable)iOException);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0036E", (Exception)iOException);
        }
        if (fileWriter != null) {
            PrintWriter printWriter = new PrintWriter((Writer)fileWriter, true);
            IAssignable iAssignable = this.makeRunner(runScriptReq, string, printWriter, true);
            Agent.breadLine.assign(iAssignable);
            response.status = 0;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz6;
            try {
                clazz6 = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz6.getName(), (String)"handle");
        }
    }

    public static File writeTempFile(String string, String string2, byte[] byArray) {
        FileOutputStream fileOutputStream;
        Object object;
        block30: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"writeTempFile", (String)"prefix, ext, body");
            }
            object = null;
            File file = null;
            try {
                file = File.createTempFile(string, string2, scriptsDir);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"writeTempFile", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)iOException);
            }
            if (file != null) {
                fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"writeTempFile", (Throwable)iOException);
                    }
                    MessageLog.logException((String)"GEN0036E", (Exception)iOException);
                }
                if (fileOutputStream != null) {
                    boolean bl = false;
                    try {
                        if (Agent.isWindows || byArray.length <= 2 || byArray[0] != 35 || byArray[1] != 33) {
                            ((OutputStream)fileOutputStream).write(byArray);
                        } else {
                            AbstractScriptHandler.stripCarriageReturns(fileOutputStream, byArray);
                        }
                        bl = true;
                        ((OutputStream)fileOutputStream).close();
                        object = file;
                    }
                    catch (IOException iOException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"writeTempFile", (Throwable)iOException);
                        }
                        MessageLog.logMessage((String)"AGT0114E", (Object)file.getPath(), (Object)iOException.getMessage());
                    }
                    if (!bl) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (IOException iOException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block30;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"writeTempFile", (Throwable)iOException);
                        }
                    }
                }
            }
        }
        fileOutputStream = object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"writeTempFile", (Object)fileOutputStream);
        }
        return fileOutputStream;
    }

    public static String[] makeMoreTempFiles(RunScriptReq runScriptReq, String string, boolean bl) throws GeneralException {
        String[] stringArray;
        File file;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeMoreTempFiles", (String)"requestData, tempScriptFile, purge");
        }
        if (bl) {
            JobUtil.purgeLogFiles((RunReq)runScriptReq, (String)Agent.logFileDirectory);
        }
        int n = string != null ? 1 : 0;
        int n2 = 0;
        if (runScriptReq.scrData != null) {
            n2 = runScriptReq.scrData.length - 1;
        }
        int n3 = n + n2;
        String[] stringArray2 = new String[n3];
        if (string != null) {
            stringArray2[0] = string;
        }
        boolean bl2 = true;
        int n4 = 0;
        while (bl2 && n4 < n2) {
            file = AbstractScriptHandler.writeTempFile("DAT", null, runScriptReq.scrData[n4 + 1]);
            if (file == null) {
                bl2 = false;
                continue;
            }
            stringArray2[n + n4] = file.getName();
            ++n4;
        }
        runScriptReq.scrData = null;
        if (!bl2) {
            n4 = 0;
            while (n4 < n3 && stringArray2[n4] != null) {
                file = new File(scriptsDir, stringArray2[n4]);
                file.delete();
                ++n4;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"makeMoreTempFiles");
            }
            throw new GeneralException();
        }
        if (n2 > 0) {
            n3 = runScriptReq.scrArgv.length;
            stringArray = new String[n3 + n2];
            System.arraycopy(runScriptReq.scrArgv, 0, stringArray, 0, n3);
            System.arraycopy(stringArray2, n, stringArray, n3, n2);
            runScriptReq.scrArgv = stringArray;
        }
        stringArray = stringArray2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeMoreTempFiles", (Object)stringArray);
        }
        return stringArray;
    }

    private static void stripCarriageReturns(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"stripCarriageReturns", (String)"out, body");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] == 13) {
                n = n3 - n2;
                if (n > 0) {
                    outputStream.write(byArray, n2, n);
                }
                n2 = n3 + 1;
            }
            ++n3;
        }
        n = n3 - n2;
        if (n > 0) {
            outputStream.write(byArray, n2, n);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.AbstractScriptHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"stripCarriageReturns");
        }
    }

    public static File getScriptsDir() {
        return scriptsDir;
    }
}

