/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.script;

import java.io.PrintWriter;
import java.util.Iterator;
import org.eclipse.aperi.agent.handler.script.ScriptContext;
import org.eclipse.aperi.agent.handler.script.ScriptReaper;
import org.eclipse.aperi.agent.util.Link;
import org.eclipse.aperi.agent.util.ListOfLinks;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class WindowsScriptReaper
extends ScriptReaper {
    private static final int MAX_HANDLES = 63;
    private static ListOfLinks reaperList;
    private Link us;
    private ScriptContext[] managed = new ScriptContext[63];
    private long handleArray;
    private int pendingCount = 0;
    private int oldCount;

    static {
        WindowsScriptReaper.initIDs();
        reaperList = new ListOfLinks();
    }

    private native void allocHandleArray() throws LocalizableException;

    private native void freeHandleArray();

    private native void addHandle(long var1);

    private void addJobToThis(ScriptContext scriptContext) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptReaper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addJobToThis", (String)"context");
        }
        this.managed[this.pendingCount] = scriptContext;
        this.addHandle(scriptContext.handle);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptReaper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addJobToThis");
        }
    }

    private WindowsScriptReaper(ScriptContext scriptContext) throws LocalizableException {
        this.allocHandleArray();
        this.addJobToThis(scriptContext);
        this.us = reaperList.append(this);
    }

    private native ScriptContext reapOne();

    private void reapAll() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptReaper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"reapAll", (String)"");
        }
        do {
            ScriptContext scriptContext = this.reapOne();
            scriptContext.scriptExited(this.exitStatus);
        } while (this.oldCount > 0);
        reaperList.unlink(this.us);
        this.freeHandleArray();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptReaper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"reapAll");
        }
    }

    public static void addJob(ScriptContext scriptContext, PrintWriter printWriter, PrintWriter printWriter2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptReaper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addJob", (String)"context, oldLog, currentLog");
        }
        WindowsScriptReaper windowsScriptReaper = null;
        boolean bl = true;
        LockManager.lockJavaObject((Object)reaperList);
        Iterator iterator = reaperList.iterator();
        while (bl && iterator.hasNext()) {
            windowsScriptReaper = (WindowsScriptReaper)iterator.next();
            LockManager.lockJavaObject((Object)windowsScriptReaper);
            if (windowsScriptReaper.pendingCount > 0 && windowsScriptReaper.pendingCount < 63) {
                bl = false;
                continue;
            }
            LockManager.unLockJavaObject((Object)windowsScriptReaper);
        }
        if (bl) {
            try {
                windowsScriptReaper = new WindowsScriptReaper(scriptContext);
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptReaper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"addJob", (Throwable)localizableException);
                }
                LockManager.unLockJavaObject((Object)reaperList);
                localizableException.print();
                WindowsScriptReaper.removeTempFiles(scriptContext);
                MessageLog.setThreadLog((PrintWriter)printWriter);
                printWriter2.close();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptReaper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"addJob");
                }
                return;
            }
            LockManager.unLockJavaObject((Object)reaperList);
            MessageLog.setThreadLog((PrintWriter)printWriter);
            printWriter2.close();
            windowsScriptReaper.reapAll();
        } else {
            LockManager.unLockJavaObject((Object)reaperList);
            windowsScriptReaper.addJobToThis(scriptContext);
            LockManager.unLockJavaObject((Object)windowsScriptReaper);
            MessageLog.setThreadLog((PrintWriter)printWriter);
            printWriter2.close();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptReaper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addJob");
        }
    }

    private static native void initIDs();
}

