/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.MessageLog;

public class Contactor {
    public NameList vendor;
    public int rc;
    public boolean temporaryError;
    public NameList communities;
    public SnmpPeer peer;
    public SnmpSession listener;
    public int vendorID;
    public static final String PUBLIC = "public";
    private NameList vendors;
    private int socketAllocErrors;
    private NameList tail;
    private boolean forDiscovery;
    private boolean isLast;
    private SnmpPDU sendPdu;
    private static final int MAX_ALLOC_ERRORS = 3;
    private static final String SYS_OID_STRING = ".1.3.6.1.2.1.1.2.0";
    private static final String SYS_NAME_STRING = ".1.3.6.1.2.1.1.5.0";
    private static final int[] enterprises = new int[]{1, 3, 6, 1, 4, 1};
    private static final OID enterprisesOID = new OID(enterprises);
    private static boolean snmpInitialized;
    private static OID sysObjectID_OID;
    private static OID sysName_OID;
    private static Vector OIDs;

    static {
        sysObjectID_OID = new OID(SYS_OID_STRING);
        sysName_OID = new OID(SYS_NAME_STRING);
        OIDs = new Vector();
        OIDs.addElement(new SnmpVarBind(sysObjectID_OID));
        OIDs.addElement(new SnmpVarBind(sysName_OID));
    }

    public Contactor(SnmpPeer snmpPeer, NameList nameList, NameList nameList2, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"Contactor", (String)"pPeer, pVendors, pCommunities, pForDiscovery");
        }
        this.peer = snmpPeer;
        this.vendors = nameList;
        this.forDiscovery = bl;
        this.socketAllocErrors = 0;
        this.communities = nameList2;
        boolean bl2 = true;
        NameList nameList3 = this.communities;
        while (nameList3 != null) {
            this.tail = nameList3;
            if (bl2 && this.tail.nlName.equals(PUBLIC)) {
                bl2 = false;
            }
            nameList3 = this.tail.nlNext;
        }
        if (bl2) {
            NameList nameList4 = new NameList();
            nameList4.nlName = PUBLIC;
            nameList4.nlID = -1;
            if (this.tail != null) {
                this.tail.nlNext = nameList4;
            } else {
                this.communities = nameList4;
            }
            this.tail = nameList4;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"Contactor");
        }
    }

    public Contactor(SnmpPeer snmpPeer, NameList nameList, NameList nameList2) {
        this(snmpPeer, nameList, nameList2, true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"Contactor", (String)"pPeer, pVendors, pCommunities");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"Contactor");
        }
    }

    private static boolean valueEqualsOID(Serializable serializable, OID oID) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"valueEqualsOID", (String)"value, oid");
        }
        if (serializable == null) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"valueEqualsOID", (boolean)bl);
            }
            return bl;
        }
        boolean bl = oID.equals((Object)serializable);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"valueEqualsOID", (boolean)bl);
        }
        return bl;
    }

    private String tryOneCommunity() {
        OID oID;
        SnmpVarBind snmpVarBind;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"tryOneCommunity", (String)"");
        }
        this.listener.changeCommName(this.communities.nlName);
        this.vendor = this.vendors;
        if (this.sendPdu == null) {
            this.sendPdu = this.listener.makePDU();
        }
        this.sendPdu.operation = 0;
        this.sendPdu.varBindList = OIDs;
        this.sendPdu.communityString = null;
        SnmpPDU snmpPDU = this.listener.send(this.sendPdu);
        if (snmpPDU != null && snmpPDU.errorStatus != 0) {
            if (!this.forDiscovery && this.isLast) {
                MessageLog.logMessage((String)"NAA0078E", (Object)this.peer.name);
                this.rc = 4;
            }
            String string = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"tryOneCommunity", string);
            }
            return string;
        }
        if (snmpPDU == null || snmpPDU.varBindListSize() == 0) {
            if (!this.forDiscovery && this.isLast) {
                MessageLog.logMessage((String)"NAA0078E", (Object)this.peer.name);
                this.rc = 4;
            }
            String string = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"tryOneCommunity", string);
            }
            return string;
        }
        Serializable serializable = null;
        Object object = null;
        int n = 0;
        while (n < snmpPDU.varBindListSize()) {
            snmpVarBind = snmpPDU.varBindAt(n);
            if (snmpVarBind != null) {
                Serializable serializable2 = snmpVarBind.getVar();
                oID = snmpVarBind.getOID();
                if (object == null && Contactor.valueEqualsOID((Serializable)oID, sysObjectID_OID)) {
                    object = serializable2;
                } else if (serializable == null && Contactor.valueEqualsOID((Serializable)oID, sysName_OID)) {
                    serializable = serializable2;
                }
            }
            ++n;
        }
        if (object == null) {
            MessageLog.logMessage((String)"NAA0003W", (Object)this.peer.name, (Object)"sysObjectID");
            this.rc = 4;
            String string = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"tryOneCommunity", string);
            }
            return string;
        }
        if (!(object instanceof OID)) {
            this.rc = 4;
            String string = object.getClass().getName();
            MessageLog.logMessage((String)"NAA0008W", (Object)this.peer.name, (Object)string);
            snmpVarBind = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"tryOneCommunity", (Object)snmpVarBind);
            }
            return snmpVarBind;
        }
        oID = (OID)object;
        if (!oID.startsWith(enterprisesOID)) {
            this.rc = 4;
            MessageLog.logMessage((String)"NAA0009W", (Object)this.peer.name);
            String string = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"tryOneCommunity", string);
            }
            return string;
        }
        this.vendorID = (int)oID.value[enterprises.length];
        if (this.vendors != null) {
            while (this.vendor != null && this.vendor.nlID != this.vendorID) {
                this.vendor = this.vendor.nlNext;
            }
            if (this.vendor == null) {
                if (!this.forDiscovery && this.isLast) {
                    Object[] objectArray = new Object[]{this.peer.name, new Integer(this.vendorID)};
                    MessageLog.logMessage((String)"NAA0077E", (Object[])objectArray);
                    this.rc = 4;
                }
                String string = null;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"tryOneCommunity", string);
                }
                return string;
            }
        }
        if (serializable != null && serializable instanceof OctetString) {
            this.peer.name = ((OctetString)serializable).toDisplayString();
        }
        String string = this.peer.name;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"tryOneCommunity", (Object)string);
        }
        return string;
    }

    private void cycleCommunities() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cycleCommunities", (String)"");
        }
        this.tail.nlNext = this.communities;
        this.tail = this.communities;
        this.communities = this.communities.nlNext;
        this.tail.nlNext = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cycleCommunities");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String contact() {
        Class<?> clazz;
        boolean bl;
        Object object;
        Object object2;
        block35: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)"contact", (String)"");
            }
            this.rc = 0;
            this.temporaryError = false;
            this.listener = null;
            try {
                if (!snmpInitialized) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    object2 = clazz3;
                    // MONITORENTER : clazz3
                    if (!snmpInitialized) {
                        SnmpV1API.initialize((int)-1);
                        snmpInitialized = true;
                    }
                    // MONITOREXIT : object2
                }
                this.listener = SnmpSession.open((String)this.peer.name);
            }
            catch (SnmpUnknownHostException snmpUnknownHostException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz4.getName(), (String)"contact", (Throwable)snmpUnknownHostException);
                }
                if (!this.forDiscovery) {
                    MessageLog.logException((String)"NAA0075E", (Exception)((Object)snmpUnknownHostException), (Object)this.peer.name);
                }
            }
            catch (SnmpSocketException snmpSocketException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz5.getName(), (String)"contact", (Throwable)snmpSocketException);
                }
                ++this.socketAllocErrors;
                if (this.socketAllocErrors < 3) {
                    this.temporaryError = true;
                    this.rc = 4;
                    object = "NAA0025W";
                } else {
                    this.rc = 8;
                    object = "NAA0025E";
                }
                MessageLog.logException((String)object, (Exception)((Object)snmpSocketException));
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz6;
                    try {
                        clazz6 = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz6.getName(), (String)"contact", (Throwable)exception);
                }
                if (this.forDiscovery) break block35;
                MessageLog.logException((String)"NAA0114E", (Exception)exception);
            }
        }
        if (this.listener == null) {
            Class<?> clazz7;
            object2 = null;
            if (!TraceLogger.enableTrace) return object2;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz7.getName(), (String)"contact", object2);
            return object2;
        }
        this.socketAllocErrors = 0;
        object = this.communities;
        do {
            this.isLast = this.communities.nlNext == null || this.communities.nlNext == object;
            object2 = this.tryOneCommunity();
            if (this.vendors == null) {
                bl = object2 == null && this.rc == 0;
            } else {
                boolean bl2 = bl = object2 == null && this.rc == 0 && this.vendor != null;
            }
            if (!bl) continue;
            this.cycleCommunities();
        } while (bl && !this.isLast);
        if (this.forDiscovery || object2 == null) {
            this.listener.close();
        }
        Object object3 = object2;
        if (!TraceLogger.enableTrace) return object3;
        try {
            clazz = Class.forName("org.eclipse.aperi.agent.nas.Contactor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"contact", (Object)object3);
        return object3;
    }
}

