/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.CorporateLevelLogger;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.PDXMLFormatter;
import com.ibm.log.util.LogUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class PDLogger
extends CorporateLevelLogger {
    static final long serialVersionUID = 1542502320936709585L;
    private String productInstance = "";
    private String serverFormat = "";
    private transient PDXMLFormatter msgIdFormatter = new PDXMLFormatter();

    public PDLogger() {
        this.getHostName();
    }

    public PDLogger(String string) {
        super(string);
        this.getHostName();
    }

    private void getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress());
            String string = inetAddress.getHostName();
            this.setServer(string);
            this.setServerFormat("IP");
        }
        catch (UnknownHostException unknownHostException) {
            String string = LogUtil.getLogMsg("ERR_GETTING_HOSTNAME", this.getName());
            LogUtil.errorMsg(string);
        }
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        if (!this.getProductInstance().equals("")) {
            properties.put("productInstance", this.getProductInstance());
        }
        if (!this.getServerFormat().equals("")) {
            properties.put("serverFormat", this.getServerFormat());
        }
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("productInstance");
        if (string != null) {
            this.setProductInstance(string);
        }
        if ((string = properties.getProperty("serverFormat")) != null) {
            this.setServerFormat(string);
        }
    }

    public String getProductInstance() {
        return this.productInstance;
    }

    public void setProductInstance(String string) {
        if (string != null) {
            this.productInstance = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setProductInstance");
            LogUtil.errorMsg(string2);
        }
    }

    public String getServerFormat() {
        return this.serverFormat;
    }

    public void setServerFormat(String string) {
        if (string != null) {
            this.serverFormat = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setServerFormat");
            LogUtil.errorMsg(string2);
        }
    }

    public void exception(Level level, Object object, String string, Throwable throwable) {
        if (this.isLoggable(level)) {
            LogEvent logEvent = new LogEvent(level, object, string, throwable, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), this.getServerFormat(), this.getProductInstance(), null);
            this.logAndWarn(logEvent);
        }
    }

    public void exception(Level level, Object object, String string, Throwable throwable, String string2) {
        if (this.isLoggable(level)) {
            LogEvent logEvent = new LogEvent(level, object, string, throwable, string2, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), this.getServerFormat(), this.getProductInstance(), null);
            this.logAndWarn(logEvent);
        }
    }

    protected void logMessage(Level level, Object object, String string, String string2, String string3, Object[] objectArray) {
        LogEvent logEvent = new LogEvent(level, object, string, string2, string3, objectArray, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), this.getServerFormat(), this.getProductInstance(), null);
        this.msgIdFormatter.cacheMessageId(logEvent);
        this.logAndWarn(logEvent);
    }

    protected void logText(Level level, Object object, String string, String string2, Object[] objectArray) {
        LogEvent logEvent = new LogEvent(level, object, string, string2, objectArray, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), this.getServerFormat(), this.getProductInstance(), null);
        this.logAndWarn(logEvent);
    }
}

