/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AbstractAlertEditor;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class PerfAlertEditor
extends AbstractAlertEditor {
    protected AlertHeader alertHeader = null;
    protected IntToString[] oldConditions;
    protected static final String OLD_VALUE_PANEL = "oldValuePanel";
    protected static final String PERF_VALUE_PANEL = "perfValuePanel";
    private JPanel conditionPanel;
    protected JPanel valuePanel;
    protected JPanel oldValuePanel = null;
    protected JPanel perfValuesPanel = null;
    protected GridBagLayout layout;
    protected GridBagConstraints constraints;
    protected CardLayout cardLayout;
    protected JLabel lWarningStress;
    protected TTextField warningStressEntry;
    protected JLabel lCriticalStress;
    protected TTextField criticalStressEntry;
    protected JLabel lWarningIdle;
    protected TTextField warningIdleEntry;
    protected JLabel lCriticalIdle;
    protected TTextField criticalIdleEntry;
    protected JLabel lValueUnit;
    protected CreateHeaderPanel createHeaderPanel;
    private JLabel lFiller;
    private short unitType;
    private boolean isAscending = false;
    protected int oldAlertType;
    protected static HashMap listMap = new HashMap();
    protected boolean initFlag = false;

    public PerfAlertEditor() {
        super(false);
        this.initConditions();
    }

    public PerfAlertEditor(AlertHeader alertHeader) {
        super(alertHeader.alert, false);
        this.alertHeader = alertHeader;
        this.initConditions();
    }

    protected void initAlert() {
        super.initAlert();
        this.alert.aldThresholdValue = -1;
        this.alert.aldThresholdValue2 = -1;
        this.alert.aldThresholdValue3 = -1;
        this.alert.aldThresholdValue4 = -1;
    }

    protected JPanel buildConditionPanel() {
        String string = MessageLog.getMessageNoID("GUI0205T");
        this.conditionPanel = GuiUtil.getTitledBorderedPanel(string);
        this.layout = new GridBagLayout();
        this.conditionPanel.setLayout(this.layout);
        this.constraints = new GridBagConstraints();
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 18, 0, 0);
        string = MessageLog.getMessageNoID("GUI0206L");
        this.lConditions = new JLabel(string);
        this.conditionList = new TComboBox();
        this.conditionList.setPreferredSize(new Dimension(425, 20));
        GuiUtil.setAccessibleLabel(this.lConditions, this.conditionList, "MNEMONIC_CONDITION", MessageLog.getMessageNoID("GUI0206L"), "DESCRIPTION_CONDITION");
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 2;
        this.constraints.gridheight = 1;
        this.layout.setConstraints(this.lConditions, this.constraints);
        this.conditionPanel.add(this.lConditions);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 2;
        this.constraints.gridheight = 1;
        this.constraints.anchor = 18;
        this.layout.setConstraints(this.conditionList, this.constraints);
        this.conditionPanel.add(this.conditionList);
        this.constraints.anchor = 17;
        this.getValuePanel();
        this.constraints.gridx = 2;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 0;
        this.constraints.gridheight = 2;
        this.layout.setConstraints(this.valuePanel, this.constraints);
        this.conditionPanel.add(this.valuePanel);
        GuiUtil.completePanel(this.conditionPanel);
        this.setPanelSize(this.conditionPanel);
        return this.conditionPanel;
    }

    private void getValuePanel() {
        this.valuePanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.valuePanel.setLayout(this.cardLayout);
        this.getOldValuePanel();
        this.getPerfValuesPanel();
        this.valuePanel.add(OLD_VALUE_PANEL, this.oldValuePanel);
        this.valuePanel.add(PERF_VALUE_PANEL, this.perfValuesPanel);
        this.oldAlertType = -1;
        this.cardLayout.show(this.valuePanel, OLD_VALUE_PANEL);
    }

    private void getOldValuePanel() {
        this.oldValuePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 16);
        gridBagConstraints.anchor = 17;
        this.lValue = new JLabel(MessageLog.getMessageNoID("GUI0208L"));
        this.lUnits = new JLabel(MessageLog.getMessageNoID("GUI0207L"));
        this.thresholdUnits = new TComboBox();
        this.thresholdUnits.setPreferredSize(new Dimension(190, 20));
        this.thresholdValue = TTextField.newTTextField(9, 7, true);
        this.valueDocument = (SizeLimitedDocument)this.thresholdValue.getDocument();
        GuiUtil.setAccessibleLabel(this.lValue, this.thresholdValue, "MNEMONIC_VALUE", MessageLog.getMessageNoID("GUI0208L"), "DESCRIPTION_VALUE");
        GuiUtil.setAccessibleLabel(this.lUnits, this.thresholdUnits, "MNEMONIC_UNITS", MessageLog.getMessageNoID("GUI0207L"), "DESCRIPTION_UNITS");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.oldValuePanel.add((Component)this.lValue, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.oldValuePanel.add((Component)this.lUnits, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.oldValuePanel.add((Component)this.thresholdValue, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.oldValuePanel.add((Component)this.thresholdUnits, gridBagConstraints);
        this.thresholdValue.setText(null);
        this.setValueEnabled(false);
        this.setUnitEnabled(false);
        GuiUtil.completePanel(this.oldValuePanel);
        this.setPanelSize(this.oldValuePanel);
    }

    private void getPerfValuesPanel() {
        this.perfValuesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 16);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        this.lWarningStress = new JLabel(Util.getString("PERF_WARNING_STRESS"));
        this.lCriticalStress = new JLabel(Util.getString("PERF_CRITICAL_STRESS"));
        this.lWarningIdle = new JLabel(Util.getString("PERF_WARNING_IDLE"));
        this.lCriticalIdle = new JLabel(Util.getString("PERF_CRITICAL_IDLE"));
        this.lFiller = new JLabel();
        this.warningStressEntry = TTextField.newTTextField(10, true);
        this.criticalStressEntry = TTextField.newTTextField(10, true);
        this.warningIdleEntry = TTextField.newTTextField(10, true);
        this.criticalIdleEntry = TTextField.newTTextField(10, true);
        this.lValueUnit = new JLabel(Util.getString("PERF_PERCENT"));
        this.warningStressEntry.setDisable(true);
        this.criticalStressEntry.setDisable(true);
        this.warningIdleEntry.setDisable(true);
        this.criticalIdleEntry.setDisable(true);
        GuiUtil.setAccessibleLabel(this.lWarningStress, this.warningStressEntry, "DISK_MNEMONIC_NONE", Util.getString("DISK_PERF_WARNING_STRESS"), "DISK_PERF_DESCRIPTION_WARNING_STRESS");
        GuiUtil.setAccessibleLabel(this.lCriticalStress, this.criticalStressEntry, "DISK_MNEMONIC_NONE", Util.getString("DISK_PERF_CRITICAL_STRESS"), "DISK_PERF_DESCRIPTION_CRITICAL_STRESS");
        GuiUtil.setAccessibleLabel(this.lWarningIdle, this.warningIdleEntry, "DISK_MNEMONIC_NONE", Util.getString("DISK_PERF_WARNING_IDLE"), "DISK_PERF_DESCRIPTION_WARNING_IDLE");
        GuiUtil.setAccessibleLabel(this.lCriticalIdle, this.criticalIdleEntry, "DISK_MNEMONIC_NONE", Util.getString("DISK_PERF_CRITICAL_IDLE"), "DISK_PERF_DESCRIPTION_CRITICAL_IDLE");
        gridBagConstraints.gridwidth = 2;
        this.perfValuesPanel.add((Component)this.lCriticalStress, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.perfValuesPanel.add((Component)this.lWarningStress, gridBagConstraints);
        this.perfValuesPanel.add((Component)this.lWarningIdle, gridBagConstraints);
        this.perfValuesPanel.add((Component)this.lCriticalIdle, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.perfValuesPanel.add((Component)this.lFiller, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        this.perfValuesPanel.add((Component)this.criticalStressEntry, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.perfValuesPanel.add((Component)this.warningStressEntry, gridBagConstraints);
        this.perfValuesPanel.add((Component)this.warningIdleEntry, gridBagConstraints);
        this.perfValuesPanel.add((Component)this.criticalIdleEntry, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.perfValuesPanel.add((Component)this.lValueUnit, gridBagConstraints);
        GuiUtil.completePanel(this.perfValuesPanel);
        this.setPanelSize(this.perfValuesPanel);
    }

    protected void setConditionData() {
        this.initFlag = true;
        this.conditionList.setMaximumRowCount(20);
        this.initComboBox(this.conditionList, this.oldConditions, this.alert.aldCondition);
        this.switchCard(this.alert.aldCondition);
        this.oldAlertType = this.alert.aldCondition;
        this.initFlag = false;
        if (this.alert.aldAlertID > 0 && this.alert.aldAlertID <= 299) {
            this.conditionList.removeAllItems();
            this.conditionList.addItem(new IntToString(107, MessageLog.getMessageNoID("ALR1261W")));
        }
    }

    protected void conditionChange() {
        short s = this.getConditionValue();
        if (this.oldAlertType == s) {
            return;
        }
        this.switchCard(s);
    }

    protected abstract void switchCard(int var1);

    protected abstract void initConditions();

    protected void validateConditionData() throws GeneralException {
    }

    private void isValueValid(boolean bl, int n, int n2) throws GeneralException {
        if (bl) {
            if (n >= n2) {
                this.throwException("STG4260E");
            }
        } else if (n <= n2) {
            this.throwException("STG4261E");
        }
    }

    private void isValidPercentage(boolean bl, int n) throws GeneralException {
        if (bl && (n > 100 || n < 0)) {
            this.throwException("STG4262E");
        }
    }

    public void setCreateHeaderPanel(CreateHeaderPanel createHeaderPanel) {
        this.createHeaderPanel = createHeaderPanel;
    }

    public short getConditionValue() {
        IntToString intToString = (IntToString)this.conditionList.getSelectedItem();
        short s = (short)intToString.value;
        return s;
    }

    public String getConditionName() {
        IntToString intToString = (IntToString)this.conditionList.getSelectedItem();
        return intToString.toString();
    }
}

