/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.common.PingReport;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingAdjuster
extends CustomReportDataAdjuster {
    private GuiReportReq grr;
    private Comparator sorter;
    private PingReport[] tableData;
    private MutableShort[] mShort;
    private MutableInteger[] mInteger;
    private MutableLong[] mLong;
    private Date[] mDate;
    public String[] colNames;
    private int name1Col = -1;
    private int name2Col = -1;
    private int[] rendererArray;
    private boolean batch;
    private String[] statTypeValues;
    private static final int N_STATISTIC_TYPES = 5;
    private static final int PERCENT_COL = 0;
    private static final int TRANSMITTED_COL = 1;
    private static final int RECEIVED_COL = 2;
    private static final int DAMAGED_COL = 3;
    public static final int AVG_TRANSIT_COL = 4;
    public static final int MAX_TRANSIT_COL = 5;
    public static final int MIN_TRANSIT_COL = 6;
    private static final int START_TIME_COL = 7;
    private static final int END_TIME_COL = 8;
    private static final String[] COL_LABELS = new String[]{MessageLog.getMessageNoID("STG4071L"), MessageLog.getMessageNoID("STG4072L"), MessageLog.getMessageNoID("STG4073L"), MessageLog.getMessageNoID("STG4074L"), MessageLog.getMessageNoID("STG4075L"), MessageLog.getMessageNoID("STG4076L"), MessageLog.getMessageNoID("STG4077L"), MessageLog.getMessageNoID("STG4078L"), MessageLog.getMessageNoID("STG4079L")};
    public static final byte TRANSIT_TIME_SCALE = 1;

    public PingAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 1;
        switch (guiReportReq.reportSubtype) {
            case 12: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 82: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1136L");
                break;
            }
            case 28: {
                this.sorter = new HistorySorter();
                this.colNames = new String[COL_LABELS.length + 2];
                this.colNames[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 13: {
                this.sorter = new TwoNameSorter();
                this.name1Col = -2;
                this.frozenColumns = 2;
                this.colNames = new String[COL_LABELS.length + 2];
                this.colNames[0] = MessageLog.getMessageNoID("STG0021L");
                this.colNames[1] = MessageLog.getMessageNoID("STG1103L");
                break;
            }
            case 14: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1104L");
                break;
            }
            case 15: {
                this.frozenColumns = 0;
                this.colNames = new String[COL_LABELS.length];
            }
        }
        System.arraycopy(COL_LABELS, 0, this.colNames, this.frozenColumns, COL_LABELS.length);
        if (guiReportReq.reportSubtype == 28) {
            this.colNames[this.colNames.length - 1] = MessageLog.getMessageNoID("STG1214L");
            this.statTypeValues = new String[5];
            this.statTypeValues[0] = MessageLog.getMessageNoID("STG4094L");
            this.statTypeValues[1] = MessageLog.getMessageNoID("STG4095L");
            this.statTypeValues[2] = MessageLog.getMessageNoID("STG4096L");
            this.statTypeValues[3] = this.statTypeValues[1];
            this.statTypeValues[4] = this.statTypeValues[2];
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[this.frozenColumns + 0] = 6;
        this.rendererArray[this.frozenColumns + 1] = 5;
        this.rendererArray[this.frozenColumns + 2] = 5;
        this.rendererArray[this.frozenColumns + 3] = 5;
        this.rendererArray[this.frozenColumns + 4] = 2;
        this.rendererArray[this.frozenColumns + 5] = 2;
        this.rendererArray[this.frozenColumns + 6] = 2;
        this.rendererArray[this.frozenColumns + 7] = 1;
        this.rendererArray[this.frozenColumns + 8] = 1;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        if (this.sorter != null) {
            Arrays.sort(this.tableData, this.sorter);
        }
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.tableData = (PingReport[])objectArray;
        int n = this.tableData.length;
        this.mDate = new Date[n];
        this.mLong = new MutableLong[n];
        this.mInteger = new MutableInteger[n];
        this.mShort = new MutableShort[n];
        int n2 = 0;
        while (n2 < n) {
            this.mDate[n2] = new Date();
            this.mLong[n2] = new MutableLong();
            this.mInteger[n2] = new MutableInteger();
            this.mShort[n2] = new MutableShort();
            ++n2;
        }
    }

    public void adjustData() {
        int n = this.tableData.length;
        int n2 = 0;
        while (n2 < n) {
            PingReport pingReport = this.tableData[n2];
            pingReport.prPercentAvailable = (short)Math.min(100, (int)((double)pingReport.pngReceived / (double)pingReport.pngTransmitted * 100.0));
            if (pingReport.pngReceived == 0) {
                pingReport.pngAvgTransitTime = -1L;
                pingReport.pngMaxTransitTime = -1;
                pingReport.pngMinTransitTime = -1;
            } else if (this.grr.reportSubtype != 28) {
                pingReport.pngAvgTransitTime /= (long)pingReport.pngReceived;
            }
            if (!this.batch) {
                if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                    pingReport.prName1 = GuiUtil.getComputer((int)pingReport.prID).gcTSName;
                } else if (this.grr.reportSubtype == 82) {
                    pingReport.prName1 = pingReport.getPrName2();
                }
            }
            ++n2;
        }
    }

    public int getNumberRows() {
        return this.tableData.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getScale() {
        return 10;
    }

    public String getSuffix() {
        return MessageLog.getMessageNoID("STG7558L");
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        int n = 0;
        while (n < this.tableData.length) {
            PingReport pingReport = this.tableData[n];
            HistChartProcessor.addLegend(this.grr, pingReport.prName1, pingReport.getPrName2(), pingReport.prID);
            ++n;
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] nArray = new int[this.tableData.length];
        int n = 0;
        while (n < this.tableData.length) {
            PingReport pingReport = this.tableData[n];
            nArray[n] = pingReport.prID;
            ++n;
        }
        return nArray;
    }

    public Object getCellData(int n, int n2) {
        if ((n2 -= this.frozenColumns) == this.name1Col) {
            return this.tableData[n].prName1;
        }
        if (n2 == this.name2Col) {
            return this.tableData[n].getPrName2();
        }
        if (n2 == 0) {
            this.mShort[n].value = this.tableData[n].prPercentAvailable;
            return this.mShort[n];
        }
        if (n2 == 1) {
            this.mInteger[n].value = this.tableData[n].pngTransmitted;
            return this.mInteger[n];
        }
        if (n2 == 2) {
            this.mInteger[n].value = this.tableData[n].pngReceived;
            return this.mInteger[n];
        }
        if (n2 == 3) {
            this.mInteger[n].value = this.tableData[n].pngDamaged;
            return this.mInteger[n];
        }
        if (n2 == 4) {
            this.mLong[n].value = (int)this.tableData[n].pngAvgTransitTime;
            return this.mLong[n];
        }
        if (n2 == 5) {
            this.mLong[n].value = this.tableData[n].pngMaxTransitTime;
            return this.mLong[n];
        }
        if (n2 == 6) {
            this.mLong[n].value = this.tableData[n].pngMinTransitTime;
            return this.mLong[n];
        }
        if (n2 == 7) {
            this.mDate[n].setTime(this.tableData[n].pngMonitorStart);
            return this.mDate[n];
        }
        if (n2 == 8) {
            this.mDate[n].setTime(this.tableData[n].pngMonitorEnd);
            return this.mDate[n];
        }
        return this.statTypeValues[this.tableData[n].pngStatisticType];
    }

    private class OneNameSorter
    implements Comparator {
        private OneNameSorter() {
        }

        public int compare(Object object, Object object2) {
            PingReport pingReport = (PingReport)object;
            PingReport pingReport2 = (PingReport)object2;
            return pingReport.prName1.compareTo(pingReport2.prName1);
        }
    }

    private class TwoNameSorter
    implements Comparator {
        private TwoNameSorter() {
        }

        public int compare(Object object, Object object2) {
            PingReport pingReport = (PingReport)object;
            PingReport pingReport2 = (PingReport)object2;
            int n = pingReport.prName1.compareTo(pingReport2.prName1);
            if (n != 0) {
                return n;
            }
            return pingReport.getPrName2().compareTo(pingReport2.getPrName2());
        }
    }

    private class HistorySorter
    implements Comparator {
        private HistorySorter() {
        }

        public int compare(Object object, Object object2) {
            PingReport pingReport = (PingReport)object;
            PingReport pingReport2 = (PingReport)object2;
            if (pingReport.pngMonitorStart > pingReport2.pngMonitorStart) {
                return 1;
            }
            if (pingReport.pngMonitorStart < pingReport2.pngMonitorStart) {
                return -1;
            }
            if (pingReport.pngMonitorEnd > pingReport2.pngMonitorEnd) {
                return 1;
            }
            if (pingReport.pngMonitorEnd < pingReport2.pngMonitorEnd) {
                return -1;
            }
            return 0;
        }
    }
}

