/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.UilLabelledComponentBean;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class MaskEditor
implements ActionListener,
GuiRequestor {
    private JCheckBox allowExcludeMask;
    private JCheckBox allowIncludeMask;
    private UilLabelledComponentBean excludeLabel;
    private UilLabelledComponentBean includeLabel;
    private JTextField excludeTextField;
    private JTextField includeTextField;
    private String excludeMask;
    private String includeMask;
    private JButton viewResultsButton;
    private JDialog dialog;
    private static JButton ok;
    private static JButton cancel;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public MaskEditor() {
        this.setUpControls();
    }

    public MaskEditor(String string, String string2, boolean bl, boolean bl2) {
        this.setUpControls();
        this.setExcludeMask(string);
        this.setIncludeMask(string2);
        this.excludeTextField.setText(string);
        this.includeTextField.setText(string2);
        this.allowExcludeMask.setSelected(bl2);
        this.allowIncludeMask.setSelected(bl);
    }

    public void setExcludeMask(String string) {
        this.excludeMask = string;
    }

    public void setIncludeMask(String string) {
        this.includeMask = string;
    }

    public String getExcludeMask() {
        return this.excludeMask;
    }

    public String getIncludeMask() {
        return this.includeMask;
    }

    private void setUpControls() {
        this.excludeTextField = new JTextField(20);
        this.includeTextField = new JTextField(20);
        this.excludeLabel = new UilLabelledComponentBean("Exclude Mask", this.excludeTextField);
        this.includeLabel = new UilLabelledComponentBean("Include Mask", this.includeTextField);
        this.allowExcludeMask = new JCheckBox();
        this.allowExcludeMask.addActionListener(this);
        this.allowIncludeMask = new JCheckBox();
        this.allowIncludeMask.addActionListener(this);
        this.viewResultsButton = new JButton("View Mask Results");
        this.viewResultsButton.addActionListener(this);
    }

    public JPanel getComponent() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setDefaultAnchor(25);
        GridBagPanel gridBagPanel2 = new GridBagPanel(new Insets(0, 0, 0, 0));
        gridBagPanel2.setDefaultAnchor(25);
        gridBagPanel2.add((JComponent)this.allowIncludeMask, 0);
        gridBagPanel2.add((JComponent)this.includeLabel, 0);
        GridBagPanel gridBagPanel3 = new GridBagPanel(new Insets(0, 0, 0, 0));
        gridBagPanel3.setDefaultAnchor(25);
        gridBagPanel3.add((JComponent)this.allowExcludeMask, 0);
        gridBagPanel3.add((JComponent)this.excludeLabel, 0);
        gridBagPanel.add((JComponent)gridBagPanel2, 25, 0);
        gridBagPanel.setDefaultAnchor(20);
        gridBagPanel.add((JComponent)this.viewResultsButton, 1, 2, 0);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)gridBagPanel3, 25, 0);
        return gridBagPanel;
    }

    private void submitRetrieve() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.flags = (byte)5;
        request.userName = GuiUtil.getUserName();
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        NameList nameList = new NameList();
        nameList.nlName = "dummy1.storage.sanjose.im.com";
        NameList nameList2 = new NameList();
        nameList2.nlName = "dummy2.storage.sanjose.im.com";
        NameList nameList3 = new NameList();
        nameList3.nlName = "dummy3.storage.sanjose.im.com";
        Vector<NameList> vector = new Vector<NameList>();
        vector.add(nameList);
        vector.add(nameList2);
        vector.add(nameList3);
        this.showList(vector);
    }

    private void showList(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            System.out.println("Array contains: " + ((NameList)vector.get((int)n)).nlName);
            ++n;
        }
        ok = new JButton("OK");
        ok.addActionListener(this);
        cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        JList jList = new JList(vector);
        jList.setVisible(true);
        this.dialog = new JDialog(this.guiMain.getFrame(), true);
        this.dialog.setTitle("Mask Results");
        try {
            new URL("itsrm//gui//images//icon.gif");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Exception Caught: " + malformedURLException);
        }
        Container container = this.dialog.getContentPane();
        container.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jList);
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add(ok);
        jPanel.add(cancel);
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        container.add((Component)jScrollPane2, "South");
        Dimension dimension = this.dialog.getToolkit().getScreenSize();
        int n2 = (dimension.width - 400) / 2;
        int n3 = (dimension.height - 200) / 2;
        this.dialog.setBounds(n2, n3, 400, 200);
        this.dialog.setSize(300, 300);
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == ok) {
            System.out.println("Ok Action");
            System.out.println("User has choosen to set this mask\n");
            if (this.dialog.isVisible()) {
                this.dialog.setVisible(false);
            }
        } else if (object == cancel) {
            System.out.println("User has not choosen to set this mask\n");
            System.out.println("Cancel Action");
            if (this.dialog.isVisible()) {
                this.dialog.setVisible(false);
            }
        } else if (object == this.viewResultsButton) {
            Response response = new Response(1, null, 0);
            this.handleResponse((short)1, response);
        }
    }
}

