/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.Script;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScriptOptions
extends JPanel {
    private Script script;
    private GridBagConstraints gbcIndent = new GridBagConstraints();
    private GridBagConstraints gbcRegular = new GridBagConstraints();
    private Insets insetA = new Insets(20, 60, 0, 0);
    private Insets insetB = new Insets(20, 9, 0, 0);
    private JLabel scriptHelp;
    private JLabel scriptLabel;
    private JComboBox scriptBox;
    private ComboBoxEditor editor;
    static final String SCRIPT_TITLE = MessageLog.getMessageNoID("GUI2069L");

    public ScriptOptions(Script script) {
        this.script = script;
        this.gbcIndent.anchor = 17;
        this.gbcIndent.gridwidth = 1;
        this.gbcIndent.insets = this.insetA;
        this.gbcRegular.anchor = 17;
        this.gbcRegular.gridwidth = 0;
        this.gbcRegular.insets = this.insetB;
        GuiUtil.initPanel(this);
        this.scriptHelp = new JLabel(MessageLog.getMessageNoID("STG5226L"));
        String string = MessageLog.getMessageNoID("GUI2077L");
        this.scriptLabel = new JLabel(string);
        this.scriptBox = new JComboBox<String>(this.script.nameArray);
        GuiUtil.setAccessibleLabel(this.scriptLabel, this.scriptBox, "MNEMONIC_SCRIPTNAME", string, "DESCRIPTION_SCRIPTNAME");
        this.scriptBox.setEditable(true);
        this.scriptBox.setSelectedIndex(-1);
        this.editor = this.scriptBox.getEditor();
        this.add((Component)this.scriptHelp, this.gbcRegular);
        this.add((Component)this.scriptLabel, this.gbcIndent);
        this.add((Component)this.scriptBox, this.gbcRegular);
        GuiUtil.completePanel(this);
        boolean bl = Util.isEmpty(this.script.scrName);
        if (bl) {
            this.script.scrName = "";
            this.scriptBox.configureEditor(this.editor, this.script.scrName);
        } else {
            int n = 0;
            while (n < this.script.nameArray.length) {
                if (this.script.scrName.equals(this.script.nameArray[n])) break;
                ++n;
            }
            if (n < this.script.nameArray.length) {
                this.scriptBox.setSelectedIndex(n);
            } else {
                this.scriptBox.configureEditor(this.editor, this.script.scrName);
            }
        }
    }

    public void getData(Script script) {
        script.scrName = (String)this.editor.getItem();
        if (script.scrName == null) {
            script.scrName = "";
        }
    }

    public void validateData(Script script) throws GeneralException {
        if (Util.isEmpty(script.scrName)) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG3253E"));
        }
    }

    public void replace(Script script) {
    }
}

