/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class TapeLibraryGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private static boolean test = false;
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList tapeLibrarySelections;
    private NameList zoneSelections;
    private NameList zoneSetsSelections;
    public boolean allTapeLibrarySelected;
    public boolean allZonesSelected;
    public boolean allZoneSetsSelected;
    private NameList rootName;
    private TreeSet tapeLibraryIncludeSet = new TreeSet();
    private TreeSet tapeLibraryExcludeSet = new TreeSet();
    private TreeSet zoneIncludeSet = new TreeSet();
    private TreeSet zoneExcludeSet = new TreeSet();
    private TreeSet zoneSetIncludeSet = new TreeSet();
    private TreeSet zoneSetExcludeSet = new TreeSet();
    private JTree expansionTree;
    private TreeSelectorNode sourceTapeLibraryZoneLabel;
    private TreeSelectorNode sourceTapeLibraryZoneSetLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean zoneExpanding;
    private boolean zonesetExpanding;
    private static final int ROOT_ID = -5;
    private static final int TAPE_LIBRARY_ID = -4;
    private static final int ZONE_ID = -3;
    private static final int ZONESET_ID = -2;
    private static final int ALL_TAPE_LIBRARY_ID = Integer.MAX_VALUE;
    private static final int ALL_ZONE_ID = 0x7FFFFFFE;
    private static final int ALL_ZONESET_ID = 0x7FFFFFFD;
    public static final int TAPE_LIBRARY_IX = 7;
    public static final int ZONE_IX = 1;
    public static final int ZONESET_IX = 2;
    private static final String TAPE_LIBRARY_LABEL = Util.getString("TapeLibraryAlert_TapeLibraryTabTitle");
    private static final String ZONE_LABEL = Util.getString("FabricAlert_FabricZoneLabel");
    private static final String ZONESET_LABEL = Util.getString("TapeLibraryAlert_TapeLibraryZoneSetLabel");
    private static final String ALL_TAPE_LIBRARY_LABEL = Util.getString("TapeLibraryAlert_AllTapeLibraryLabel");
    private static final String ALL_ZONE_LABEL = Util.getString("TapeLibraryAlert_AllZoneLabel");
    private static final String ALL_ZONESET_LABEL = Util.getString("TapeLibraryAlert_AllZoneSetLabel");

    public TapeLibraryGroupSelector(NameList nameList, NameList nameList2, NameList nameList3, boolean bl, boolean bl2, boolean bl3) {
        this.tapeLibrarySelections = nameList;
        this.zoneSelections = nameList2;
        this.zoneSetsSelections = nameList3;
        this.allTapeLibrarySelected = bl;
        this.allZonesSelected = bl2;
        this.allZoneSetsSelected = bl3;
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList[] nameListArray = new NameList[5];
        NameList[] nameListArray2 = new NameList[5];
        NameList nameList = null;
        this.allTapeLibrarySelected = false;
        this.allZonesSelected = false;
        this.allZoneSetsSelected = false;
        NameList nameList2 = this.selector.getNameList();
        while (nameList2 != null) {
            int n = -999;
            if (nameList2.nlInfo == 134) {
                n = 7;
            } else if (nameList2.nlInfo == 135) {
                this.allTapeLibrarySelected = true;
            }
            if (n < 0) {
                nameList2 = nameList2.nlNext;
                continue;
            }
            nameList = nameList2;
            nameList2 = nameList.nlNext;
            nameList.nlNext = null;
            if (nameListArray2[n] == null) {
                nameListArray[n] = nameList;
            } else {
                nameListArray2[n].nlNext = nameList;
            }
            nameListArray2[n] = nameList;
        }
        return nameListArray;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        this.addLabelNode(TAPE_LIBRARY_LABEL, -4, treeSelectorNode);
        this.sourceTapeLibraryZoneLabel = this.addLabelNode(ZONE_LABEL, -3, treeSelectorNode);
        this.sourceTapeLibraryZoneSetLabel = this.addLabelNode(ZONESET_LABEL, -2, treeSelectorNode);
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode treeSelectorNode = null;
        TreeSelectorNode treeSelectorNode2 = null;
        TreeSelectorNode treeSelectorNode3 = null;
        TreeSelectorNode treeSelectorNode4 = null;
        TreeSelectorNode treeSelectorNode5 = this.newRoot();
        this.fillSets(this.tapeLibrarySelections, this.tapeLibraryIncludeSet, this.tapeLibraryExcludeSet, true, false);
        if (this.allTapeLibrarySelected || !this.tapeLibraryIncludeSet.isEmpty()) {
            treeSelectorNode = this.addLabelNode(TAPE_LIBRARY_LABEL, -4, treeSelectorNode5);
            if (this.allTapeLibrarySelected) {
                this.addAllMembersNode(ALL_TAPE_LIBRARY_LABEL, Integer.MAX_VALUE, 135, treeSelectorNode, true);
            }
            this.addTreeSet(treeSelectorNode, this.tapeLibraryIncludeSet);
        }
        if (!this.tapeLibraryExcludeSet.isEmpty()) {
            treeSelectorNode2 = TreeSelector.makeExcludeRoot();
            treeSelectorNode5.add(treeSelectorNode2);
            this.addTreeSet(treeSelectorNode2, this.tapeLibraryExcludeSet);
        }
        if (this.allZonesSelected) {
            treeSelectorNode3 = this.addLabelNode(ZONE_LABEL, -3, treeSelectorNode5);
            if (this.allZonesSelected) {
                this.addAllMembersNode(ALL_ZONE_LABEL, 0x7FFFFFFE, 13, treeSelectorNode3, true);
            }
            this.addTreeSet(treeSelectorNode3, this.zoneIncludeSet);
        }
        NameList nameList = this.zoneSelections;
        while (nameList != null) {
            if (treeSelectorNode3 == null) {
                treeSelectorNode3 = this.addLabelNode(ZONE_LABEL, -3, treeSelectorNode5);
            }
            treeSelectorNode3.add(new TreeSelectorNode(nameList, true, false, true, true, null, true, true));
            nameList = nameList.nlNext;
        }
        if (this.allZonesSelected || !this.zoneIncludeSet.isEmpty()) {
            treeSelectorNode4 = this.addLabelNode(ZONESET_LABEL, -2, treeSelectorNode5);
            if (this.allZonesSelected) {
                this.addAllMembersNode(ALL_ZONESET_LABEL, 0x7FFFFFFE, 13, treeSelectorNode4, true);
            }
        }
        nameList = this.zoneSetsSelections;
        while (nameList != null) {
            if (treeSelectorNode4 == null) {
                treeSelectorNode4 = this.addLabelNode(ZONESET_LABEL, -2, treeSelectorNode5);
            }
            treeSelectorNode4.add(new TreeSelectorNode(nameList, true, false, true, true, null, false, true));
            nameList = nameList.nlNext;
        }
        return treeSelectorNode5;
    }

    private void buildSelectedTree() {
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList nameList, NameList nameList2, NameList nameList3, boolean bl, boolean bl2, boolean bl3) {
        this.tapeLibrarySelections = nameList;
        this.zoneSelections = nameList2;
        this.zoneSetsSelections = nameList3;
        this.allTapeLibrarySelected = bl;
        this.allZonesSelected = bl2;
        this.allZoneSetsSelected = bl3;
        this.tapeLibraryIncludeSet.clear();
        this.tapeLibraryExcludeSet.clear();
        this.zoneIncludeSet.clear();
        this.zoneExcludeSet.clear();
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(treeSelectorNode, true);
        this.selectedTree.setModel(defaultTreeModel);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList nameList, TreeSet treeSet, TreeSet treeSet2, boolean bl, boolean bl2) {
        boolean bl3 = true;
        TreeSelectorNode treeSelectorNode = null;
        while (nameList != null) {
            boolean bl4;
            boolean bl5;
            TreeSet treeSet3;
            if (Constants.isVirtualServer(nameList.nlID2)) {
                nameList = nameList.nlNext;
                continue;
            }
            if ((nameList.nlState & 1) != 0) {
                treeSet3 = treeSet2;
                bl5 = false;
                bl4 = true;
            } else {
                treeSet3 = treeSet;
                bl5 = bl;
                bl4 = bl2;
            }
            if (this.zoneExpanding) {
                bl3 = false;
            }
            treeSelectorNode = new TreeSelectorNode(nameList, bl5, bl4, false, false, null, bl3, true);
            if (this.zoneExpanding || this.zonesetExpanding) {
                treeSelectorNode.setButtonFlag(false);
            }
            treeSet3.add(treeSelectorNode);
            nameList = nameList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode treeSelectorNode, TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)iterator.next();
            treeSelectorNode.add(treeSelectorNode2);
        }
    }

    public void invalidateGroups(short s) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, s);
    }

    public void addGroup(NameList nameList) {
        TreeSelectorNode treeSelectorNode;
        if (nameList.nlID == -3) {
            treeSelectorNode = this.sourceTapeLibraryZoneLabel;
        } else if (nameList.nlID == -2) {
            treeSelectorNode = this.sourceTapeLibraryZoneSetLabel;
        } else {
            return;
        }
        if (!treeSelectorNode.childrenFetched) {
            return;
        }
        NameList nameList2 = (NameList)nameList.clone();
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList2, true, false, true, true, null);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(defaultTreeModel, treeSelectorNode, treeSelectorNode2);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.zoneExpanding = false;
        this.zonesetExpanding = false;
        TreePath treePath = treeExpansionEvent.getPath();
        this.expansionNode = (TreeSelectorNode)treePath.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList nameList = this.expansionNode.getNameList();
        this.expansionTree = (JTree)treeExpansionEvent.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (nameList.nlID == -3) {
                this.sendRequest((short)0, -1);
            } else if (nameList.nlID == -4) {
                this.sendRequest((short)134, -1);
            } else if (nameList.nlID == -2) {
                this.sendRequest((short)77, -1);
            }
        } else if (nameList.nlInfo == 134) {
            this.sendRequest((short)134, nameList.nlID);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    protected GuiListReq makeListRequestData(short s, int n) {
        GuiListReq guiListReq = new GuiListReq();
        if (s == 99) {
            guiListReq.listRequested = 11;
        } else {
            if (s == 101) {
                s = (short)99;
            }
            guiListReq.listRequested = 10000 + s;
            guiListReq.groupID = n;
        }
        return guiListReq;
    }

    protected GroupDefinition makeGroupRequestData(short s, int n) {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = s;
        groupDefinition.ID = n;
        return groupDefinition;
    }

    private void sendRequest(short s, int n) {
        Request request;
        if (s == 99) {
            GroupDefinition groupDefinition = this.makeGroupRequestData(s, n);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", groupDefinition);
        } else {
            GuiListReq guiListReq = this.makeListRequestData(s, n);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        }
        GuiClient.doRequest(this, request);
    }

    private NameList makeFakeData() {
        NameList nameList = null;
        NameList nameList2 = this.expansionNode.getNameList();
        if (nameList2.nlID == -4) {
            NameList nameList3 = new NameList();
            nameList3.nlName = "tapeLibrary1";
            nameList3.nlInfo = (short)134;
            nameList3.nlNext = nameList;
            nameList = nameList3;
            nameList3 = new NameList();
            nameList3.nlName = "tapeLibrary2";
            nameList3.nlInfo = (short)134;
            nameList3.nlNext = nameList;
            nameList = nameList3;
        }
        return nameList;
    }

    public void handleResponse(short s, Response response) {
        boolean bl;
        NameList nameList = null;
        if (test) {
            nameList = this.makeFakeData();
        } else {
            if (s > 4) {
                return;
            }
            Serializable serializable = response.responseData;
            if (serializable instanceof GroupDefinition) {
                GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
                nameList = groupDefinition.members;
            } else {
                nameList = (NameList)response.responseData;
            }
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        boolean bl2 = this.expansionTree == this.sourceTree;
        boolean bl3 = bl = !bl2;
        if (nameList.nlInfo == 134) {
            if (bl2) {
                this.addAllMembersNode(ALL_TAPE_LIBRARY_LABEL, Integer.MAX_VALUE, 135, this.expansionNode, false);
            }
            this.tapeLibraryIncludeSet.clear();
            this.fillSets(nameList, this.tapeLibraryIncludeSet, this.tapeLibraryExcludeSet, bl2, bl);
            this.addTreeSet(this.expansionNode, this.tapeLibraryIncludeSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -5, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addLabelNode(String string, int n, TreeSelectorNode treeSelectorNode) {
        NameList nameList = this.newNameList(string, n, -1);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode2.setButtonFlag(false);
        treeSelectorNode2.setSortKey(n);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private void addAllMembersNode(String string, int n, int n2, TreeSelectorNode treeSelectorNode, boolean bl) {
        NameList nameList = this.newNameList(string, n, n2);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.add(treeSelectorNode2);
    }

    private NameList newNameList(String string, int n, int n2) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlInfo = (short)n2;
        return nameList;
    }
}

