/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolumeGroupData
implements GuiRequestor {
    public static final int GROUP_SEPARATION = 12;
    private boolean isLodestoneCluster = false;
    private boolean isDiskArray = false;
    private NameList volgroup;
    private NameList computer;
    private JPanel panel;

    public static void addItem(Container container, GridBagConstraints gridBagConstraints, String string, String string2) {
        String string3 = MessageLog.getMessageNoID(string);
        JLabel jLabel = new JLabel(string3);
        jLabel.setFont(BaseTree.boldFont);
        jLabel.setForeground(Color.black);
        gridBagConstraints.gridwidth = 1;
        container.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(string2);
        jLabel.setFont(BaseTree.plainFont);
        jLabel.setForeground(Color.black);
        gridBagConstraints.gridwidth = 0;
        int n = gridBagConstraints.insets.left;
        gridBagConstraints.insets.left = 24;
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = n;
    }

    public VolumeGroupData(NameList nameList, NameList nameList2) {
        this.volgroup = nameList;
        this.computer = nameList2;
        this.panel = null;
        if (this.computer.nlID2 == 21) {
            this.isLodestoneCluster = true;
        }
        if (Constants.isDiskArray((short)this.computer.nlID2)) {
            this.isDiskArray = true;
        }
    }

    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(new GridBagLayout());
        Request request = GuiRequest.makeVolumeGroupInfoRequest(this.volgroup.nlID, this.volgroup.nlID2);
        GuiClient.doRequest(this, request);
        return this.panel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        VolGroup volGroup = (VolGroup)response.responseData;
        if (volGroup == null) {
            return;
        }
        String string = volGroup.vgType == 2 || volGroup.vgType == 4 || volGroup.vgType == 5 ? "SAG0060I" : (volGroup.vgType == 3 || volGroup.vgType == 6 ? (this.isLodestoneCluster ? "SAG0063I" : "SAG0062I") : (volGroup.vgType == 1 ? "SAG0061I" : "STG6210L"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.top = 30;
        gridBagConstraints.insets.bottom = 20;
        VolumeGroupData.addItem(this.panel, gridBagConstraints, string, volGroup.vgName);
        gridBagConstraints.insets.top = 0;
        if (volGroup.vgType == 2 || volGroup.vgType == 4 || volGroup.vgType == 5 || volGroup.vgType == 3 && this.computer.nlID2 != 8 || volGroup.vgType == 6 && this.computer.nlID2 != 8) {
            String string2;
            String string3;
            gridBagConstraints.insets.bottom = 12;
            string = this.isLodestoneCluster ? "STG4500L" : "SAG0001L";
            VolumeGroupData.addItem(this.panel, gridBagConstraints, string, this.computer.nlName);
            gridBagConstraints.insets.bottom = 0;
            if (volGroup.vgType == 2) {
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0027L", volGroup.vgDiskGroup);
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG6105L", volGroup.vgLSS);
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG1132L", volGroup.getConfig());
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0038L", volGroup.getTrackFormat());
            }
            if (volGroup.vgType == 4 || volGroup.vgType == 5) {
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0093L", volGroup.getArraySitesforDisplay());
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0101L", volGroup.vgRank);
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0099L", volGroup.getConfigsforDisplay());
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0038L", volGroup.getTrackFormat());
            }
            if (volGroup.vgType == 6) {
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0099L", volGroup.getConfigsforDisplay());
            }
            if (volGroup.vgType == 3 && volGroup.vgConfig != 11) {
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG1132L", volGroup.getConfig());
            }
            gridBagConstraints.insets.bottom = 12;
            String string4 = null;
            string4 = this.isDiskArray ? volGroup.getOperationalStatus(volGroup.vgOperationalStatus) : volGroup.getStatus();
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0042L", string4);
            if (this.isLodestoneCluster) {
                gridBagConstraints.insets.bottom = 12;
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0064L", Util.formatPrefBytes(volGroup.vgExtentSize * 1024 * 1024));
                String string5 = Util.formatPrefBytes(volGroup.vgTotalSpace * 512L);
                String string6 = Util.formatPrefBytes(volGroup.vgFreeSpace * 512L);
                string3 = Util.formatPrefBytes(volGroup.vgSurfacedLunCap * 512L);
                string2 = Util.formatPrefBytes(volGroup.vgUnSurfacedLunCap * 512L);
                gridBagConstraints.insets.bottom = 0;
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0073L", string5);
                gridBagConstraints.insets.bottom = 12;
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0074L", string6);
            } else {
                String string7 = Util.formatPrefBytes(volGroup.vgTotalSpace << 9);
                String string8 = Util.formatPrefBytes(volGroup.vgFreeSpace << 9);
                string3 = Util.formatPrefBytes(volGroup.vgSurfacedLunCap << 9);
                string2 = Util.formatPrefBytes(volGroup.vgUnSurfacedLunCap << 9);
                gridBagConstraints.insets.bottom = 0;
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0037L", string7);
                gridBagConstraints.insets.bottom = 12;
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0041L", string8);
            }
            gridBagConstraints.insets.bottom = 0;
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0008L", Integer.toString(volGroup.vgDisks));
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0009L", Integer.toString(volGroup.vgVolumes));
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0039L", string3);
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0040L", string2);
            if (volGroup.vgType == 4 || volGroup.vgType == 5) {
                long l = volGroup.vgTotalSpace - volGroup.vgFreeSpace - volGroup.vgSurfacedLunCap - volGroup.vgUnSurfacedLunCap;
                String string9 = Util.formatPrefBytes(l << 9);
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "SAG0102L", string9);
            }
        } else {
            String string10;
            gridBagConstraints.insets.bottom = 12;
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG1102L", this.computer.nlName);
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG1132L", volGroup.getType());
            if (this.computer.nlID2 != 8) {
                gridBagConstraints.insets.bottom = 0;
                string10 = Integer.toString(volGroup.vgDisks);
                VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG6057L", string10);
            }
            gridBagConstraints.insets.bottom = 12;
            string10 = Integer.toString(volGroup.vgVolumes);
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG6202L", string10);
            gridBagConstraints.insets.bottom = 0;
            string10 = Util.formatPrefBytes(volGroup.vgTotalSpace << 9);
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG1162L", string10);
            gridBagConstraints.insets.bottom = 12;
            string10 = Util.formatPrefBytes(volGroup.vgFreeSpace << 9);
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG1184L", string10);
            gridBagConstraints.insets.bottom = 0;
            string10 = DateFormat.getDateTimeInstance().format(new Date(volGroup.vgDiscoveredTime));
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG1134L", string10);
            string10 = DateFormat.getDateTimeInstance().format(new Date(volGroup.vgProbeTime));
            VolumeGroupData.addItem(this.panel, gridBagConstraints, "STG1119L", string10);
        }
        GuiUtil.completePanel(this.panel);
    }
}

