/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.aperi.common.LockRequestor;
import org.eclipse.aperi.common.LockResource;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.logging.TraceLogger;

public class LockManager {
    public static final boolean WAIT = true;
    public static final boolean NOWAIT = false;
    private static HashMap[] productLockMaps;

    static {
        LockManager.initProductLockMaps();
    }

    public static void initProductLockMaps() {
        productLockMaps = new HashMap[5];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean lock(short s, String string, String string2, byte by, boolean bl) {
        Class<?> clazz;
        Object object;
        HashMap hashMap;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "lock", "productID, resourceType, resourceName, lockType, waitForLock");
        }
        if ((hashMap = productLockMaps[s]) == null) {
            object = productLockMaps;
            // MONITORENTER : productLockMaps
            if (productLockMaps[s] == null) {
                LockManager.productLockMaps[s] = new HashMap();
            }
            hashMap = productLockMaps[s];
            // MONITOREXIT : object
        }
        object = LockManager.makeHashKey(string, string2);
        LockRequestor lockRequestor = LockRequestor.getLockRequestor(by);
        HashMap hashMap2 = hashMap;
        // MONITORENTER : hashMap2
        LockResource lockResource = LockManager.getLockResource(hashMap, (String)object, s, true);
        boolean bl2 = LockManager.lock(lockResource, lockRequestor, bl);
        // MONITOREXIT : hashMap2
        if (!bl2) {
            if (bl) {
                Class<?> clazz3;
                boolean bl3 = LockManager.waitOnLock(lockRequestor);
                if (!TraceLogger.enableTrace) return bl3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.backend.LockManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz3.getName(), "lock", bl3);
                return bl3;
            }
            lockRequestor.returnLockRequestor();
        }
        boolean bl4 = bl2;
        if (!TraceLogger.enableTrace) return bl4;
        try {
            clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit(clazz.getName(), "lock", bl4);
        return bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unLock(short s, String string, String string2) {
        HashMap hashMap;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "unLock", "productID, resourceType, resourceName");
        }
        if ((hashMap = productLockMaps[s]) == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "unLock");
            }
            return;
        }
        String string3 = LockManager.makeHashKey(string, string2);
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            LockResource lockResource = LockManager.getLockResource(hashMap, string3, s, false);
            if (lockResource != null) {
                LockManager.unLock(lockResource, hashMap, string3);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "unLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResource lockQuery(short s) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "lockQuery", "productID");
        }
        LockResource lockResource = null;
        HashMap hashMap = productLockMaps[s];
        if (hashMap == null) {
            LockResource lockResource2 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "lockQuery", lockResource2);
            }
            return lockResource2;
        }
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                LockResource lockResource3 = (LockResource)iterator.next();
                LockResource lockResource4 = LockManager.makeQueryCopy(lockResource3);
                lockResource4.lrsNext = lockResource;
                lockResource = lockResource4;
            }
        }
        hashMap2 = lockResource;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "lockQuery", hashMap2);
        }
        return hashMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResource lockQuery(short s, String string, String string2) {
        String string3;
        HashMap hashMap;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "lockQuery", "productID, resourceType, resourceName");
        }
        if ((hashMap = productLockMaps[s]) != null) {
            string3 = LockManager.makeHashKey(string, string2);
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                LockResource lockResource = LockManager.getLockResource(hashMap, string3, s, false);
                if (lockResource != null) {
                    LockResource lockResource2 = LockManager.makeQueryCopy(lockResource);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit(clazz.getName(), "lockQuery", lockResource2);
                    }
                    return lockResource2;
                }
            }
        }
        string3 = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "lockQuery", string3);
        }
        return string3;
    }

    public static native void lockJavaObject(Object var0);

    public static native void unLockJavaObject(Object var0);

    private static LockResource makeQueryCopy(LockResource lockResource) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "makeQueryCopy", "a");
        }
        LockResource lockResource2 = (LockResource)lockResource.clone();
        Packable packable = lockResource2.lrsHolders;
        while (packable != null) {
            packable.lrqThread = ((Thread)packable.lrqThread).toString();
            packable = packable.lrqNext;
        }
        packable = lockResource2.lrsWaitersHead;
        while (packable != null) {
            packable.lrqThread = ((Thread)packable.lrqThread).toString();
            packable = packable.lrqNext;
        }
        packable = lockResource2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "makeQueryCopy", packable);
        }
        return packable;
    }

    private static String makeHashKey(String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "makeHashKey", "resourceType, resourceName");
        }
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(string);
        stringBuffer.append('.');
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "makeHashKey", string3);
        }
        return string3;
    }

    private static LockResource getLockResource(HashMap hashMap, String string, short s, boolean bl) {
        LockResource lockResource;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getLockResource", "lockMap, hashKey, productID, create");
        }
        if ((lockResource = (LockResource)hashMap.get(string)) == null && bl) {
            lockResource = LockResource.getLockResource(s, string);
            hashMap.put(string, lockResource);
        }
        LockResource lockResource2 = lockResource;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "getLockResource", lockResource2);
        }
        return lockResource2;
    }

    private static boolean lock(LockResource lockResource, LockRequestor lockRequestor, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "lock", "lrs, lrq, waitForLock");
        }
        if (lockResource.lrsHolders == null || lockResource.lrsWaitersHead == null && lockRequestor.lrqLockType == 2 && lockResource.lrsHolders.lrqLockType == 2) {
            LockManager.grantLock(lockResource, lockRequestor);
            boolean bl2 = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "lock", bl2);
            }
            return bl2;
        }
        if (bl) {
            LockManager.queueWaiter(lockResource, lockRequestor);
        }
        boolean bl3 = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "lock", bl3);
        }
        return bl3;
    }

    private static void unLock(LockResource lockResource, HashMap hashMap, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "unLock", "lrs, lockMap, hashKey");
        }
        LockRequestor lockRequestor = null;
        Thread thread = Thread.currentThread();
        LockRequestor lockRequestor2 = lockResource.lrsHolders;
        while (lockRequestor2 != null && thread != (Thread)lockRequestor2.lrqThread) {
            lockRequestor = lockRequestor2;
            lockRequestor2 = lockRequestor2.lrqNext;
        }
        if (lockRequestor2 == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "unLock");
            }
            return;
        }
        if (lockRequestor == null) {
            lockResource.lrsHolders = lockRequestor2.lrqNext;
        } else {
            lockRequestor.lrqNext = lockRequestor2.lrqNext;
        }
        lockRequestor2.returnLockRequestor();
        if (lockResource.lrsHolders == null) {
            while (lockResource.lrsWaitersHead != null) {
                if (lockResource.lrsHolders != null && (lockResource.lrsWaitersHead.lrqLockType == 1 || lockResource.lrsHolders.lrqLockType == 1)) break;
                lockRequestor2 = LockManager.dequeueWaiter(lockResource);
                LockManager.grantLock(lockResource, lockRequestor2);
                ((Thread)lockRequestor2.lrqThread).interrupt();
            }
            if (lockResource.lrsHolders == null) {
                hashMap.remove(string);
                lockResource.returnLockResource();
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "unLock");
        }
    }

    private static boolean waitOnLock(LockRequestor lockRequestor) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "waitOnLock", "lrq");
        }
        while (!lockRequestor.lrqHaveLock) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) continue;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "waitOnLock", interruptedException);
            }
        }
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "waitOnLock", bl);
        }
        return bl;
    }

    private static void grantLock(LockResource lockResource, LockRequestor lockRequestor) {
        lockRequestor.lrqNext = lockResource.lrsHolders;
        lockResource.lrsHolders = lockRequestor;
        lockRequestor.lrqTimestamp = System.currentTimeMillis();
        lockRequestor.lrqHaveLock = true;
    }

    private static void queueWaiter(LockResource lockResource, LockRequestor lockRequestor) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "queueWaiter", "lrs, lrq");
        }
        lockRequestor.lrqNext = null;
        lockRequestor.lrqTimestamp = System.currentTimeMillis();
        if (lockResource.lrsWaitersTail != null) {
            lockResource.lrsWaitersTail.lrqNext = lockRequestor;
        } else {
            lockResource.lrsWaitersHead = lockRequestor;
        }
        lockResource.lrsWaitersTail = lockRequestor;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "queueWaiter");
        }
    }

    private static LockRequestor dequeueWaiter(LockResource lockResource) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "dequeueWaiter", "lrs");
        }
        LockRequestor lockRequestor = lockResource.lrsWaitersHead;
        lockResource.lrsWaitersHead = lockRequestor.lrqNext;
        if (lockResource.lrsWaitersHead == null) {
            lockResource.lrsWaitersTail = null;
        }
        LockRequestor lockRequestor2 = lockRequestor;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LockManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "dequeueWaiter", lockRequestor2);
        }
        return lockRequestor2;
    }
}

