/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.identifier;

import java.io.Serializable;
import org.eclipse.aperi.common.api.Distinguishable;

public abstract class SRMIdentifier
implements Cloneable,
Comparable,
Serializable,
Distinguishable {
    private String strInternalName;
    private String strDisplayName;
    static final long serialVersionUID = 2888504115749158722L;

    public SRMIdentifier(String string) throws IllegalArgumentException {
        this(string, null);
    }

    public SRMIdentifier(String string, String string2) throws IllegalArgumentException {
        this.setInternalName(string);
        this.setDisplayName(string2);
    }

    public final String getInternalName() {
        return this.strInternalName;
    }

    public final String getDisplayName() {
        return this.strDisplayName;
    }

    public final String generateName() {
        String string = this.getDisplayName();
        return string == null || string.length() == 0 ? this.getInternalName() : string;
    }

    public synchronized void setInternalName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The specified internal identifier is invalid (null.)");
        }
        this.strInternalName = string;
    }

    public synchronized void setDisplayName(String string) {
        this.strDisplayName = string;
    }

    public boolean equals(Object object) {
        if (object instanceof SRMIdentifier) {
            return this.strInternalName.equals(((SRMIdentifier)object).strInternalName);
        }
        return false;
    }

    public int compareTo(Object object) {
        return this.strInternalName.compareTo(((SRMIdentifier)object).strInternalName);
    }

    public boolean isIdentical(Object object) {
        return object instanceof SRMIdentifier && ((SRMIdentifier)object).strInternalName.equals(this.strInternalName) && ((SRMIdentifier)object).strDisplayName.equals(this.strDisplayName);
    }

    public int hashCode() {
        int n = this.strInternalName.length();
        return (n < 4 ? 0 : this.strInternalName.charAt(n - 4) << 24) + (n < 3 ? 0 : this.strInternalName.charAt(n - 3) << 16) + (n < 2 ? 0 : this.strInternalName.charAt(n - 2) << 8) + (n < 1 ? 0 : (int)this.strInternalName.charAt(n - 1));
    }

    public String toString() {
        if (this.strDisplayName == null) {
            return this.strInternalName;
        }
        return String.valueOf(this.strDisplayName) + " (" + this.strInternalName + ")";
    }

    public Object clone() {
        SRMIdentifier sRMIdentifier = null;
        try {
            sRMIdentifier = (SRMIdentifier)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return sRMIdentifier;
    }
}

