/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.constants.metadata;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aperi.constants.metadata.IMetadataManagerListener;
import org.eclipse.aperi.constants.metadata.IMetadataSource;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataManager
implements IRegistryChangeListener,
IDisposable {
    public static final String ATTR_CLASS = "class";
    private String extensionPointId;
    private Set<IMetadataManagerListener> listenerSet;
    private Map<String, IMetadataSource> metadataSourceCache;
    private ReadWriteLock cacheLock;

    public MetadataManager(String string) {
        this.extensionPointId = string;
        this.listenerSet = new HashSet<IMetadataManagerListener>();
        this.metadataSourceCache = new HashMap<String, IMetadataSource>();
        this.cacheLock = new ReentrantReadWriteLock(true);
    }

    public void initialize() {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        if (iExtensionRegistry != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(this.extensionPointId);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                try {
                    this.addSource(iConfigurationElementArray[n]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        } else {
            throw new RuntimeException("Failed to obtain reference to extension registry.");
        }
        iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.cacheLock.writeLock().lock();
        try {
            RegistryFactory.getRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
            Iterator<IMetadataSource> iterator = this.metadataSourceCache.values().iterator();
            while (true) {
                block6: {
                    if (iterator.hasNext()) break block6;
                    this.metadataSourceCache.clear();
                    this.listenerSet.clear();
                    break;
                }
                IMetadataSource iMetadataSource = iterator.next();
                try {
                    iMetadataSource.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.cacheLock.writeLock().unlock();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.cacheLock.writeLock().unlock();
            return;
        }
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            IExtension iExtension = iExtensionDeltaArray[n].getExtension();
            if (iExtension.getExtensionPointUniqueIdentifier().equals(this.extensionPointId)) {
                int n2;
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                if (iExtensionDeltaArray[n].getKind() == 1) {
                    n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        try {
                            this.addSource(iConfigurationElementArray[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                } else if (iExtensionDeltaArray[n].getKind() == 2) {
                    n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        try {
                            this.removeSource(iConfigurationElementArray[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object object, String string) {
        Object object2 = null;
        this.cacheLock.readLock().lock();
        try {
            Iterator<IMetadataSource> iterator = this.metadataSourceCache.values().iterator();
            while (iterator.hasNext() && (object2 = iterator.next().getValue(object, string)) == null) {
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cacheLock.readLock().unlock();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.cacheLock.readLock().unlock();
            return object2;
        }
    }

    public Lock getCacheReadLock() {
        return this.cacheLock.readLock();
    }

    public Set<?> getSupportedConstants() {
        return this.getSupportedConstants(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<?> getSupportedConstants(boolean bl) {
        AbstractSet abstractSet = bl ? new TreeSet() : new HashSet();
        this.cacheLock.readLock().lock();
        try {
            Iterator<IMetadataSource> iterator = this.metadataSourceCache.values().iterator();
            while (iterator.hasNext()) {
                abstractSet.addAll(iterator.next().getSupportedConstants());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.cacheLock.readLock().unlock();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.cacheLock.readLock().unlock();
            return abstractSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IMetadataManagerListener iMetadataManagerListener) {
        Set<IMetadataManagerListener> set = this.listenerSet;
        synchronized (set) {
            this.listenerSet.add(iMetadataManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IMetadataManagerListener iMetadataManagerListener) {
        Set<IMetadataManagerListener> set = this.listenerSet;
        synchronized (set) {
            this.listenerSet.remove(iMetadataManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addSource(IConfigurationElement iConfigurationElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            String string = iConfigurationElement.getAttribute(ATTR_CLASS);
            if (this.metadataSourceCache.containsKey(string)) {
                throw new RuntimeException(new StringBuffer("Metadata source named ").append(string).append(" is already registred.").toString());
            }
            IMetadataSource iMetadataSource = (IMetadataSource)iConfigurationElement.createExecutableExtension(ATTR_CLASS);
            this.metadataSourceCache.put(string, iMetadataSource);
            Set<IMetadataManagerListener> set = this.listenerSet;
            synchronized (set) {
                Iterator<IMetadataManagerListener> iterator = this.listenerSet.iterator();
                while (true) {
                    block10: {
                        if (iterator.hasNext()) break block10;
                        break;
                    }
                    try {
                        iterator.next().metadataSourceAdded(iMetadataSource);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.cacheLock.writeLock().unlock();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.cacheLock.writeLock().unlock();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeSource(IConfigurationElement iConfigurationElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            String string = iConfigurationElement.getAttribute(ATTR_CLASS);
            IMetadataSource iMetadataSource = this.metadataSourceCache.remove(string);
            if (iMetadataSource != null) {
                Set<IMetadataManagerListener> set = this.listenerSet;
                synchronized (set) {
                    Iterator<IMetadataManagerListener> iterator = this.listenerSet.iterator();
                    while (iterator.hasNext()) {
                        try {
                            iterator.next().metadataSourceRemoved(iMetadataSource);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                iMetadataSource.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.cacheLock.writeLock().unlock();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.cacheLock.writeLock().unlock();
            return;
        }
    }
}

