/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.eclipse.aperi.gui.ColumnGroup;
import org.eclipse.aperi.gui.GroupableTableHeader;
import org.eclipse.aperi.gui.WrappingHeaderRenderer;

class GroupableTableHeaderUI
extends BasicTableHeaderUI {
    GroupableTableHeaderUI() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        ((GroupableTableHeader)this.header).setColumnMargin();
        int n = 0;
        Dimension dimension = this.header.getSize();
        Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
        Hashtable<ColumnGroup, Rectangle> hashtable = new Hashtable<ColumnGroup, Rectangle>();
        this.header.getColumnModel().getColumnMargin();
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            rectangle2.height = dimension.height;
            rectangle2.y = 0;
            TableColumn tableColumn = enumeration.nextElement();
            Enumeration enumeration2 = ((GroupableTableHeader)this.header).getColumnGroups(tableColumn);
            if (enumeration2 != null) {
                int n2 = 0;
                while (enumeration2.hasMoreElements()) {
                    ColumnGroup columnGroup = (ColumnGroup)enumeration2.nextElement();
                    Rectangle rectangle3 = (Rectangle)hashtable.get(columnGroup);
                    if (rectangle3 == null) {
                        rectangle3 = new Rectangle(rectangle2);
                        Dimension dimension2 = columnGroup.getSize(this.header.getTable());
                        rectangle3.width = dimension2.width;
                        rectangle3.height = dimension2.height;
                        hashtable.put(columnGroup, rectangle3);
                    }
                    this.paintCell(graphics, rectangle3, columnGroup);
                    rectangle2.height = dimension.height - (n2 += rectangle3.height);
                    rectangle2.y = n2;
                }
            }
            rectangle2.width = tableColumn.getWidth();
            if (rectangle2.intersects(rectangle)) {
                this.paintCell(graphics, rectangle2, n);
            }
            rectangle2.x += rectangle2.width;
            ++n;
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = new WrappingHeaderRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, ColumnGroup columnGroup) {
        TableCellRenderer tableCellRenderer = columnGroup.getHeaderRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), columnGroup.getHeaderValue(), false, false, -1, -1);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int getHeaderHeight() {
        int n = 0;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = 0;
        while (n2 < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = new WrappingHeaderRenderer();
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
            int n3 = component.getPreferredSize().height;
            Enumeration enumeration = ((GroupableTableHeader)this.header).getColumnGroups(tableColumn);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    ColumnGroup columnGroup = (ColumnGroup)enumeration.nextElement();
                    n3 += columnGroup.getSize((JTable)this.header.getTable()).height;
                }
            }
            n = Math.max(n, n3);
            ++n2;
        }
        return n;
    }

    private Dimension createHeaderSize(int n) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if ((n += tableColumnModel.getColumnMargin() * tableColumnModel.getColumnCount()) > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        return new Dimension(n, this.getHeaderHeight());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 0;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            n += tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(n);
    }
}

