/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.admin.OutOfBandFabricAgentDDI;
import org.eclipse.aperi.gui.admin.OutOfBandFabricAgentTreeNode;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class OutOfBandAgentPanel
extends JPanel
implements GuiRequestor,
ActionListener,
Serializable {
    private Vector listeners = new Vector();
    private String node_name;
    private String node_ip;
    private OutOfBandFabricAgentDDI node_ddi;
    private JTextField jStatus = null;
    private JTextField jIPAddress = null;
    private JLabel jStatusLabel = null;
    private JLabel jIPAddressLabel = null;
    private JPanel jContentPane = null;
    private JPanel jOkCancelPanel = null;
    private JPanel jMainPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel jGeneralInfoPanel = null;
    private JPanel jGeneralInfoLabelPanel = null;
    private JPanel jGeneralInfoControlPanel = null;
    private JLabel jHostLabel = null;
    private JTextField jHostTextField = null;
    private JLabel jSNMPCommunityLabel = null;
    private JTextField jSNMPCommunityTextField = null;
    private JLabel jGeneralInfoLabel = null;
    private JLabel jUserNameLabel = null;
    private JTextField jUsernameTextField = null;
    private JLabel jPasswordLabel = null;
    private JPasswordField jPasswordField = null;
    private String rememberedUN = null;
    private String rememberedPW = null;
    private final int SPACER_WIDTH = 30;
    private final int SPACER_HEIGHT = 10;
    public static final int PROPERTY_PAGE = 1;
    public static final int DIALOG_BOX = 2;
    private int displayMode = 1;
    private BaseTreeNode parentNode;
    private JPanel jEastSpacer = null;
    private JPanel jWestSpacer = null;
    private JPanel jNorthSpacer = null;
    private OutOfBandFabricAgentInfo oobInitialValues;
    public OutOfBandFabricAgentInfo oobResponse;
    private static String OOBFA_SNMP_COMMUNITY = "public";
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    private void enableOkAndCancelButtons(boolean bl) {
        if (bl) {
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAction(ActionEvent actionEvent) {
        Vector vector;
        OutOfBandAgentPanel outOfBandAgentPanel = this;
        synchronized (outOfBandAgentPanel) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ActionListener actionListener = (ActionListener)vector.elementAt(n);
            actionListener.actionPerformed(actionEvent);
            ++n;
        }
    }

    public OutOfBandAgentPanel(int n) {
        this.displayMode = n;
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.enableOkAndCancelButtons(false);
            this.savePanelChanges();
            return;
        }
        if (actionEvent.getActionCommand().equals("CANCEL") && this.displayMode == 1) {
            this.stateChanged();
        }
        this.fireAction(actionEvent);
    }

    private boolean checkForPrivateField(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < cArray.length) {
            if (!bl && cArray[n] == ' ') {
                bl = true;
            } else if (!bl2 && bl && cArray[n] == ':') {
                bl2 = true;
            } else if (bl2 && bl && cArray[n] == ' ') {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void savePanelChanges() {
        Object object;
        OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = new OutOfBandFabricAgentInfo();
        outOfBandFabricAgentInfo.request_type = this.displayMode == 2 ? 2 : 5;
        String string = this.jHostTextField.getText();
        if (outOfBandFabricAgentInfo.request_type == 5) {
            outOfBandFabricAgentInfo.hostname = this.node_name;
            outOfBandFabricAgentInfo.ipaddress = this.node_ip;
        } else {
            outOfBandFabricAgentInfo.hostname = string;
            outOfBandFabricAgentInfo.ipaddress = string;
        }
        String string2 = this.jSNMPCommunityTextField.getText();
        if (this.checkForPrivateField(string2)) {
            object = new StringTokenizer(string2, ":");
            outOfBandFabricAgentInfo.communityname = ((StringTokenizer)object).nextToken().trim();
            outOfBandFabricAgentInfo.communityname_rw = ((StringTokenizer)object).nextToken().trim();
        } else {
            outOfBandFabricAgentInfo.communityname = string2.trim();
        }
        outOfBandFabricAgentInfo.username = null;
        outOfBandFabricAgentInfo.password = null;
        outOfBandFabricAgentInfo.hostname = outOfBandFabricAgentInfo.hostname.trim();
        if (outOfBandFabricAgentInfo.username != null) {
            outOfBandFabricAgentInfo.username = outOfBandFabricAgentInfo.username.trim();
        }
        object = new Request();
        ((Request)object).typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        ((Request)object).serviceName = RequestTypeManager.getInternalName(((Request)object).typeCode);
        ((Request)object).subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
        ((Request)object).userName = GuiUtil.getUserName();
        ((Request)object).requestData = outOfBandFabricAgentInfo;
        ((Request)object).flags = (byte)4;
        GuiClient.doRequest(this, (Request)object);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(150, 150);
        this.add((Component)this.getJContentPane(), "Center");
        GuiUtil.centerDialog(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            BorderLayout borderLayout = new BorderLayout();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout);
            borderLayout.setHgap(0);
            borderLayout.setVgap(0);
            this.jContentPane.add((Component)this.getJNorthSpacer(), "North");
            this.jContentPane.add((Component)this.getJEastSpacer(), "East");
            this.jContentPane.add((Component)this.getJWestSpacer(), "West");
            this.jContentPane.add((Component)this.getJOkCancelPanel(), "South");
            this.jContentPane.add((Component)this.getJMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJOkCancelPanel() {
        if (this.jOkCancelPanel == null) {
            this.jOkCancelPanel = new JPanel();
            this.jOkCancelPanel.add((Component)this.getOkButton(), null);
            this.jOkCancelPanel.add((Component)this.getCancelButton(), null);
        }
        return this.jOkCancelPanel;
    }

    private JPanel getJMainPanel() {
        if (this.jMainPanel == null) {
            this.jMainPanel = new JPanel();
            this.jMainPanel.setLayout(new BoxLayout(this.jMainPanel, 1));
            this.jMainPanel.add((Component)this.getJGeneralInfoPanel(), null);
        }
        return this.jMainPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setName("OK");
            this.okButton.setText(FabricGuiUtil.getString("FabricOutOfBand_OK"));
            this.okButton.setActionCommand("OK");
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(FabricGuiUtil.getString("FabricOutOfBand_Cancel"));
            this.cancelButton.setName("Cancel");
            this.cancelButton.setActionCommand("CANCEL");
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    private JPanel getJGeneralInfoPanel() {
        if (this.jGeneralInfoPanel == null) {
            this.jGeneralInfoPanel = new JPanel();
            this.jGeneralInfoPanel.setLayout(new BoxLayout(this.jGeneralInfoPanel, 1));
            this.jGeneralInfoPanel.add((Component)this.getJGeneralInfoLabelPanel(), null);
            this.jGeneralInfoPanel.add((Component)this.getJGeneralInfoControlPanel(), null);
        }
        return this.jGeneralInfoPanel;
    }

    private JPanel getJGeneralInfoLabelPanel() {
        if (this.jGeneralInfoLabelPanel == null) {
            this.jGeneralInfoLabel = new JLabel();
            FlowLayout flowLayout = new FlowLayout();
            this.jGeneralInfoLabelPanel = new JPanel();
            this.jGeneralInfoLabelPanel.setLayout(flowLayout);
            this.jGeneralInfoLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_GeneralInfo"));
            this.jGeneralInfoLabel.setHorizontalAlignment(10);
            flowLayout.setAlignment(0);
            this.jGeneralInfoLabelPanel.add((Component)this.jGeneralInfoLabel, null);
        }
        return this.jGeneralInfoLabelPanel;
    }

    private void updateDisplayMode() {
        if (this.displayMode == 1) {
            this.jIPAddressLabel.setVisible(true);
            this.jStatus.setVisible(true);
            this.jIPAddress.setVisible(true);
            this.jStatusLabel.setVisible(true);
            this.okButton.setVisible(false);
            this.okButton.setEnabled(false);
            this.cancelButton.setVisible(false);
            this.cancelButton.setEnabled(false);
        } else {
            this.jHostTextField.setEditable(true);
            this.jSNMPCommunityTextField.setEditable(true);
        }
    }

    private JPanel getJGeneralInfoControlPanel() {
        if (this.jGeneralInfoControlPanel == null) {
            this.jIPAddressLabel = new JLabel();
            this.jStatusLabel = new JLabel();
            this.jSNMPCommunityLabel = new JLabel();
            this.jHostLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            this.jGeneralInfoControlPanel = new JPanel();
            this.jGeneralInfoControlPanel.setLayout(new GridBagLayout());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 20, 0, 10);
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.gridy = 3;
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.insets = new Insets(0, 0, 0, 10);
            this.jStatusLabel.setVisible(false);
            this.jIPAddressLabel.setVisible(false);
            this.jIPAddressLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_IPAddressLabel"));
            this.jGeneralInfoControlPanel.add((Component)this.jIPAddressLabel, gridBagConstraints10);
            this.jHostLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_HostLabel"));
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 40);
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(0, 0, 0, 40);
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.gridy = 3;
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 3;
            gridBagConstraints8.insets = new Insets(0, 20, 0, 10);
            gridBagConstraints9.anchor = 13;
            gridBagConstraints9.insets = new Insets(0, 20, 0, 10);
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints4.anchor = 10;
            this.jGeneralInfoControlPanel.add((Component)this.jHostLabel, gridBagConstraints);
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.insets = new Insets(0, 20, 0, 10);
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 40);
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 4;
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 10);
            this.jStatusLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_StatusLabel"));
            this.jGeneralInfoControlPanel.add((Component)this.jStatusLabel, gridBagConstraints11);
            this.jSNMPCommunityLabel.setText(FabricGuiUtil.getString("FabricOutOfBand_SNMPCommunityLabel"));
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.gridy = 4;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 40);
            this.jGeneralInfoControlPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
            this.jGeneralInfoControlPanel.add((Component)this.getJIPAddress(), gridBagConstraints7);
            this.jGeneralInfoControlPanel.add((Component)this.getJSNMPCommunityTextField(), gridBagConstraints4);
            this.jGeneralInfoControlPanel.add((Component)this.getJHostTextField(), gridBagConstraints2);
            this.jGeneralInfoControlPanel.add((Component)this.jSNMPCommunityLabel, gridBagConstraints3);
            this.jGeneralInfoControlPanel.add((Component)this.getJStatus(), gridBagConstraints6);
            this.updateDisplayMode();
        }
        return this.jGeneralInfoControlPanel;
    }

    private JTextField getJHostTextField() {
        if (this.jHostTextField == null) {
            this.jHostTextField = new JTextField();
            this.jHostTextField.setToolTipText(FabricGuiUtil.getString("FabricOutOfBand_HostnameTip"));
            this.jHostTextField.setEditable(false);
        }
        return this.jHostTextField;
    }

    private JTextField getJSNMPCommunityTextField() {
        if (this.jSNMPCommunityTextField == null) {
            this.jSNMPCommunityTextField = new JTextField();
            this.jSNMPCommunityTextField.setToolTipText(FabricGuiUtil.getString("FabricOutOfBand_SNMPCommunityTip"));
            this.jSNMPCommunityTextField.setEditable(false);
            this.jSNMPCommunityTextField.setText(OOBFA_SNMP_COMMUNITY);
        }
        return this.jSNMPCommunityTextField;
    }

    private static void addSorted(BaseTreeNode baseTreeNode, BaseTreeNode baseTreeNode2) {
        String string = baseTreeNode2.getUserObject().toString();
        int n = 0;
        int n2 = 1;
        if (baseTreeNode == null || !baseTreeNode.getAllowsChildren()) {
            return;
        }
        int n3 = baseTreeNode.getChildCount();
        while (n < n3) {
            BaseTreeNode baseTreeNode3 = (BaseTreeNode)baseTreeNode.getChildAt(n);
            n2 = string.compareTo(baseTreeNode3.getUserObject().toString());
            if (n2 <= 0) break;
            ++n;
        }
        if (n2 != 0) {
            BaseTree.MyTree.insertNodeInto(baseTreeNode2, baseTreeNode, n);
        }
    }

    public void updateData(String string, String string2, OutOfBandFabricAgentDDI outOfBandFabricAgentDDI) {
        this.node_name = string;
        this.node_ip = string2;
        this.node_ddi = outOfBandFabricAgentDDI;
        this.stateChanged();
    }

    private void stateChanged() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
        request.userName = GuiUtil.getUserName();
        OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = new OutOfBandFabricAgentInfo();
        request.requestData = outOfBandFabricAgentInfo;
        request.flags = (byte)4;
        outOfBandFabricAgentInfo.request_type = 1;
        outOfBandFabricAgentInfo.hostname = this.node_name;
        outOfBandFabricAgentInfo.ipaddress = this.node_ip;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        this.enableOkAndCancelButtons(true);
        if (s <= 4) {
            OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = (OutOfBandFabricAgentInfo)response.responseData;
            switch (outOfBandFabricAgentInfo.request_type) {
                case 5: {
                    if (outOfBandFabricAgentInfo.message_status == 4) {
                        String string = Util.getString("FMSG_OutOfBand_PaswordUsernameInvalid");
                        String string2 = MessageLog.getMessageNoID("ADG0525L");
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), string, string2, 0);
                        break;
                    }
                    if (outOfBandFabricAgentInfo.message_status == 5) {
                        String string = Util.getString("FMSG_OutOfBand_NotABrocadeAgent");
                        String string3 = MessageLog.getMessageNoID("ADG0526L");
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), string, string3, 0);
                        break;
                    }
                    if (outOfBandFabricAgentInfo.message_status == 2 || outOfBandFabricAgentInfo.message_status == 3) {
                        this.oobInitialValues = null;
                        if (this.displayMode != 1) break;
                        this.stateChanged();
                        break;
                    }
                    String string = Util.getString("FMSG_OutOfBand_UnexpectedResponse", String.valueOf(outOfBandFabricAgentInfo.message_status));
                    String string4 = MessageLog.getMessageNoID("ADG0527L");
                    JOptionPane.showMessageDialog(this.guiMain.getFrame(), string, string4, 0);
                    break;
                }
                case 2: {
                    if (outOfBandFabricAgentInfo.message_status == 4) {
                        String string = Util.getString("FMSG_OutOfBand_PaswordUsernameInvalid");
                        String string5 = MessageLog.getMessageNoID("ADG0525L");
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), string, string5, 0);
                        break;
                    }
                    if (outOfBandFabricAgentInfo.message_status == 5) {
                        String string = Util.getString("FMSG_OutOfBand_NotABrocadeAgent");
                        String string6 = MessageLog.getMessageNoID("ADG0526L");
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), string, string6, 0);
                        break;
                    }
                    if (outOfBandFabricAgentInfo.message_status == 2 || outOfBandFabricAgentInfo.message_status == 3) {
                        byte by = 0;
                        if (outOfBandFabricAgentInfo.message_status == 2) {
                            by = 1;
                        }
                        OutOfBandFabricAgentTreeNode outOfBandFabricAgentTreeNode = new OutOfBandFabricAgentTreeNode((Object)outOfBandFabricAgentInfo.hostname, outOfBandFabricAgentInfo.ipaddress, by);
                        this.oobResponse = outOfBandFabricAgentInfo;
                        if (this.displayMode == 2) {
                            OutOfBandAgentPanel.addSorted(this.parentNode, outOfBandFabricAgentTreeNode);
                        }
                        this.oobInitialValues = null;
                        ActionEvent actionEvent = new ActionEvent(this, 0, "OK");
                        this.fireAction(actionEvent);
                        break;
                    }
                    String string = Util.getString("FMSG_OutOfBand_UnexpectedResponse", String.valueOf(outOfBandFabricAgentInfo.message_status));
                    String string7 = MessageLog.getMessageNoID("ADG0527L");
                    JOptionPane.showMessageDialog(this.guiMain.getFrame(), string, string7, 0);
                    break;
                }
                case 1: {
                    if (this.node_ddi != null) {
                        this.node_ddi.setNodeIconBasedOnStatusFromServer(outOfBandFabricAgentInfo.status);
                    }
                    this.oobInitialValues = outOfBandFabricAgentInfo;
                    this.setStatusStringBasedOnStatusFromServer(outOfBandFabricAgentInfo.status);
                    this.getJIPAddress().setText(outOfBandFabricAgentInfo.ipaddress);
                    this.getJHostTextField().setText(outOfBandFabricAgentInfo.hostname);
                    this.getJSNMPCommunityTextField().setText(outOfBandFabricAgentInfo.communityname);
                    this.jSNMPCommunityTextField.setEditable(true);
                    if (outOfBandFabricAgentInfo.username != null) break;
                    outOfBandFabricAgentInfo.username = "";
                }
            }
        }
    }

    private void setStatusStringBasedOnStatusFromServer(int n) {
        switch (n) {
            case 2: {
                this.getJStatus().setText((String)FabricGuiUtil.getStatusString(0));
                break;
            }
            default: {
                this.getJStatus().setText((String)FabricGuiUtil.getStatusString(-1));
            }
        }
    }

    private JPanel getJEastSpacer() {
        if (this.jEastSpacer == null) {
            this.jEastSpacer = new JPanel();
            this.jEastSpacer.setPreferredSize(new Dimension(30, 10));
        }
        return this.jEastSpacer;
    }

    private JPanel getJWestSpacer() {
        if (this.jWestSpacer == null) {
            this.jWestSpacer = new JPanel();
            this.jWestSpacer.setPreferredSize(new Dimension(30, 10));
        }
        return this.jWestSpacer;
    }

    private JPanel getJNorthSpacer() {
        if (this.jNorthSpacer == null) {
            this.jNorthSpacer = new JPanel();
        }
        return this.jNorthSpacer;
    }

    public BaseTreeNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(BaseTreeNode baseTreeNode) {
        this.parentNode = baseTreeNode;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int n) {
        this.displayMode = n;
    }

    private JTextField getJStatus() {
        if (this.jStatus == null) {
            this.jStatus = new JTextField();
            this.jStatus.setVisible(false);
            this.jStatus.setEditable(false);
        }
        return this.jStatus;
    }

    private JTextField getJIPAddress() {
        if (this.jIPAddress == null) {
            this.jIPAddress = new JTextField();
            this.jIPAddress.setVisible(false);
            this.jIPAddress.setEditable(false);
        }
        return this.jIPAddress;
    }

    public boolean changesPending() {
        return this.oobInitialValues != null && !this.getJSNMPCommunityTextField().getText().equals(this.oobInitialValues.communityname);
    }

    public void saveAndClose() {
        this.savePanelChanges();
    }
}

