/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.admin.GenericServiceTreeNode;
import org.eclipse.aperi.gui.admin.LogConfigDialog;
import org.eclipse.aperi.gui.admin.ServerData;
import org.eclipse.aperi.gui.admin.ServiceData;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class ServicesTreeNode
extends GenericServiceTreeNode
implements GuiRequestor,
ActionListener {
    protected int pendingRequests;
    protected int processedRequests;
    protected int threadsWaiting;
    public JPopupMenu popup = null;
    private LogConfigDialog lConfigDialog = null;
    private String actionCommand;
    private static String LOG = MessageLog.getMessageNoID("ADG0017L");
    private static String TRACING = MessageLog.getMessageNoID("ADG0304L");
    private static String AUDITLOG = MessageLog.getMessageNoID("ADG0326L");
    private static String BROADCAST = MessageLog.getMessageNoID("ADG0117L");
    private static String START = MessageLog.getMessageNoID("ADG0005L");
    private static String SHUTDOWN = MessageLog.getMessageNoID("ADG0006L");
    private static String NORMAL = MessageLog.getMessageNoID("ADG0007L");
    private static String IMMEDIATE = MessageLog.getMessageNoID("ADG0009L");
    private static String ABORT = MessageLog.getMessageNoID("ADG0011L");
    private static String STOP_TITLE = MessageLog.getMessageNoID("ADG0103T");
    private static String STOP_WARNING = MessageLog.getMessageNoID("ADG0104T");
    private static String STOP_NO = MessageLog.getMessageNoID("ADG0105L");
    private static String STOP_YES = MessageLog.getMessageNoID("ADG0106L");
    private static String NOT_CONNECTED = MessageLog.getMessageNoID("ADG0015T");

    public ServicesTreeNode(Object object, String string, byte by, int n, int n2, int n3) {
        super(object, string, string, by);
        this.setAllowsChildren(false);
        this.pendingRequests = n;
        this.processedRequests = n2;
        this.threadsWaiting = n3;
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.popup;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        boolean bl = true;
        if (mouseEvent == null) {
            bl = false;
        }
        this.popup = this.getPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(LOG);
        JMenuItem jMenuItem2 = new JMenuItem(TRACING);
        JMenuItem jMenuItem3 = new JMenuItem(AUDITLOG);
        JMenuItem jMenuItem4 = new JMenuItem(BROADCAST);
        JMenuItem jMenuItem5 = new JMenuItem(START);
        JMenu jMenu = new JMenu(SHUTDOWN);
        JMenuItem jMenuItem6 = new JMenuItem(NORMAL);
        JMenuItem jMenuItem7 = new JMenuItem(IMMEDIATE);
        JMenuItem jMenuItem8 = new JMenuItem(ABORT);
        this.popup.add(jMenuItem);
        jMenuItem.setActionCommand(LOG);
        jMenuItem.addActionListener(this);
        jMenuItem.setName(LOG);
        jMenuItem2.setName(TRACING);
        jMenuItem3.setName(AUDITLOG);
        jMenu.setName(SHUTDOWN);
        jMenuItem5.setName(START);
        jMenuItem4.setName(BROADCAST);
        jMenuItem6.setName(NORMAL);
        jMenuItem7.setName(IMMEDIATE);
        jMenuItem8.setName(ABORT);
        if (this.isRepresentingTheServerService()) {
            jMenuItem.setToolTipText(MessageLog.getMessageNoID("ADG0129T"));
            if (this.getState() != 2) {
                jMenuItem2.setToolTipText(MessageLog.getMessageNoID("ADG0306T"));
                jMenuItem2.setActionCommand(TRACING);
                jMenuItem2.addActionListener(this);
                jMenuItem2.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                jMenuItem4.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(jMenuItem2);
            }
            if (this.getState() != 2) {
                jMenuItem3.setToolTipText(MessageLog.getMessageNoID("ADG0328L"));
                jMenuItem3.setActionCommand(AUDITLOG);
                jMenuItem3.addActionListener(this);
                jMenuItem3.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                jMenuItem4.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(jMenuItem3);
            }
            jMenuItem4.setToolTipText(MessageLog.getMessageNoID("ADG0118T"));
            jMenuItem4.setActionCommand(BROADCAST);
            jMenuItem4.addActionListener(this);
            jMenuItem4.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
            this.popup.add(jMenuItem4);
        } else {
            jMenuItem.setToolTipText(MessageLog.getMessageNoID("ADG0130T"));
        }
        if (this.getState() != 2) {
            if (this.getRequestType().equals("org.eclipse.aperi.server.svp.SchedulerSvp")) {
                jMenuItem2.setToolTipText(MessageLog.getMessageNoID("ADG0317T"));
                jMenuItem2.setActionCommand(TRACING);
                jMenuItem2.addActionListener(this);
                jMenuItem2.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(jMenuItem2);
            }
            if (this.getRequestType().equals("org.eclipse.aperi.server.svp.AgentSvp")) {
                jMenuItem2.setToolTipText(MessageLog.getMessageNoID("ADG0318T"));
                jMenuItem2.setActionCommand(TRACING);
                jMenuItem2.addActionListener(this);
                jMenuItem2.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(jMenuItem2);
            }
            if (this.getRequestType().equals("org.eclipse.aperi.server.svp.GuiSvp")) {
                jMenuItem2.setToolTipText(MessageLog.getMessageNoID("ADG0319T"));
                jMenuItem2.setActionCommand(TRACING);
                jMenuItem2.addActionListener(this);
                jMenuItem2.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(jMenuItem2);
            }
            if (this.getRequestType().equals("org.eclipse.aperi.server.svp.CimomSvp")) {
                jMenuItem2.setToolTipText(MessageLog.getMessageNoID("ADG0320T"));
                jMenuItem2.setActionCommand(TRACING);
                jMenuItem2.addActionListener(this);
                jMenuItem2.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(jMenuItem2);
            }
            jMenu.setToolTipText(MessageLog.getMessageNoID("ADG0102T"));
            jMenu.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
            this.popup.add(jMenu);
            jMenuItem6.setToolTipText(MessageLog.getMessageNoID("ADG0008T"));
            jMenuItem6.setActionCommand(NORMAL);
            jMenuItem6.addActionListener(this);
            jMenu.add(jMenuItem6);
            jMenuItem7.setToolTipText(MessageLog.getMessageNoID("ADG0010T"));
            jMenuItem7.setActionCommand(IMMEDIATE);
            jMenuItem7.addActionListener(this);
            jMenu.add(jMenuItem7);
            jMenuItem8.setToolTipText(MessageLog.getMessageNoID("ADG0012T"));
            jMenuItem8.setActionCommand(ABORT);
            jMenuItem8.addActionListener(this);
            jMenu.add(jMenuItem8);
        } else {
            jMenuItem5.setToolTipText(MessageLog.getMessageNoID("ADG0101T"));
            jMenuItem5.setActionCommand(START);
            jMenuItem5.addActionListener(this);
            jMenuItem5.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
            this.popup.add(jMenuItem5);
        }
        if (bl) {
            this.showPopupMenu(this.popup, mouseEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.actionCommand = actionEvent.getActionCommand();
        if (this.actionCommand == START) {
            this.stateChange((byte)4);
        } else if (this.actionCommand == NORMAL) {
            this.stateChange((byte)1);
        } else if (this.actionCommand == IMMEDIATE) {
            this.stateChange((byte)2);
        } else if (this.actionCommand == ABORT) {
            this.stateChange((byte)3);
        } else if (this.actionCommand == BROADCAST) {
            Request request = new Request();
            ServerRequest.broadcast(request);
            GuiClient.doRequest(this, request);
        } else if (this.actionCommand == LOG) {
            new LogViewer(this, this.getRequestType());
        } else if (this.actionCommand == TRACING) {
            this.tracingConfig();
        } else if (this.actionCommand == AUDITLOG) {
            this.auditConfig();
        }
    }

    private void tracingConfig() {
        Request request = new Request();
        ServerRequest.serverGetTracingConfig(request, this.getRequestType());
        GuiClient.doRequest(this, request);
    }

    private void auditConfig() {
        Request request = new Request();
        ServerRequest.serverGetAuditConfig(request, this.getRequestType());
        GuiClient.doRequest(this, request);
    }

    private void stateChange(byte by) {
        Object[] objectArray = new String[]{STOP_NO, STOP_YES};
        if (this.isRepresentingTheServerService()) {
            IGuiMain iGuiMain;
            int n = JOptionPane.showOptionDialog(guiMain.getFrame(), STOP_WARNING, STOP_TITLE, 0, 2, null, objectArray, objectArray[0]);
            if (n == 1 && (iGuiMain = GuiManager.getGuiManager().getGuiMain()).disconnectFromServer()) {
                Request request = new Request();
                ServerRequest.stateChange(request, by, this.getRequestType());
                GuiClient.doRequest(this, request);
            }
        } else {
            this.doStateChange(by, this.getRequestType());
            this.setState(this.getState() == 2 ? (byte)1 : 2);
            BaseTree.MyTree.nodeChanged(this);
        }
    }

    private void doStateChange(byte by, String string) {
        Request request = new Request();
        ServerRequest.stateChange(request, by, string);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (this.actionCommand == TRACING || this.actionCommand == AUDITLOG) {
            if (s != 0) {
                String string = MessageLog.getMessage("ADG0315E");
                JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0307L"), 0);
            } else {
                HashMap hashMap = (HashMap)response.responseData;
                String string = (String)this.getUserObject();
                this.lConfigDialog = null;
                if (this.lConfigDialog == null) {
                    String string2 = null;
                    if (string.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.ServerSvp"))) {
                        string2 = MessageLog.getMessageNoID("ADG0314L");
                    } else if (string.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.SchedulerSvp"))) {
                        string2 = MessageLog.getMessageNoID("ADG0321L");
                    } else if (string.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.AgentSvp"))) {
                        string2 = MessageLog.getMessageNoID("ADG0322L");
                    } else if (string.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.GuiSvp"))) {
                        string2 = MessageLog.getMessageNoID("ADG0323L");
                    } else if (string.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.CimomSvp"))) {
                        string2 = MessageLog.getMessageNoID("ADG0324L");
                    }
                    if (this.actionCommand == AUDITLOG) {
                        string2 = MessageLog.getMessageNoID("ADG0327L");
                        this.lConfigDialog = new LogConfigDialog(string2, this.getRequestType(), true);
                    } else {
                        this.lConfigDialog = new LogConfigDialog(string2, this.getRequestType());
                    }
                }
                this.lConfigDialog.setLocationRelativeTo(null);
                this.lConfigDialog.show(hashMap, this.getRequestType());
            }
        }
    }

    public boolean isRepresentingTheServerService() {
        return this.getRequestType().equals("org.eclipse.aperi.server.svp.ServerSvp");
    }

    public JPanel getPanel() {
        if (this.isRepresentingTheServerService()) {
            return new ServerData(this);
        }
        return new ServiceData(this);
    }
}

