/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIFabric;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIZone;
import org.eclipse.aperi.gui.disk.common.model.GUIZoneSet;
import org.eclipse.aperi.gui.fabric.zone.ZoneUIAccessor;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;

public abstract class BaseZoneActionStep
extends WizardPage
implements ActionListener {
    private DiskDataAccessor diskAccessor = null;
    private ZoneUIAccessor zoneAccessor = ZoneUIAccessor.getInstance();
    private ZoneCapabilities zoneCap = null;
    private GUIFabric fab = null;
    private BaseZoneActionStep zoneStep = this;
    private boolean zoneError = false;
    private int totalFabrics = -1;
    private int fabricSize = -1;
    private int currentFabric = -1;
    private ZoneAction zoneAction = null;
    private int zoneActionDisplay = -1;
    private String fabricID = new String();
    private String zonesetID = new String();
    private GUIZoneSet zoneset = null;
    protected HashMap fabricsMap = null;
    private HashMap zoneMap = null;
    private HashMap zoneNameMap = null;
    private String[] portsInZone;
    protected HashMap zoneSteps = null;
    protected HashMap zoneList = null;
    private Vector fabrics = new Vector();
    private Vector existingZones = null;
    private Vector hostportData = null;
    private Vector ssportData = null;
    private Vector hostportsVector = null;
    private Vector ssportsVector = null;
    private Vector hostportsVectorString = null;
    private Vector ssportsVectorString = null;
    private Vector excludedHostports = new Vector();
    private Vector excludedSSports = new Vector();
    private Container zonePane = null;
    private Container pane = null;
    private JPanel zoneNoPorts = null;
    private JPanel zoneCommonPorts = null;
    private JPanel actionPanel = null;
    private JPanel noFabricPanel = null;
    private JPanel fabricPanel = null;
    private GridBagPanel tempPanel = null;
    private JButton nextButton = null;
    private JLabel titleLabel = null;
    private JTextArea titleLabel2 = null;
    private JTextArea titleLabel3 = null;
    private JLabel zoneActionLabel = null;
    private JLabel titleLabelNoZoneAction = null;
    private JLabel newZoneLabel = null;
    private JLabel zoneNameLabel = null;
    private JLabel updateZoneLabel = null;
    private JLabel dontDoLabel = null;
    private JLabel portListLabel = null;
    private JLabel ssportListLabel = null;
    private JLabel zoneSetLabel = null;
    private JLabel noZoneLabel = null;
    private JLabel noFabricLabel = null;
    private JTextArea commonZoneLabel = null;
    private JDialog wizardDialog = null;
    private JRadioButton newZoneRadioButton = null;
    private JRadioButton updateZoneRadioButton = null;
    private JRadioButton dontDoRadioButton = null;
    private JTextField zoneNameTextField = null;
    private JComboBox zoneExistComboBox = null;
    private JList portList = null;
    private JList ssportList = null;
    private JScrollPane jportPanel = null;
    private JScrollPane ssjportPanel = null;
    public static String ZONE_ACTION_DATA = "Zone Actions";
    public static String ZONE_LIST_DATA = "Zone List";
    private String subSystemID = null;
    private int width = -1;
    private int height = -1;
    protected boolean skipStep = false;
    private boolean getData = true;
    protected boolean isHelpSet = false;
    private boolean getRefreshData = false;

    public BaseZoneActionStep(int n, String string) {
        super(n);
        this.setName(this.getClass().getName());
        this.diskAccessor = DiskDataAccessor.getInstance();
        this.subSystemID = string;
        this.getFinishButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        this.pane = this.getContentPane();
        this.pane.add(this.create());
    }

    public JPanel create() {
        this.zoneSteps = new HashMap();
        this.zoneList = new HashMap();
        this.tempPanel = new GridBagPanel();
        this.fabricPanel = new JPanel();
        this.fabricPanel.setLayout(new BoxLayout(this.fabricPanel, 1));
        this.tempPanel.add((JComponent)this.fabricPanel, 23);
        this.tempPanel.newRow();
        this.noFabricPanel = new JPanel();
        this.noFabricPanel.setLayout(new BoxLayout(this.noFabricPanel, 3));
        this.noFabricLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_NO_FABRICS_LABEL"));
        this.noFabricLabel.setBorder(BorderFactory.createEmptyBorder(40, 20, 10, 5));
        Font font = this.noFabricLabel.getFont();
        GuiUtil.setAccessible(this.noFabricLabel, this.noFabricLabel.getText(), this.noFabricLabel.getText());
        this.noFabricLabel.setFont(font.deriveFont(1));
        this.noFabricPanel.add(this.noFabricLabel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.titleLabel = new JLabel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(this.titleLabel);
        jPanel.add(Box.createHorizontalGlue());
        font = this.titleLabel.getFont();
        this.titleLabel.setAlignmentX(0.0f);
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        this.zoneNoPorts = new JPanel();
        this.zoneNoPorts.setLayout(new BoxLayout(this.zoneNoPorts, 0));
        GridBagPanel gridBagPanel = new GridBagPanel();
        JTextArea jTextArea = new JTextArea(GuiUtil.getString("DISK_VOLUME_ZONE_ACTION_NO_ZONE_LABEL_LINE1"));
        jTextArea.setBorder(null);
        jTextArea.setFont(font.deriveFont(0));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(GuiUtil.wrapAtWords());
        jTextArea.setBackground(gridBagPanel.getBackground());
        JTextArea jTextArea2 = new JTextArea(GuiUtil.getString("DISK_VOLUME_ZONE_ACTION_NO_ZONE_LABEL_LINE2"));
        jTextArea2.setBorder(null);
        jTextArea2.setFont(font.deriveFont(0));
        jTextArea2.setEditable(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(GuiUtil.wrapAtWords());
        jTextArea2.setBackground(gridBagPanel.getBackground());
        jTextArea2.setPreferredSize(new Dimension(480, 30));
        jTextArea2.setFont(font.deriveFont(0, font.getSize()));
        JTextArea jTextArea3 = new JTextArea(GuiUtil.getString("DISK_VOLUME_ZONE_ACTION_NO_ZONE_LABEL_LINE3"));
        jTextArea3.setBorder(null);
        jTextArea3.setFont(font.deriveFont(0));
        jTextArea3.setEditable(false);
        jTextArea3.setLineWrap(true);
        jTextArea3.setWrapStyleWord(GuiUtil.wrapAtWords());
        jTextArea3.setBackground(gridBagPanel.getBackground());
        jTextArea3.setPreferredSize(new Dimension(480, 30));
        jTextArea3.setFont(font.deriveFont(0, font.getSize()));
        JTextArea jTextArea4 = new JTextArea(GuiUtil.getString("DISK_VOLUME_ZONE_ACTION_NO_ZONE_LABEL_LINE4"));
        jTextArea4.setBorder(null);
        jTextArea4.setFont(font.deriveFont(0));
        jTextArea4.setEditable(false);
        jTextArea4.setLineWrap(true);
        jTextArea4.setWrapStyleWord(GuiUtil.wrapAtWords());
        jTextArea4.setBackground(gridBagPanel.getBackground());
        jTextArea4.setPreferredSize(new Dimension(480, 30));
        jTextArea4.setFont(font.deriveFont(0, font.getSize()));
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jTextArea, 0, 1, 2);
        gridBagPanel.newRow();
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        gridBagPanel2.add((JComponent)jTextArea2, 0);
        gridBagPanel2.newRow();
        gridBagPanel2.add((JComponent)jTextArea3, 0);
        gridBagPanel2.newRow();
        gridBagPanel2.add((JComponent)jTextArea4, 0);
        gridBagPanel2.newRow();
        gridBagPanel.add(gridBagPanel2);
        gridBagPanel.newRow();
        JTextArea jTextArea5 = new JTextArea(GuiUtil.getString("DISK_VOLUME_ZONE_ACTION_NO_ZONE_LABEL_LINE5"));
        jTextArea5.setBorder(null);
        jTextArea5.setFont(font.deriveFont(0));
        jTextArea5.setEditable(false);
        jTextArea5.setLineWrap(true);
        jTextArea5.setWrapStyleWord(GuiUtil.wrapAtWords());
        jTextArea5.setBackground(gridBagPanel.getBackground());
        jTextArea5.setPreferredSize(new Dimension(480, 60));
        jTextArea5.setFont(font.deriveFont(0, font.getSize()));
        gridBagPanel.add(jTextArea5);
        this.zoneNoPorts.add(gridBagPanel);
        this.zoneCommonPorts = new JPanel();
        this.zoneCommonPorts.setLayout(new BoxLayout(this.zoneCommonPorts, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.commonZoneLabel = new JTextArea(Util.getString("DISK_VOLUME_ZONE_ACTION_COMMON_ZONE_LABEL"));
        this.commonZoneLabel.setEditable(false);
        this.commonZoneLabel.setLineWrap(true);
        this.commonZoneLabel.setWrapStyleWord(true);
        this.commonZoneLabel.setBackground((Color)UIManager.get("Label.background"));
        this.commonZoneLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.commonZoneLabel.setFont((Font)UIManager.get("Label.font"));
        this.commonZoneLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.commonZoneLabel.setAlignmentX(0.0f);
        jPanel2.add(this.titleLabel);
        jPanel2.add(this.commonZoneLabel);
        this.zoneCommonPorts.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.titleLabel3 = new JTextArea(Util.getString("DISK_VOLUME_ZONE_ACTION_TITLE3_LABEL"));
        this.titleLabel3.setEditable(false);
        this.titleLabel3.setLineWrap(true);
        this.titleLabel3.setWrapStyleWord(true);
        this.titleLabel3.setBackground((Color)UIManager.get("Label.background"));
        this.titleLabel3.setForeground((Color)UIManager.get("Label.foreground"));
        this.titleLabel3.setFont((Font)UIManager.get("Label.font"));
        this.titleLabel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.titleLabel3.setAlignmentX(0.0f);
        jPanel3.add(jPanel);
        jPanel3.add(this.titleLabel3);
        this.fabricPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        String string = new String();
        this.zoneSetLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", string));
        this.zoneSetLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.zoneSetLabel.setAlignmentX(0.0f);
        jPanel4.add(this.zoneSetLabel);
        this.width = Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL").length() * this.zoneSetLabel.getFontMetrics(this.getFont()).charWidth(0) + 20;
        this.height = this.zoneSetLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.zoneSetLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.zoneSetLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.zoneSetLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel4.add(Box.createHorizontalGlue());
        this.fabricPanel.add(jPanel4);
        this.zonePane = new JPanel();
        this.zonePane.setLayout(new BoxLayout(this.zonePane, 3));
        this.actionPanel = new JPanel();
        this.actionPanel.setLayout(new BoxLayout(this.actionPanel, 1));
        this.actionPanel.setBorder(BorderFactory.createTitledBorder(Util.getString("DISK_VOLUME_ZONE_ACTION_ACTION_LABEL")));
        this.zonePane.add(this.actionPanel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.newZoneRadioButton = new JRadioButton(Util.getString("DISK_VOLUME_ZONE_ACTION_NEW_ZONE_LABEL"));
        jPanel5.add(this.newZoneRadioButton);
        this.newZoneRadioButton.addActionListener(this);
        this.newZoneRadioButton.setAlignmentX(1.0f);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel5.add(Box.createHorizontalGlue());
        GuiUtil.setAccessible(this.newZoneRadioButton, this.newZoneRadioButton.getText(), this.newZoneRadioButton.getText());
        this.actionPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        this.zoneNameLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_NAME_LABEL"));
        this.zoneNameTextField = new JTextField();
        jPanel6.add(Box.createRigidArea(new Dimension(50, 0)));
        jPanel6.add(this.zoneNameLabel);
        PlainDocument plainDocument = new PlainDocument(){

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string != null && string.length() + this.getLength() <= 15) {
                    super.insertString(n, string, attributeSet);
                }
            }
        };
        this.zoneNameTextField = new JTextField(plainDocument, "", 15);
        this.width = 16 * this.zoneNameTextField.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.zoneNameTextField.getFontMetrics(this.getFont()).getHeight() + 5;
        this.zoneNameTextField.setMinimumSize(new Dimension(this.width, this.height));
        this.zoneNameTextField.setPreferredSize(new Dimension(this.width, this.height));
        this.zoneNameTextField.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel6.add(this.zoneNameTextField);
        jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel6.setAlignmentX(1.0f);
        jPanel6.add(Box.createHorizontalGlue());
        this.actionPanel.add(jPanel6);
        GuiUtil.setAccessibleLabel(this.zoneNameLabel, this.zoneNameTextField, "", this.zoneNameLabel.getText(), this.zoneNameLabel.getText());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        this.updateZoneRadioButton = new JRadioButton(Util.getString("DISK_VOLUME_ZONE_ACTION_UPDATE_ZONE_LABEL"));
        this.updateZoneRadioButton.addActionListener(this);
        jPanel7.add(this.updateZoneRadioButton);
        Vector vector = new Vector();
        this.zoneExistComboBox = new JComboBox(vector);
        jPanel7.add(this.zoneExistComboBox);
        jPanel7.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel7.add(Box.createHorizontalGlue());
        GuiUtil.setAccessible(this.updateZoneRadioButton, this.updateZoneRadioButton.getText(), this.updateZoneRadioButton.getText());
        GuiUtil.setAccessible(this.zoneExistComboBox, this.zoneExistComboBox.getName(), this.zoneExistComboBox.getName());
        this.actionPanel.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        this.dontDoRadioButton = new JRadioButton(Util.getString("DISK_VOLUME_ZONE_ACTION_DONTDO_LABEL"));
        jPanel8.add(this.dontDoRadioButton);
        this.dontDoRadioButton.addActionListener(this);
        jPanel8.add(Box.createHorizontalGlue());
        this.dontDoRadioButton.setSelected(true);
        GuiUtil.setAccessible(this.dontDoRadioButton, this.dontDoRadioButton.getText(), this.dontDoRadioButton.getText());
        jPanel8.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.actionPanel.add(jPanel8);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.newZoneRadioButton);
        buttonGroup.add(this.updateZoneRadioButton);
        buttonGroup.add(this.dontDoRadioButton);
        this.zoneNameTextField.setEnabled(false);
        this.zoneExistComboBox.setEnabled(false);
        this.fabricPanel.add(Box.createVerticalGlue());
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 2));
        jPanel10.setLayout(new BoxLayout(jPanel10, 3));
        this.portListLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_HOST_PORTS_LABEL"));
        jPanel10.add(this.portListLabel);
        this.portList = new JList();
        this.jportPanel = new JScrollPane(this.portList);
        this.jportPanel.setPreferredSize(new Dimension(50, 80));
        jPanel10.add(this.jportPanel);
        GuiUtil.setAccessibleLabel(this.portListLabel, this.portList, "", this.portListLabel.getText(), this.portListLabel.getText());
        Vector vector2 = new Vector();
        this.portList.setListData(vector2);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 3));
        this.ssportListLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_SUBSYSTEM_PORTS_LABEL"));
        jPanel11.add(this.ssportListLabel);
        this.ssportList = new JList();
        this.ssjportPanel = new JScrollPane(this.ssportList);
        this.ssjportPanel.setPreferredSize(new Dimension(40, 80));
        jPanel11.add(this.ssjportPanel);
        GuiUtil.setAccessibleLabel(this.ssportListLabel, this.ssportList, "", this.ssportListLabel.getText(), this.ssportListLabel.getText());
        jPanel9.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel9.add(jPanel10);
        jPanel9.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel9.add(jPanel11);
        jPanel9.add(Box.createRigidArea(new Dimension(5, 0)));
        this.actionPanel.add(jPanel9);
        this.fabricPanel.add(this.zonePane);
        this.zoneAction = new ZoneAction();
        this.nextButton = this.getNextButton();
        this.tempPanel.add((JComponent)new JLabel(), 1);
        return this.tempPanel;
    }

    public void fillData() {
        block45: {
            block46: {
                block47: {
                    Serializable serializable;
                    if (this.getData) {
                        String string;
                        int n;
                        this.getData = false;
                        this.getFabricsFromSystem();
                        if (this.fabricsMap == null) {
                            this.getData = false;
                            this.tempPanel.remove(this.fabricPanel);
                            this.tempPanel.add((JComponent)this.noFabricPanel, 0, 1, 2);
                            return;
                        }
                        serializable = null;
                        Vector<String> vector = new Vector<String>(this.fabricsMap.keySet());
                        String string2 = new String();
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            string2 = (String)vector.get(n2);
                            serializable = (GUIFabric)this.fabricsMap.get(string2);
                            if (serializable.getActiveZoneSet() == null) {
                                this.fabricsMap.remove(string2);
                            }
                            if (!serializable.isZoningSupported()) {
                                this.fabricsMap.remove(string2);
                            }
                            ++n2;
                        }
                        this.hostportData = this.getHostPorts();
                        this.hostportData = GUIEntityUtil.sort(this.hostportData);
                        this.ssportData = this.getSubsystemPorts();
                        if (this.ssportData != null) {
                            this.ssportData = GUIEntityUtil.sort(this.ssportData);
                        }
                        Vector<GUIFabric> vector2 = new Vector<GUIFabric>();
                        Vector vector3 = new Vector();
                        GUIPort gUIPort = null;
                        GUIPort gUIPort2 = null;
                        int n3 = 0;
                        while (n3 < this.hostportData.size()) {
                            try {
                                gUIPort = (GUIPort)this.hostportData.get(n3);
                            }
                            catch (ClassCastException classCastException) {
                                gUIPort = null;
                            }
                            if (gUIPort != null) {
                                vector3 = gUIPort.getFabrics();
                            }
                            n = 0;
                            while (vector3 != null && n < vector3.size()) {
                                serializable = (GUIFabric)this.fabricsMap.get((String)vector3.get(n));
                                if (serializable != null && !vector2.contains(serializable)) {
                                    vector2.add((GUIFabric)serializable);
                                }
                                ++n;
                            }
                            ++n3;
                        }
                        Vector<GUIFabric> vector4 = new Vector<GUIFabric>();
                        n = 0;
                        while (this.ssportData != null && n < this.ssportData.size()) {
                            gUIPort2 = (GUIPort)this.ssportData.get(n);
                            vector3 = gUIPort2.getFabrics();
                            int n4 = 0;
                            while (vector3 != null && n4 < vector3.size()) {
                                serializable = (GUIFabric)this.fabricsMap.get((String)vector3.get(n4));
                                if (serializable != null && !vector4.contains(serializable)) {
                                    vector4.add((GUIFabric)serializable);
                                }
                                ++n4;
                            }
                            ++n;
                        }
                        this.fabrics = new Vector();
                        if (vector4.size() > vector2.size()) {
                            vector4.retainAll(vector2);
                            this.fabrics = vector4;
                        } else {
                            vector2.retainAll(vector4);
                            this.fabrics = vector2;
                        }
                        vector = new Vector();
                        n = 0;
                        while (n < this.fabrics.size()) {
                            vector.add(((GUIFabric)this.fabrics.get(n)).getId());
                            ++n;
                        }
                        n = 0;
                        this.excludedHostports = new Vector();
                        gUIPort2 = null;
                        int n5 = 0;
                        while (n5 < this.hostportData.size()) {
                            n = 0;
                            try {
                                gUIPort2 = (GUIPort)this.hostportData.get(n5);
                            }
                            catch (ClassCastException classCastException) {
                                gUIPort2 = null;
                            }
                            if (gUIPort2 != null) {
                                vector3 = gUIPort2.getFabrics();
                            }
                            int n6 = 0;
                            while (vector3 != null && n6 < vector3.size()) {
                                String string3 = (String)vector3.get(n6);
                                if (vector.contains(string3)) {
                                    n = 1;
                                    break;
                                }
                                ++n6;
                            }
                            if (gUIPort2 != null && n == 0) {
                                String string4 = gUIPort2.getWwpn();
                                string = gUIPort2.getHostName();
                                String string5 = gUIPort2.getTypeName();
                                string4 = gUIPort2.getWwpn();
                                string = gUIPort2.getHostName();
                                string5 = gUIPort2.getTypeName();
                                if (string != null && string.trim().length() > 0) {
                                    string4 = String.valueOf(string4) + "( " + string;
                                    if (string5 != null && string5.trim().length() > 0 && gUIPort2.getType() != 0) {
                                        string4 = String.valueOf(string4) + ", " + string5;
                                    }
                                    string4 = String.valueOf(string4) + " )";
                                }
                                this.excludedHostports.add(string4);
                            }
                            ++n5;
                        }
                        this.excludedSSports = new Vector();
                        gUIPort2 = null;
                        n5 = 0;
                        while (this.ssportData != null && n5 < this.ssportData.size()) {
                            n = 0;
                            gUIPort2 = (GUIPort)this.ssportData.get(n5);
                            vector3 = gUIPort2.getFabrics();
                            int n7 = 0;
                            while (vector3 != null && n7 < vector3.size()) {
                                String string6 = (String)vector3.get(n7);
                                if (vector.contains(string6)) {
                                    n = 1;
                                    break;
                                }
                                ++n7;
                            }
                            if (gUIPort2 != null && n == 0) {
                                String string7 = gUIPort2.getWwpn();
                                string = gUIPort2.getHostName();
                                if (string != null && string.trim().length() > 0) {
                                    string7 = String.valueOf(string7) + " (" + string + ")";
                                }
                                this.excludedSSports.add(string7);
                            }
                            ++n5;
                        }
                        this.totalFabrics = this.fabrics.size();
                        if (this.totalFabrics > 0) {
                            this.currentFabric = 0;
                            GUIFabric gUIFabric = (GUIFabric)this.fabrics.get(this.currentFabric);
                            String string8 = Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC_LABEL", gUIFabric.getDeviceId(), Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC2_LABEL", String.valueOf(this.currentFabric + 1), String.valueOf(this.totalFabrics)));
                            this.titleLabel.setText(string8);
                            this.getFabricsInfo(gUIFabric);
                            this.zoneSetLabel.setText(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", gUIFabric.getActiveZoneSet().getDeviceId()));
                            switch (this.zoneActionDisplay) {
                                case -1: {
                                    this.tempPanel.remove(this.zoneNoPorts);
                                    this.tempPanel.remove(this.zoneCommonPorts);
                                    this.tempPanel.add((JComponent)this.fabricPanel, 23);
                                    break;
                                }
                                case 0: {
                                    this.tempPanel.remove(this.zoneCommonPorts);
                                    this.tempPanel.remove(this.fabricPanel);
                                    this.tempPanel.add((JComponent)this.zoneNoPorts, 0, 1, 2);
                                    break;
                                }
                                case 1: {
                                    this.tempPanel.remove(this.fabricPanel);
                                    this.tempPanel.remove(this.zoneNoPorts);
                                    this.tempPanel.add((JComponent)this.zoneCommonPorts, 0, 1, 2);
                                }
                            }
                            this.zoneNameTextField.setText("");
                            this.dontDoRadioButton.setSelected(true);
                            this.zoneExistComboBox.setEnabled(false);
                            this.zoneNameTextField.setEnabled(false);
                        } else {
                            this.tempPanel.remove(this.zoneCommonPorts);
                            this.tempPanel.remove(this.fabricPanel);
                            this.tempPanel.add((JComponent)this.zoneNoPorts, 0, 1, 2);
                        }
                    }
                    if (!this.getRefreshData || this.totalFabrics <= 0) break block45;
                    this.fab = (GUIFabric)this.fabrics.get(this.currentFabric);
                    if (this.zoneSteps == null || this.zoneSteps.size() <= 0) break block46;
                    this.zoneAction = (ZoneAction)this.zoneSteps.get(this.fab.getDeviceId());
                    if (this.zoneAction == null) break block47;
                    switch (this.zoneAction.action) {
                        case 0: {
                            this.newZoneRadioButton.setSelected(true);
                            this.zoneNameTextField.setText(this.zoneAction.zoneName);
                            this.zoneExistComboBox.setEnabled(false);
                            this.zoneNameTextField.setEnabled(true);
                            break;
                        }
                        case 1: {
                            this.updateZoneRadioButton.setSelected(true);
                            this.zoneNameTextField.setEnabled(false);
                            if (this.zoneAction.zoneset != null) {
                                this.zoneSetLabel.setText(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", this.zoneAction.zoneset.getDeviceId()));
                                this.zoneExistComboBox.setEnabled(true);
                                serializable = new DefaultComboBoxModel(this.zoneAction.eZones);
                                this.zoneExistComboBox.setModel(serializable);
                                this.zoneExistComboBox.setSelectedItem(this.zoneAction.zone);
                                break;
                            }
                            break block46;
                        }
                        case 2: {
                            this.zoneNameTextField.setEnabled(false);
                            this.zoneExistComboBox.setEnabled(false);
                            this.dontDoRadioButton.setSelected(true);
                            break;
                        }
                    }
                    break block46;
                }
                this.zoneNameTextField.setText(new String());
                this.dontDoRadioButton.setSelected(true);
            }
            this.getRefreshData = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = null;
        if (actionEvent == null) {
            return;
        }
        object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object.equals(this.updateZoneRadioButton)) {
            this.zoneNameTextField.setText(new String());
            this.zoneNameTextField.setEnabled(false);
            this.zoneExistComboBox.setEnabled(true);
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(this.existingZones);
            this.zoneExistComboBox.setModel(defaultComboBoxModel);
        } else if (object.equals(this.newZoneRadioButton)) {
            this.zoneExistComboBox.setEnabled(false);
            this.zoneNameTextField.setEnabled(true);
        } else if (object.equals(this.dontDoRadioButton)) {
            this.zoneNameTextField.setText(new String());
            this.zoneExistComboBox.setEnabled(false);
            this.zoneNameTextField.setEnabled(false);
        }
    }

    public void getPortsByZone(String string, String string2, String string3) {
        this.nextButton.setEnabled(false);
        this.diskAccessor.getPortsByZone(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    BaseZoneActionStep.this.portsInZone = (String[])response.responseData;
                }
                BaseZoneActionStep.this.nextButton.setEnabled(true);
            }
        }, string, string2, string3);
    }

    public void getFabricsInfo(GUIFabric gUIFabric) {
        int n;
        this.hostportsVector = new Vector();
        this.ssportsVector = new Vector();
        this.hostportsVectorString = new Vector();
        this.ssportsVectorString = new Vector();
        this.existingZones = new Vector();
        this.fabricID = gUIFabric.getId();
        this.zoneset = gUIFabric.getActiveZoneSet();
        this.zoneMap = this.zoneset.getZones();
        if (this.zoneMap != null) {
            this.existingZones = new Vector(this.zoneMap.values());
            this.existingZones = GUIEntityUtil.sort(this.existingZones);
        }
        this.zoneNameMap = new HashMap();
        int n2 = 0;
        while (n2 < this.existingZones.size()) {
            String string = ((GUIZone)this.existingZones.get(n2)).toString();
            this.zoneNameMap.put(string, string);
            ++n2;
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(this.existingZones);
        this.zoneExistComboBox.setModel(defaultComboBoxModel);
        this.checkZones();
        this.fab = gUIFabric;
        this.zoneAccessor.ping(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                BaseZoneActionStep.this.nextButton.setEnabled(false);
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    BaseZoneActionStep.this.zoneCap = (ZoneCapabilities)hashMap.get("pingZoneAgent");
                    if (BaseZoneActionStep.this.zoneCap == null) {
                        if (hashMap.containsKey("pingError")) {
                            int n = (Integer)hashMap.get("pingError");
                            String string = "";
                            switch (n) {
                                case 5: {
                                    Util.getString("FabricZone_TokenError");
                                    string = Util.getString("FMSG_PING_INVALID_TOKEN_ERROR");
                                    break;
                                }
                                case 3: {
                                    Util.getString("FabricZoneNotebook_pingLockedWarning");
                                    string = Util.getString("FMSG_PING_LOCKED_ERROR");
                                    break;
                                }
                                case 4: {
                                    Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                    string = Util.getString("FMSG_PING_NOTAVAILABLE_ERROR");
                                    break;
                                }
                                case 1: {
                                    Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                    string = Util.getString("FMSG_PING_GENERAL_ERROR");
                                }
                            }
                            BaseZoneActionStep.this.zoneError = true;
                            BaseZoneActionStep.this.dontDoRadioButton.setSelected(true);
                            BaseZoneActionStep.this.zoneExistComboBox.setEnabled(false);
                            BaseZoneActionStep.this.zoneNameTextField.setEnabled(false);
                            JOptionPane.showMessageDialog(BaseZoneActionStep.this.zoneStep, string, Util.getString("DISK_ZONE_ACTIONS_LABEL"), 0);
                        }
                        BaseZoneActionStep.this.zoneCap = new ZoneCapabilities();
                    } else {
                        BaseZoneActionStep.this.zoneError = false;
                    }
                    BaseZoneActionStep.this.fab.setZoneCapabilities(BaseZoneActionStep.this.zoneCap);
                }
                BaseZoneActionStep.this.nextButton.setEnabled(true);
            }
        }, this.fabricID);
        Vector vector = new Vector();
        GUIPort gUIPort = null;
        Vector<String> vector2 = new Vector<String>();
        String string = new String();
        String string2 = new String();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n3 = 0;
        while (n3 < this.hostportData.size()) {
            try {
                gUIPort = (GUIPort)this.hostportData.get(n3);
                vector = gUIPort.getFabrics();
                int n4 = 0;
                while (vector != null && n4 < vector.size()) {
                    if (this.fabricID.equals((String)vector.get(n4))) {
                        string2 = gUIPort.getWwpn();
                        string = gUIPort.getHostName();
                        if (hashMap.get(string2) == null) {
                            hashMap.put(string2, string2);
                            this.hostportsVector.add(gUIPort);
                            if (string != null && string.trim().length() > 0) {
                                string2 = String.valueOf(string2) + " (" + string + ")";
                            }
                            this.hostportsVectorString.add(string2);
                            vector2.add(gUIPort.getWwpn());
                        }
                    }
                    ++n4;
                }
            }
            catch (ClassCastException classCastException) {
                vector2.add((String)this.hostportData.get(n3));
            }
            ++n3;
        }
        gUIPort = null;
        n3 = 0;
        while (n3 < this.ssportData.size()) {
            try {
                gUIPort = (GUIPort)this.ssportData.get(n3);
                vector = gUIPort.getFabrics();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                n = 0;
                while (vector != null && n < vector.size()) {
                    if (this.fabricID.equals((String)vector.get(n))) {
                        string2 = gUIPort.getWwpn();
                        string = gUIPort.getHostName();
                        if (hashMap2.get(string2) == null) {
                            hashMap2.put(string2, string2);
                            this.ssportsVector.add(gUIPort);
                            if (string != null && string.trim().length() > 0) {
                                string2 = String.valueOf(string2) + " (" + string + ")";
                            }
                            this.ssportsVectorString.add(string2);
                            vector2.add(gUIPort.getWwpn());
                        }
                    }
                    ++n;
                }
            }
            catch (ClassCastException classCastException) {
                vector2.add((String)this.hostportData.get(n3));
            }
            ++n3;
        }
        this.zoneActionDisplay = this.hostportsVector.size() < 0 && this.ssportsVector.size() < 0 ? 0 : -1;
        GUIZone gUIZone = null;
        Vector<String> vector3 = new Vector<String>();
        n = 0;
        while (n < this.existingZones.size()) {
            gUIZone = (GUIZone)this.existingZones.get(n);
            this.portsInZone = gUIZone.getPorts();
            vector3 = new Vector();
            int n5 = 0;
            while (n5 < this.portsInZone.length) {
                vector3.add(this.portsInZone[n5]);
                ++n5;
            }
            if (vector3.containsAll(vector2)) {
                this.zoneActionDisplay = 1;
                break;
            }
            ++n;
        }
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel(this.hostportsVectorString);
        this.portList.setModel(defaultComboBoxModel2);
        DefaultComboBoxModel defaultComboBoxModel3 = new DefaultComboBoxModel(this.ssportsVectorString);
        this.ssportList.setModel(defaultComboBoxModel3);
    }

    public Vector getHostPorts() {
        return new Vector();
    }

    public Vector getSubsystemPorts() {
        return new Vector();
    }

    public void getFabricsFromSystem() {
    }

    public boolean nextBegin() {
        String string;
        boolean bl = false;
        this.getRefreshData = true;
        if (this.currentFabric < 0) {
            bl = true;
            --this.currentFabric;
            this.addData();
            if (this.excludedHostports.size() > 0) {
                this.zoneList.put(Util.getString("DISK_VOLUME_HOST_PORT_LABEL"), Util.getString("DISK_VOLUME_ZONE_ACTION_EXCLUDED_HOSTPORTS_LABEL", this.excludedHostports.toString()));
            }
            if (this.excludedSSports.size() > 0) {
                this.zoneList.put(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_LABEL"), Util.getString("DISK_VOLUME_ZONE_ACTION_EXCLUDED_SUBSYSTEMPORTS_LABEL", this.excludedSSports.toString()));
            }
            return true;
        }
        this.fab = (GUIFabric)this.fabrics.get(this.currentFabric);
        this.zoneAction = new ZoneAction();
        this.zoneAction.fabricID = ((GUIFabric)this.fabrics.get(this.currentFabric)).getId();
        this.zoneAction.zoneset = this.zoneset;
        if (this.zoneError) {
            this.dontDoRadioButton.setSelected(true);
            this.newZoneRadioButton.setEnabled(false);
            this.updateZoneRadioButton.setEnabled(false);
        } else {
            this.newZoneRadioButton.setEnabled(true);
            this.updateZoneRadioButton.setEnabled(true);
        }
        if (this.newZoneRadioButton.isSelected()) {
            this.zoneAction.action = 0;
            this.zoneAction.zoneName = this.zoneNameTextField.getText();
            string = this.checkZoneNameString(this.zoneAction.zoneName);
            if (string != null) {
                JOptionPane.showMessageDialog(this, string, Util.getString("DISK_VOLUME_ZONE_ACTION_NEW_ZONE_LABEL"), 0);
                return false;
            }
            this.zoneAction.actionString = new String(Util.getString("DISK_VOLUME_ZONE_ACTIONSTRING_CREATE_ZONE_LABEL", this.zoneAction.zoneName, this.zoneAction.fabricID));
        } else if (this.updateZoneRadioButton.isSelected()) {
            this.zoneAction.action = 1;
            this.zoneAction.zone = (GUIZone)this.zoneExistComboBox.getSelectedItem();
            if (this.zoneAction.zone != null) {
                this.zoneAction.zoneName = this.zoneAction.zone.getName();
            }
            this.zoneAction.actionString = new String(Util.getString("DISK_VOLUME_ZONE_ACTIONSTRING_UPDATE_ZONE_LABEL", this.zoneAction.zoneName, this.zoneAction.fabricID));
        } else if (this.dontDoRadioButton.isSelected()) {
            this.zoneAction.action = 2;
            this.zoneAction.actionString = new String(Util.getString("DISK_VOLUME_ZONE_ACTION_DONTDO_WARNING_LABEL", this.zoneAction.fabricID));
        }
        if (this.zoneSteps.containsKey(this.zoneAction.fabricID)) {
            this.zoneSteps.remove(this.zoneAction.fabricID);
            this.zoneList.remove(this.zoneAction.fabricID);
        }
        this.zoneSteps.put(this.zoneAction.fabricID, this.zoneAction);
        this.zoneList.put(this.zoneAction.fabricID, this.zoneAction.actionString);
        this.zoneAction.hostPorts = this.hostportsVector;
        this.zoneAction.ssPorts = this.ssportsVector;
        this.zoneAction.eZones = this.existingZones;
        this.zoneAction = new ZoneAction();
        ++this.currentFabric;
        if (this.currentFabric >= this.totalFabrics) {
            bl = true;
            --this.currentFabric;
            this.addData();
            if (this.excludedHostports.size() > 0) {
                this.zoneList.put(Util.getString("DISK_VOLUME_HOST_PORT_LABEL"), Util.getString("DISK_VOLUME_ZONE_ACTION_EXCLUDED_HOSTPORTS_LABEL", this.excludedHostports.toString()));
            }
            if (this.excludedSSports.size() > 0) {
                this.zoneList.put(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_LABEL"), Util.getString("DISK_VOLUME_ZONE_ACTION_EXCLUDED_SUBSYSTEMPORTS_LABEL", this.excludedSSports.toString()));
            }
        } else {
            this.fab = (GUIFabric)this.fabrics.get(this.currentFabric);
            this.getFabricsInfo(this.fab);
            this.zoneSetLabel.setText(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", this.fab.getActiveZoneSet().getDeviceId()));
            string = Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC_LABEL", this.fab.getDeviceId(), Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC2_LABEL", String.valueOf(this.currentFabric + 1), String.valueOf(this.totalFabrics)));
            this.titleLabel.setText(string);
            this.zoneNameTextField.setText("");
            this.dontDoRadioButton.setSelected(true);
            switch (this.zoneActionDisplay) {
                case -1: {
                    this.tempPanel.remove(this.zoneNoPorts);
                    this.tempPanel.remove(this.zoneCommonPorts);
                    this.tempPanel.add(this.fabricPanel);
                    break;
                }
                case 0: {
                    this.tempPanel.remove(this.zoneCommonPorts);
                    this.tempPanel.remove(this.fabricPanel);
                    this.tempPanel.add(this.zoneNoPorts);
                    break;
                }
                case 1: {
                    this.tempPanel.remove(this.fabricPanel);
                    this.tempPanel.remove(this.zoneNoPorts);
                    this.tempPanel.add(this.zoneCommonPorts);
                }
            }
            bl = false;
        }
        return bl;
    }

    private String checkZoneNameString(String string) {
        String string2 = null;
        if (string.length() <= 0) {
            return Util.getString("FabricZoneFrame_ZoneConfigurationErrorTitle");
        }
        if (string.indexOf(32) != -1) {
            return Util.getString("FMSG_FabricZoneFrame_BadCharZoneNameErrorMsg");
        }
        if (!this.fab.getZoneCapabilities().isAllowsNumericNameStart() && Character.isDigit(string.charAt(0))) {
            string2 = Util.getString("FabricZoneFrame_NumericalZoneNameErrorMsg");
            return string2;
        }
        if (!this.fab.getZoneCapabilities().isSupportsSpecialCharacters()) {
            char[] cArray = string.toCharArray();
            boolean bl = this.fab.getZoneCapabilities().getZcAgentType() == 0;
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] == '$' || cArray[n] == '-' || cArray[n] == ' ' || cArray[n] == '%' || cArray[n] == '&') {
                    string2 = Util.getString("FMSG_FabricZoneFrame_BadCharZoneNameErrorMsg");
                    return string2;
                }
                if (bl && cArray[n] == '.') {
                    string2 = Util.getString("FMSG_FabricZoneFrame_BadCharZoneNameErrorMsg");
                    return string2;
                }
                ++n;
            }
        }
        if (this.zoneNameMap.get(string) != null) {
            string2 = Util.getString("FabricZoneFrame_DuplicateZoneNameErrorMsg");
            return string2;
        }
        return string2;
    }

    private void checkZones() {
        if (this.existingZones.size() <= 0) {
            this.updateZoneRadioButton.setEnabled(false);
            this.zoneExistComboBox.setEnabled(false);
        } else if (this.updateZoneRadioButton.isSelected()) {
            this.zoneExistComboBox.setEnabled(true);
        } else {
            this.zoneExistComboBox.setEnabled(false);
        }
    }

    public void addData() {
    }

    public JDialog getWizardDialog() {
        return null;
    }

    public void skip() {
        this.skipStep = true;
    }

    public boolean previousBegin() {
        boolean bl = false;
        this.getRefreshData = false;
        --this.currentFabric;
        if (this.currentFabric >= 0) {
            bl = false;
            String string = ((GUIFabric)this.fabrics.get(this.currentFabric)).getId();
            String string2 = Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC_LABEL", string, Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC2_LABEL", String.valueOf(this.currentFabric + 1), String.valueOf(this.totalFabrics)));
            this.titleLabel.setText(string2);
            this.zoneAction = (ZoneAction)this.zoneSteps.get(string);
            switch (this.zoneAction.action) {
                case 0: {
                    this.newZoneRadioButton.setSelected(true);
                    this.zoneNameTextField.setEnabled(true);
                    this.zoneExistComboBox.setSelectedIndex(0);
                    this.zoneExistComboBox.setEnabled(false);
                    this.zoneNameTextField.setText(this.zoneAction.zoneName);
                    break;
                }
                case 1: {
                    this.updateZoneRadioButton.setSelected(true);
                    this.zoneNameTextField.setEnabled(false);
                    if (this.zoneAction.zoneset != null) {
                        this.zoneSetLabel.setText(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", this.zoneAction.zoneset.getDeviceId()));
                        this.zoneExistComboBox.setEnabled(true);
                        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(this.zoneAction.eZones);
                        this.zoneExistComboBox.setModel(defaultComboBoxModel);
                        this.zoneExistComboBox.setSelectedItem(this.zoneAction.zone);
                    }
                    this.zoneNameTextField.setText(new String());
                    break;
                }
                case 2: {
                    this.dontDoRadioButton.setSelected(true);
                    this.zoneExistComboBox.setSelectedIndex(0);
                    this.zoneNameTextField.setText(new String());
                    this.zoneNameTextField.setEnabled(false);
                    this.zoneExistComboBox.setEnabled(false);
                    break;
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean previousComplete() {
        this.currentFabric = -1;
        this.getData = true;
        return true;
    }

    public boolean nextComplete() {
        this.getData = true;
        return true;
    }

    protected class ZoneAction {
        public String fabricID = new String();
        public GUIZoneSet zoneset = null;
        public GUIZone zone = null;
        public String zoneName = new String();
        public int action = 2;
        public String actionString = new String();
        public Vector eZones = new Vector();
        public Vector hostPorts = new Vector();
        public Vector ssPorts = new Vector();

        protected ZoneAction() {
        }

        public String toString() {
            return String.valueOf(this.fabricID) + "," + this.zoneset + "," + this.zone + "," + this.zoneName + "," + this.action + "," + this.actionString;
        }
    }
}

