/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.GUIPortAssignment;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.VolumeDDI;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolumeDetailsPanel
extends JPanel
implements ActionListener {
    private VolumeDDI theDDI;
    private GUIVolume volume;
    private Vector hostvct;
    private Vector subportvct;
    private JList lstSubsystemPorts;
    private JList lstHostPorts;
    private JScrollPane scrollSubP;
    private JScrollPane scrollHostP;
    private JLabel lbVolume;
    private JLabel lbVolumeSize;
    private JLabel lbArray;
    private JLabel lbRaid;
    private JLabel lbSubsystem;
    private JLabel lbSubsystemName;
    private JLabel lbSubsystemPorts = null;
    private JLabel lbHostPorts = null;
    private HashMap hmapHosttoSub = new HashMap();
    protected DefaultListModel subportModel = new DefaultListModel();
    protected DefaultListModel hostportModel = new DefaultListModel();

    public VolumeDetailsPanel(VolumeDDI volumeDDI, GUIVolume gUIVolume) {
        this.theDDI = volumeDDI;
        this.volume = gUIVolume;
    }

    public JComponent getComponent() {
        this.setLayout(new FlowLayout(0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 20, 5, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new BoldLabel(Util.getString("DISK_VOLUME_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.lbVolume = new JLabel();
        this.lbVolume.setText(GUIEntityUtil.getDisplayText(this.volume.getDeviceId()));
        jPanel.add((Component)this.lbVolume, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new BoldLabel(Util.getString("DISK_VOLUMESIZE_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.lbVolumeSize = new JLabel();
        double d = GUIEntityUtil.convertStorageCapacity(this.volume.getCapacity(), 0, 3, 10);
        String string = "";
        long l = 0L;
        switch (this.volume.getFormat()) {
            case 0: {
                string = Util.getString("DISK_GB_LABEL");
                this.lbVolumeSize.setText(String.valueOf(GUIEntityUtil.getNumberString(new Double(d), 2, Locale.getDefault())) + " " + string);
                break;
            }
            case 1: {
                string = Util.getString("DISK_CYL_LABEL");
                switch (this.theDDI.subsystem.getType()) {
                    case 0: {
                        l = BigDecimal.valueOf(this.volume.getCapacity()).divide(new BigDecimal("798720"), 4).longValue();
                        break;
                    }
                    case 2: 
                    case 3: {
                        l = BigDecimal.valueOf(this.volume.getCapacity()).divide(new BigDecimal("712140"), 4).longValue();
                    }
                }
                this.lbVolumeSize.setText(String.valueOf(GUIEntityUtil.getNumberString(new Long(l), 0, Locale.getDefault())) + " " + string + "; " + GUIEntityUtil.getNumberString(new Double(d), 2, Locale.getDefault()) + " " + Util.getString("DISK_GB_LABEL"));
                break;
            }
            case 2: {
                string = Util.getString("DISK_CYL_LABEL");
                switch (this.theDDI.subsystem.getType()) {
                    case 0: {
                        l = BigDecimal.valueOf(this.volume.getCapacity()).divide(new BigDecimal("860160"), 4).longValue();
                        break;
                    }
                    case 2: 
                    case 3: {
                        l = BigDecimal.valueOf(this.volume.getCapacity()).divide(new BigDecimal("849960"), 4).longValue();
                    }
                }
                this.lbVolumeSize.setText(String.valueOf(GUIEntityUtil.getNumberString(new Long(l), 0, Locale.getDefault())) + " " + string + "; " + GUIEntityUtil.getNumberString(new Double(d), 2, Locale.getDefault()) + " " + Util.getString("DISK_GB_LABEL"));
            }
        }
        jPanel.add((Component)this.lbVolumeSize, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new BoldLabel(Util.getString("DISK_ARRAY_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.lbArray = new JLabel();
        this.lbArray.setText(GUIEntityUtil.getDisplayText(this.volume.getStoragePoolName()));
        jPanel.add((Component)this.lbArray, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new BoldLabel(Util.getString("DISK_RAIDLEVEL_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.lbRaid = new JLabel();
        int n = this.volume.getRaidLevel();
        if (n == 77) {
            this.lbRaid.setText(Util.getString("DISK_MIXED_LABEL"));
        } else if (n == 99) {
            this.lbRaid.setText(MessageLog.getMessageNoID("GUI0129T"));
        } else {
            this.lbRaid.setText(Util.getString("DISK_RAID_LABEL", String.valueOf(n)));
        }
        jPanel.add((Component)this.lbRaid, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)new BoldLabel(Util.getString("DISK_SUBSYSTEM_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.lbSubsystem = new JLabel();
        this.lbSubsystem.setText(GUIEntityUtil.getDisplayText(this.volume.getSubsystemDeviceId()));
        jPanel.add((Component)this.lbSubsystem, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)new BoldLabel(Util.getString("DISK_COMMON_SUBSYSTEM_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.lbSubsystemName = new JLabel();
        this.lbSubsystemName.setText(GUIEntityUtil.getDisplayText(this.volume.getSubsystemName()));
        jPanel.add((Component)this.lbSubsystemName, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.lbHostPorts = new BoldLabel(Util.getString("DISK_HOSTPORTS_LABEL"));
        jPanel.add((Component)this.lbHostPorts, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.lstHostPorts = new JList(this.hostportModel);
        GuiUtil.setAccessibleLabel(this.lbHostPorts, this.lstHostPorts, "", this.lbHostPorts.getText(), this.lbHostPorts.getText());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("");
        this.lstHostPorts.setBorder(titledBorder);
        int n2 = 200;
        this.lstHostPorts.setFixedCellWidth(n2);
        this.lstHostPorts.setVisibleRowCount(10);
        this.lstHostPorts.setSelectionMode(0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                JList jList = (JList)mouseEvent.getSource();
                if ((mouseEvent.getClickCount() == 1 || mouseEvent.getClickCount() == 2) && (n = jList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    Object e = jList.getModel().getElementAt(n);
                    Vector vector = (Vector)VolumeDetailsPanel.this.hmapHosttoSub.get(e.toString());
                    if (vector != null) {
                        VolumeDetailsPanel.this.subportModel.removeAllElements();
                        Iterator iterator = vector.iterator();
                        while (iterator.hasNext()) {
                            VolumeDetailsPanel.this.subportModel.addElement((String)iterator.next());
                        }
                    }
                }
            }
        };
        this.lstHostPorts.addMouseListener(mouseAdapter);
        this.scrollHostP = new JScrollPane(this.lstHostPorts);
        jPanel.add((Component)this.scrollHostP, gridBagConstraints);
        String[] stringArray = new String[]{this.volume.getId()};
        this.theDDI.diskAccessor.getPortAssignments(new GuiRequestor(){

            /*
             * Unable to fully structure code
             */
            public void handleResponse(short var1_1, Response var2_2) {
                block3: {
                    if (var1_1 > 4) break block3;
                    var3_3 = (HashMap)var2_2.responseData;
                    var4_4 = var3_3.values();
                    var5_5 = var4_4.iterator();
                    if (var5_5.hasNext()) ** GOTO lbl16
                    VolumeDetailsPanel.this.hostportModel.addElement(Util.getString("DISK_NA_LABEL"));
                    VolumeDetailsPanel.this.subportModel.addElement(Util.getString("DISK_NA_LABEL"));
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        var6_6 = (GUIPortAssignment)var5_5.next();
                        var7_7 = var6_6.getHostPortWwpn();
                        if (var7_7 == null || var7_7.equals("null")) continue;
                        var8_8 = var6_6.getSubsystemPorts();
                        Collections.sort(var8_8);
                        VolumeDetailsPanel.access$0(VolumeDetailsPanel.this).put(var7_7, var8_8);
lbl16:
                        // 3 sources

                        ** while (var5_5.hasNext())
                    }
lbl17:
                    // 1 sources

                    var8_8 = new Vector((Collection)VolumeDetailsPanel.access$0(VolumeDetailsPanel.this).keySet());
                    Collections.sort(var8_8);
                    var9_9 = var8_8.iterator();
                    while (var9_9.hasNext()) {
                        VolumeDetailsPanel.this.hostportModel.addElement((String)var9_9.next());
                    }
                    VolumeDetailsPanel.access$1(VolumeDetailsPanel.this).setSelectedIndex(0);
                    var10_10 = (Vector)VolumeDetailsPanel.access$0(VolumeDetailsPanel.this).get(var8_8.elementAt(0));
                    var9_9 = var10_10.iterator();
                    while (var9_9.hasNext()) {
                        VolumeDetailsPanel.this.subportModel.addElement((String)var9_9.next());
                    }
                }
            }
        }, this.theDDI.subsystem.getId(), stringArray[0]);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.lbSubsystemPorts = new BoldLabel(Util.getString("DISK_SUBSYSTEMPORTS_LABEL"));
        jPanel.add((Component)this.lbSubsystemPorts, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.lstSubsystemPorts = new JList(this.subportModel);
        GuiUtil.setAccessibleLabel(this.lbSubsystemPorts, this.lstSubsystemPorts, "", this.lbSubsystemPorts.getText(), this.lbSubsystemPorts.getText());
        this.lstSubsystemPorts.setBorder(titledBorder);
        this.lstSubsystemPorts.setFixedCellWidth(n2);
        this.lstSubsystemPorts.setVisibleRowCount(10);
        this.scrollSubP = new JScrollPane(this.lstSubsystemPorts);
        jPanel.add((Component)this.scrollSubP, gridBagConstraints);
        this.add((Component)jPanel, "Before");
        return this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    static /* synthetic */ JList access$1(VolumeDetailsPanel volumeDetailsPanel) {
        return volumeDetailsPanel.lstHostPorts;
    }
}

