/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Vector;

public class TopoLayoutUtilities {
    public static int getVisibleComponentCount(Container container) {
        int n = 0;
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            Component component = componentArray[n2];
            if (component.isVisible()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static Vector getVisibleComponents(Container container) {
        Vector<Component> vector = new Vector<Component>();
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component.isVisible()) {
                vector.add(component);
            }
            ++n;
        }
        return vector;
    }

    public static class HorizontalLayout
    implements LayoutManager {
        protected int alignment = 1;
        protected int horizontalJustify = 0;
        protected int verticalJustify = 0;
        protected int spacing = 0;
        protected int margin = 0;

        public int getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int n) {
            this.alignment = n;
        }

        public int getHorizontalJustify() {
            return this.horizontalJustify;
        }

        public void setHorizontalJustify(int n) {
            this.horizontalJustify = n;
        }

        public int getVerticalJustify() {
            return this.verticalJustify;
        }

        public void setVerticalJustify(int n) {
            this.verticalJustify = n;
        }

        public int getSpacing() {
            return this.spacing;
        }

        public void setSpacing(int n) {
            this.spacing = n;
        }

        public int getMargin() {
            return this.margin;
        }

        public void setMargin(int n) {
            this.margin = n;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Vector vector = TopoLayoutUtilities.getVisibleComponents(container);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            dimension.width += this.margin * 2;
            dimension.height += this.margin * 2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < vector.size()) {
                Component component = (Component)vector.elementAt(n3);
                Dimension dimension2 = component.getPreferredSize();
                if (n3 != 0) {
                    n += this.spacing;
                }
                n += dimension2.width;
                n2 = dimension2.height > n2 ? dimension2.height : n2;
                ++n3;
            }
            dimension.width += n;
            dimension.height += n2;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n = 0;
            int n2 = 0;
            Vector vector = TopoLayoutUtilities.getVisibleComponents(container);
            Dimension[] dimensionArray = new Dimension[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                Dimension dimension;
                Component component = (Component)vector.elementAt(n3);
                dimensionArray[n3] = dimension = component.getPreferredSize();
                ++n3;
            }
            Insets insets = container.getInsets();
            n += insets.left;
            n2 += insets.top;
            n += this.margin;
            n2 += this.margin;
            int n4 = 0;
            int n5 = 0;
            while (n5 < vector.size()) {
                Dimension dimension = dimensionArray[n5];
                n4 = dimension.height > n4 ? dimension.height : n4;
                ++n5;
            }
            n5 = container.getWidth() - insets.left - insets.right - this.margin * 2;
            int n6 = 0;
            while (n6 < dimensionArray.length) {
                if (n6 != 0) {
                    n5 -= this.spacing;
                }
                n5 -= dimensionArray[n6].width;
                ++n6;
            }
            n6 = container.getHeight() - insets.top - insets.bottom - this.margin * 2 - n4;
            if (this.horizontalJustify == 0) {
                n += n5 / 2;
            } else if (this.horizontalJustify == 4) {
                n += n5;
            }
            if (this.verticalJustify == 0) {
                n2 += n6 / 2;
            } else if (this.verticalJustify == 3) {
                n2 += n6;
            }
            int n7 = 0;
            while (n7 < vector.size()) {
                Component component = (Component)vector.elementAt(n7);
                Dimension dimension = dimensionArray[n7];
                int n8 = n;
                int n9 = n2;
                int n10 = dimension.width;
                int n11 = dimension.height;
                if (this.alignment == 0) {
                    n9 += (n4 - n11) / 2;
                } else if (this.alignment == 3) {
                    n9 += n4 - n11;
                }
                component.setBounds(n8, n9, n10, n11);
                n += n10 + this.spacing;
                ++n7;
            }
        }
    }

    public static class VerticalLayout
    implements LayoutManager {
        protected int alignment = 2;
        protected int horizontalJustify = 0;
        protected int verticalJustify = 0;
        protected int spacing = 0;
        protected int margin = 0;

        public int getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int n) {
            this.alignment = n;
        }

        public int getHorizontalJustify() {
            return this.horizontalJustify;
        }

        public void setHorizontalJustify(int n) {
            this.horizontalJustify = n;
        }

        public int getVerticalJustify() {
            return this.verticalJustify;
        }

        public void setVerticalJustify(int n) {
            this.verticalJustify = n;
        }

        public int getSpacing() {
            return this.spacing;
        }

        public void setSpacing(int n) {
            this.spacing = n;
        }

        public int getMargin() {
            return this.margin;
        }

        public void setMargin(int n) {
            this.margin = n;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Vector vector = TopoLayoutUtilities.getVisibleComponents(container);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            dimension.width += this.margin * 2;
            dimension.height += this.margin * 2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < vector.size()) {
                Component component = (Component)vector.elementAt(n3);
                Dimension dimension2 = component.getPreferredSize();
                int n4 = n = dimension2.width > n ? dimension2.width : n;
                if (n3 != 0) {
                    n2 += this.spacing;
                }
                n2 += dimension2.height;
                ++n3;
            }
            dimension.width += n;
            dimension.height += n2;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n = 0;
            int n2 = 0;
            Vector vector = TopoLayoutUtilities.getVisibleComponents(container);
            Dimension[] dimensionArray = new Dimension[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                Dimension dimension;
                Component component = (Component)vector.elementAt(n3);
                dimensionArray[n3] = dimension = component.getPreferredSize();
                ++n3;
            }
            Insets insets = container.getInsets();
            n += insets.left;
            n2 += insets.top;
            n += this.margin;
            n2 += this.margin;
            int n4 = 0;
            int n5 = 0;
            while (n5 < vector.size()) {
                Dimension dimension = dimensionArray[n5];
                n4 = dimension.width > n4 ? dimension.width : n4;
                ++n5;
            }
            n5 = container.getWidth() - insets.left - insets.right - this.margin * 2 - n4;
            int n6 = container.getHeight() - insets.top - insets.bottom - this.margin * 2;
            int n7 = 0;
            while (n7 < dimensionArray.length) {
                if (n7 != 0) {
                    n6 -= this.spacing;
                }
                n6 -= dimensionArray[n7].height;
                ++n7;
            }
            if (this.horizontalJustify == 0) {
                n += n5 / 2;
            } else if (this.horizontalJustify == 4) {
                n += n5;
            }
            if (this.verticalJustify == 0) {
                n2 += n6 / 2;
            } else if (this.verticalJustify == 3) {
                n2 += n6;
            }
            n7 = 0;
            while (n7 < vector.size()) {
                Component component = (Component)vector.elementAt(n7);
                Dimension dimension = dimensionArray[n7];
                int n8 = n;
                int n9 = n2;
                int n10 = dimension.width;
                int n11 = dimension.height;
                if (this.alignment == 0) {
                    n8 += (n4 - n10) / 2;
                } else if (this.alignment == 4) {
                    n8 += n4 - n10;
                }
                component.setBounds(n8, n9, n10, n11);
                n2 += n11 + this.spacing;
                ++n7;
            }
        }
    }

    public static class SquareGridLayout
    extends GridLayout {
        protected Dimension getRowColumn(Vector vector) {
            int n = vector.size();
            int n2 = (int)Math.ceil(Math.sqrt(n));
            int n3 = (int)Math.ceil((double)n / (double)n2);
            return new Dimension(n2, n3);
        }
    }

    public static class HorizontalGridLayout
    extends GridLayout {
        protected int sizePerColumn;

        public HorizontalGridLayout(int n) {
            this.sizePerColumn = n;
        }

        protected Dimension getRowColumn(Vector vector) {
            int n = vector.size();
            int n2 = this.sizePerColumn;
            int n3 = (int)Math.ceil((double)n / (double)n2);
            return new Dimension(n3, n2);
        }
    }

    public static class VerticalGridLayout
    extends GridLayout {
        protected int sizePerRow;

        public VerticalGridLayout(int n) {
            this.sizePerRow = n;
        }

        protected Dimension getRowColumn(Vector vector) {
            int n = vector.size();
            int n2 = this.sizePerRow;
            int n3 = (int)Math.ceil((double)n / (double)n2);
            return new Dimension(n2, n3);
        }
    }

    public static abstract class GridLayout
    implements LayoutManager {
        protected int horizontalAlignment = 0;
        protected int verticalAlignment = 1;
        protected int horizontalJustify = 0;
        protected int verticalJustify = 0;
        protected int spacing = 0;
        protected int margin = 0;

        public int getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public void setHorizontalAlignment(int n) {
            this.horizontalAlignment = n;
        }

        public int getVerticalAlignment() {
            return this.verticalAlignment;
        }

        public void setVerticalAlignment(int n) {
            this.verticalAlignment = n;
        }

        public int getHorizontalJustify() {
            return this.horizontalJustify;
        }

        public void setHorizontalJustify(int n) {
            this.horizontalJustify = n;
        }

        public int getVerticalJustify() {
            return this.verticalJustify;
        }

        public void setVerticalJustify(int n) {
            this.verticalJustify = n;
        }

        public int getSpacing() {
            return this.spacing;
        }

        public void setSpacing(int n) {
            this.spacing = n;
        }

        public int getMargin() {
            return this.margin;
        }

        public void setMargin(int n) {
            this.margin = n;
        }

        protected abstract Dimension getRowColumn(Vector var1);

        protected Component[][] getGrids(Vector vector, Dimension dimension) {
            Component[][] componentArray = new Component[dimension.height][dimension.width];
            int n = vector.size();
            int n2 = 0;
            int n3 = 0;
            while (n3 < dimension.height) {
                int n4 = 0;
                while (n4 < dimension.width) {
                    if (n2 < n) {
                        componentArray[n3][n4] = (Component)vector.elementAt(n2);
                    }
                    ++n2;
                    ++n4;
                }
                ++n3;
            }
            return componentArray;
        }

        protected Dimension[][] getDimensions(Component[][] componentArray) {
            int n = componentArray.length;
            int n2 = n == 0 ? 0 : componentArray[0].length;
            Dimension[][] dimensionArray = new Dimension[n][n2];
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    Component component = componentArray[n3][n4];
                    if (component != null) {
                        dimensionArray[n3][n4] = component.getPreferredSize();
                    }
                    ++n4;
                }
                ++n3;
            }
            return dimensionArray;
        }

        protected int[] getWidestDimensions(Dimension[][] dimensionArray) {
            int n = dimensionArray.length;
            int n2 = n == 0 ? 0 : dimensionArray[0].length;
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < n) {
                    Dimension dimension = dimensionArray[n5][n3];
                    if (dimension != null) {
                        n4 = dimension.width > n4 ? dimension.width : n4;
                    }
                    ++n5;
                }
                nArray[n3] = n4;
                ++n3;
            }
            return nArray;
        }

        protected int[] getTallestDimensions(Dimension[][] dimensionArray) {
            int n = dimensionArray.length;
            int n2 = n == 0 ? 0 : dimensionArray[0].length;
            int[] nArray = new int[n];
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < n2) {
                    Dimension dimension = dimensionArray[n3][n5];
                    if (dimension != null) {
                        n4 = dimension.height > n4 ? dimension.height : n4;
                    }
                    ++n5;
                }
                nArray[n3] = n4;
                ++n3;
            }
            return nArray;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Vector vector = TopoLayoutUtilities.getVisibleComponents(container);
            Dimension dimension2 = this.getRowColumn(vector);
            Component[][] componentArray = this.getGrids(vector, dimension2);
            Dimension[][] dimensionArray = this.getDimensions(componentArray);
            int[] nArray = this.getWidestDimensions(dimensionArray);
            int[] nArray2 = this.getTallestDimensions(dimensionArray);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            dimension.width += this.margin * 2;
            dimension.height += this.margin * 2;
            int n = 0;
            int n2 = 0;
            while (n2 < nArray.length) {
                n += nArray[n2];
                if (n2 != 0) {
                    n += this.spacing;
                }
                ++n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n3 < nArray2.length) {
                n2 += nArray2[n3];
                if (n3 != 0) {
                    n2 += this.spacing;
                }
                ++n3;
            }
            dimension.width += n;
            dimension.height += n2;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n = 0;
            int n2 = 0;
            Vector vector = TopoLayoutUtilities.getVisibleComponents(container);
            Dimension dimension = this.getRowColumn(vector);
            Component[][] componentArray = this.getGrids(vector, dimension);
            Dimension[][] dimensionArray = this.getDimensions(componentArray);
            int[] nArray = this.getWidestDimensions(dimensionArray);
            int[] nArray2 = this.getTallestDimensions(dimensionArray);
            Insets insets = container.getInsets();
            n += insets.left;
            n2 += insets.top;
            n += this.margin;
            n2 += this.margin;
            int n3 = container.getWidth() - insets.left - insets.right - this.margin * 2;
            int n4 = 0;
            while (n4 < nArray.length) {
                if (n4 != 0) {
                    n3 -= this.spacing;
                }
                n3 -= nArray[n4];
                ++n4;
            }
            n4 = container.getHeight() - insets.top - insets.bottom - this.margin * 2;
            int n5 = 0;
            while (n5 < nArray2.length) {
                if (n5 != 0) {
                    n4 -= this.spacing;
                }
                n4 -= nArray2[n5];
                ++n5;
            }
            if (this.horizontalJustify == 0) {
                n += n3 / 2;
            } else if (this.horizontalJustify == 4) {
                n += n3;
            }
            if (this.verticalJustify == 0) {
                n2 += n4 / 2;
            } else if (this.verticalJustify == 3) {
                n2 += n4;
            }
            n5 = n;
            int n6 = 0;
            while (n6 < dimension.height) {
                int n7 = nArray2[n6];
                n = n5;
                int n8 = 0;
                while (n8 < dimension.width) {
                    int n9 = nArray[n8];
                    Component component = componentArray[n6][n8];
                    Dimension dimension2 = dimensionArray[n6][n8];
                    if (dimension2 != null) {
                        int n10 = n;
                        int n11 = n2;
                        int n12 = dimension2.width;
                        int n13 = dimension2.height;
                        if (this.horizontalAlignment == 0) {
                            n10 += (n9 - n12) / 2;
                        } else if (this.horizontalAlignment == 4) {
                            n10 += n9 - n12;
                        }
                        if (this.verticalAlignment == 0) {
                            n11 += (n7 - n13) / 2;
                        } else if (this.verticalAlignment == 3) {
                            n11 += n7 - n13;
                        }
                        component.setBounds(n10, n11, n12, n13);
                        n += nArray[n8] + this.spacing;
                    }
                    ++n8;
                }
                n2 += n7 + this.spacing;
                ++n6;
            }
        }
    }
}

