/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResRedundancySnapshotTable;

public class RedundancySnapshot
extends TResRedundancySnapshotTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static RedundancySnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new RedundancySnapshotCursor(dBConnection, hashtable, vector);
    }

    public RedundancySnapshot() {
        this.clear();
    }

    public RedundancySnapshot(int n, int n2, int n3, String string, String string2, int n4, Timestamp timestamp, short s, String string3, short s2, int n5, String string4, String string5, int n6) {
        this.clear();
        this.m_SnapshotId = n;
        this.m_RedundancyId = n2;
        this.m_SubsystemId = n3;
        this.m_ComponentId = string;
        this.m_IpAddress = string2;
        this.m_NodeId = n4;
        this.m_UpdateTimestamp = timestamp;
        this.m_CreationClassNameId = s;
        this.m_Name = string3;
        this.m_NameFormat = s2;
        this.m_OperationalStatus = n5;
        this.m_Wwn = string4;
        this.m_DisplayName = string5;
        this.m_IoGroupId = n6;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_RedundancyId != Integer.MIN_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("REDUNDANCY_ID"), String.valueOf(this.m_RedundancyId));
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_NodeId != Integer.MIN_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_Wwn != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("WWN"), this.m_Wwn);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_IoGroupId != Integer.MIN_VALUE) {
            hashtable.put(RedundancySnapshot.getColumnInfo("IO_GROUP_ID"), String.valueOf(this.m_IoGroupId));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htColsAndValues.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")));
        if (hashtable.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")));
        if (hashtable.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = DBQueryAssistant.performRetrieve("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, this.htWhereClause, null);
        if (dBResultSet.next()) {
            this.setFields(dBConnection, dBResultSet);
            return true;
        }
        return false;
    }

    public static RedundancySnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        if (hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        hashtable2.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        hashtable2.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")));
        if (hashtable.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        hashtable2.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = DBQueryAssistant.performRetrieve("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, hashtable2, null);
        if (dBResultSet.next()) {
            RedundancySnapshot redundancySnapshot = new RedundancySnapshot();
            redundancySnapshot.setFields(dBConnection, dBResultSet);
            return redundancySnapshot;
        }
        return null;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnapshotId(dBResultSet.getInt("SNAPSHOT_ID"));
        this.setRedundancyId(dBResultSet.getInt("REDUNDANCY_ID"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setComponentId(dBResultSet.getString("COMPONENT_ID"));
        this.setIpAddress(dBResultSet.getString("IP_ADDRESS"));
        this.setNodeId(dBResultSet.getInt("NODE_ID"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setName(dBResultSet.getString("NAME"));
        this.setNameFormat(dBResultSet.getShort("NAME_FORMAT"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setWwn(dBResultSet.getString("WWN"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setIoGroupId(dBResultSet.getInt("IO_GROUP_ID"));
    }

    public static class RedundancySnapshotCursor
    extends DBCursor {
        private RedundancySnapshot element = new RedundancySnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public RedundancySnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_REDUNDANCY_SNAPSHOT", dBConnection, RedundancySnapshotCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public RedundancySnapshot getObject() throws SQLException {
            RedundancySnapshot redundancySnapshot = null;
            if (this.DBrs != null) {
                redundancySnapshot = new RedundancySnapshot();
                redundancySnapshot.setFields(this.con, this.DBrs);
            }
            return redundancySnapshot;
        }

        public RedundancySnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

