/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class InFlightScan {
    private String scanId;
    private String scanType;
    private int scannerClass;
    private int systemId;
    private int systemType = -1;
    private HashSet tableList;
    private boolean inUpdate;
    private Timestamp scanTime;
    private boolean isNew;
    private String processID;
    private static ILogger traceLogger;
    private static String className;
    private static boolean TRACE;

    static {
        Class<?> clazz;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        TRACE = false;
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }

    InFlightScan(String string, int n, int n2) {
        String string2 = "InFlightScan";
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " scanner id " + string + " systemId " + n);
        }
        this.scanId = string;
        this.systemId = n;
        this.systemType = n2;
        this.scanType = DetectabilityService.getTypeFromScanId(string);
        this.processID = "x" + string + Long.toString(System.currentTimeMillis());
        this.tableList = new HashSet();
        this.isNew = true;
        this.setLock();
    }

    public boolean isLocked() {
        return this.inUpdate;
    }

    public synchronized void setLock() {
        String string = "setLock";
        this.inUpdate = true;
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " setting lock for scanner " + this.scanId);
        }
    }

    public synchronized void resetLock() {
        String string = "resetLock";
        this.inUpdate = false;
        this.isNew = true;
        if (true) {
            this.isNew = false;
        }
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " resetting lock for scanner " + this.scanId);
        }
    }

    public int getScannerClass() {
        return this.scannerClass;
    }

    public void setScannerClass(int n) {
        String string = "setScannerClass";
        this.scannerClass = n;
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " setting scanner " + n + " for scanner " + this.scanId);
        }
    }

    public String getScanId() {
        return this.scanId;
    }

    public Timestamp getScanTime() {
        return this.scanTime;
    }

    /*
     * Exception decompiling
     */
    public void setScanTime() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 94->98)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getScanSystemID() {
        return this.systemId;
    }

    public String getProcessID() {
        return this.processID;
    }

    public void setProcessID(String string) {
        this.processID = string;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void addTable(String string) {
        this.tableList.add(string);
    }

    public void clearTables() {
        this.tableList.clear();
    }

    public HashSet getList() {
        return this.tableList;
    }

    public void replaceList(HashSet hashSet) {
        this.tableList = hashSet;
    }

    public String getScanType() {
        return this.scanType;
    }

    public void setScanType(String string) {
        this.scanType = string;
    }

    public int getSystemType() {
        return this.systemType;
    }
}

