/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DBTableMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperPackage;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.interfaces.IMapperRouterService;
import org.eclipse.aperi.util.UStack;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class MapperRouter
extends AbstractExtensionMgr
implements IMapperRouterService {
    public static final String SMIS102 = "1.0.2";
    public static final String SMIS103 = "1.0.3";
    public static final String SMIS11 = "1.1.0";
    public static final String DEVICE_1750 = "1750";
    public static final String DEVICE_2105 = "2105";
    public static final String DEVICE_2107 = "2107";
    public static final String DEVICE_2145 = "2145";
    public static final String DEVICE_3581 = "3581";
    public static final String DEVICE_3582 = "3582";
    public static final String DEVICE_3583 = "3583";
    public static final String DEVICE_3584 = "3584";
    public static final String DEVICE_3494 = "3494";
    public static final String DEVICE_GENERIC_TAPE_LIBRARY = "GENERIC_TAPE_LIBRARY";
    public static final String DEVICE_2109 = "2109";
    public static final String AGENT_11 = "1.1";
    public static final String AGENT_111 = "1.1.1";
    public static final String AGENT_12 = "1.2";
    public static final String AGENT_21 = "2.1";
    public static final String AGENT_51 = "5.1";
    private Hashtable<String, IDBAttributeMapper> htMapperInstances = new Hashtable();
    private static final String EXTENSION_POINT_ID = "org.eclipse.aperi.common.dbAttributeMapper";
    public static final String ATTR_IMPL = "impl";
    public static final String ELEMENT_SMISDBMAPPERREGISTRATIONDATA = "SMISMapperRegistrationData";
    public static final String ATTR_CIMCLASSNAME = "CIMClassName";
    public static final String ATTR_SMISVERSION = "SMISVersion";
    public static final String ATTR_DEVICETYPE = "DeviceType";
    public static final String ATTR_SMISPROVIDERVERION = "SMISProviderVersion";
    public static final String ATTR_DEDICATED = "Dedicated";
    private static MapperRouter stRouter = new MapperRouter();
    private static Boolean stIsScanned = new Boolean(false);
    private static String stPackageFileSep = "com" + File.separator + "ibm" + File.separator + "tpc" + File.separator + "infrastructure" + File.separator + "mapping";
    private Map cMapperMap1 = new HashMap();
    private Map cMapperMap2;

    private static Map getInnerMap(Map map, String string) {
        Map map2;
        if (map.containsKey(string)) {
            map2 = (Map)map.get(string);
        } else {
            map2 = new HashMap();
            map.put(string, map2);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapperRouter getMapperRouter() {
        Boolean bl = stIsScanned;
        synchronized (bl) {
            if (!stIsScanned.booleanValue()) {
                stRouter.registerMappers();
                stRouter.initialize();
                String[] stringArray = stRouter.getAllExtensionIds();
                int n = 0;
                while (n < stringArray.length) {
                    stRouter.extensionAdded(stringArray[n]);
                    ++n;
                }
                stIsScanned = new Boolean(true);
            }
        }
        return stRouter;
    }

    private MapperRouter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.cMapperMap1;
        synchronized (map) {
            this.cMapperMap1.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findBestMatch(Map map, UStack uStack, MatchGauge matchGauge) {
        Map map2 = this.cMapperMap1;
        synchronized (map2) {
            boolean bl;
            boolean bl2;
            String string;
            block8: {
                string = (String)uStack.pop();
                bl2 = map.containsKey(string);
                bl = map.containsKey(null);
                if (bl2 || bl) break block8;
                matchGauge.markMismatch();
                return null;
            }
            if (uStack.empty()) {
                if (!bl2) {
                    matchGauge.countGenericMatch();
                    return map.get(null);
                }
                matchGauge.countPreciseMatch();
                return map.get(string);
            }
            if (!bl2) {
                return this.findBestMatch((HashMap)map.get(null), uStack, matchGauge.countGenericMatch());
            }
            if (!bl) {
                return this.findBestMatch((HashMap)map.get(string), uStack, matchGauge.countPreciseMatch());
            }
            MatchGauge matchGauge2 = new MatchGauge();
            MatchGauge matchGauge3 = new MatchGauge();
            Object object = this.findBestMatch((HashMap)map.get(null), new UStack(uStack), matchGauge2.countGenericMatch());
            Object object2 = this.findBestMatch((HashMap)map.get(string), new UStack(uStack), matchGauge3.countPreciseMatch());
            matchGauge.concat(matchGauge3.less(matchGauge2) ? matchGauge2 : matchGauge3);
            return matchGauge3.less(matchGauge2) ? object : object2;
        }
    }

    public IDBAttributeMapper findMapper(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = "21";
        String string8 = "22";
        Vector vector = null;
        if (string5 != null) {
            vector = DBAttributeMapper.processArrayvalues(string5);
        }
        Object object = null;
        int n = 0;
        while (object == null && string != null && n < 5) {
            ++n;
            object = this.retrieveMapper(string, string2, string3, string4, vector);
            string = DBTableMapper.getLookup(string, string5);
        }
        if (object == null && string5 != null && string6 != null) {
            object = vector.contains(string7) || vector.contains("0") ? this.retrieveMapper(string6, string2, string3, string4, vector) : (vector.contains(string8) && string6.equals("CIM_ComputerSystem") ? this.retrieveMapper("CIM_ComputerSystem", string2, string3, string4, vector) : this.retrieveMapper(string6, string2, string3, string4, vector));
        } else if (object == null && string5 == null && string6 != null) {
            object = this.retrieveMapper(string6, string2, string3, string4, string5);
        }
        if (object != null) {
            try {
                IDBAttributeMapper iDBAttributeMapper;
                Class<?> clazz;
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (object.getClass().getName().equals(clazz.getName())) {
                    iDBAttributeMapper = (DBAttributeMapper)this.htMapperInstances.get((String)object);
                    if (iDBAttributeMapper == null) {
                        iDBAttributeMapper = (IDBAttributeMapper)this.getExtensionImpl((String)object, false);
                        this.htMapperInstances.put((String)object, iDBAttributeMapper);
                    }
                } else {
                    Class clazz2 = (Class)object;
                    String string9 = clazz2.getName();
                    iDBAttributeMapper = (DBAttributeMapper)this.htMapperInstances.get(string9);
                    if (iDBAttributeMapper == null) {
                        iDBAttributeMapper = (DBAttributeMapper)clazz2.newInstance();
                        this.htMapperInstances.put(string9, iDBAttributeMapper);
                    }
                }
                return iDBAttributeMapper;
            }
            catch (ExtensionException extensionException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return null;
    }

    public IDBAttributeMapper findMapper(String string, String string2, String string3, String string4) {
        return this.findMapper(string, string2, string3, string4, null, null);
    }

    public IDBAttributeMapper findMapper(String string, String string2, String string3, String string4, String string5) {
        return this.findMapper(string, string2, string3, string4, string5, null);
    }

    private Object retrieveMapper(String string, String string2, String string3, String string4, String string5) {
        UStack uStack = new UStack();
        uStack.push(string);
        uStack.push(string2);
        uStack.push(string3);
        uStack.push(string4);
        uStack.push(string5);
        Object object = this.findBestMatch(this.cMapperMap1, uStack, new MatchGauge());
        return object;
    }

    private Object retrieveMapper(String string, String string2, String string3, String string4, Vector vector) {
        Object object = null;
        if (vector == null) {
            return this.retrieveMapper(string, string2, string3, string4, (String)null);
        }
        int n = 0;
        while (n < vector.size()) {
            object = this.retrieveMapper(string, string2, string3, string4, (String)vector.get(n));
            if (object != null) break;
            ++n;
        }
        return object;
    }

    public DBAttributeMapper.RegistrationData[] getRegisteredProcesses() {
        ArrayList arrayList = this.recurseRequests(this.cMapperMap1, new UStack());
        return arrayList.toArray(new DBAttributeMapper.RegistrationData[arrayList.size()]);
    }

    public DBAttributeMapper.RegistrationData[] getRegisteredProcessNames() {
        ArrayList arrayList = this.recurseRequests(this.cMapperMap1, new UStack());
        return arrayList.toArray(new DBAttributeMapper.RegistrationData[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList recurseRequests(Map map, UStack uStack) {
        ArrayList<DBAttributeMapper.RegistrationData> arrayList = new ArrayList<DBAttributeMapper.RegistrationData>();
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                uStack.push(entry.getKey());
                if (entry.getValue() instanceof Map) {
                    arrayList.addAll(this.recurseRequests((Map)entry.getValue(), uStack));
                } else {
                    UStack uStack2 = new UStack(uStack);
                    String string = (String)uStack2.pop();
                    String string2 = (String)uStack2.pop();
                    String string3 = (String)uStack2.pop();
                    String string4 = (String)uStack2.pop();
                    String string5 = (String)uStack2.pop();
                    DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4, string5);
                    arrayList.add(registrationData);
                }
                uStack.pop();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerMapperWithParameters(Class clazz) throws InvalidClassException {
        DBAttributeMapper.RegistrationData[] registrationDataArray;
        Class<?> clazz2;
        Class clazz3 = clazz;
        do {
            if ((clazz3 = clazz3.getSuperclass()) == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                throw new InvalidClassException(clazz.getName(), "Class doesn't extend " + clazz4.getName());
            }
            try {
                clazz2 = Class.forName("org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (!clazz3.equals(clazz2));
        try {
            Method method = clazz.getMethod("getRegistrationData", new Class[0]);
            registrationDataArray = (DBAttributeMapper.RegistrationData[])method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new InvalidClassException(clazz.getName(), "Class doesn't implement getRegistrationData() properly.");
        }
        int n = 0;
        while (n < registrationDataArray.length) {
            UStack uStack = new UStack();
            uStack.push(registrationDataArray[n].getCIMClassName());
            uStack.push(registrationDataArray[n].getSmisVersion());
            uStack.push(registrationDataArray[n].getDeviceType());
            uStack.push(registrationDataArray[n].getInstrumentationVersion());
            uStack.push(registrationDataArray[n].getDedicated());
            Map map = this.cMapperMap1;
            synchronized (map) {
                String string = (String)uStack.pop();
                Map map2 = this.cMapperMap1;
                while (!uStack.empty()) {
                    map2 = MapperRouter.getInnerMap(map2, string);
                    string = (String)uStack.pop();
                }
                if (map2.containsKey(string)) {
                    throw new IllegalArgumentException("Pattern already registered.");
                }
                map2.put(string, clazz);
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerMapperWithName(String string, Class clazz) throws InvalidClassException {
        Class<?> clazz2;
        Class clazz3 = clazz;
        do {
            if ((clazz3 = clazz3.getSuperclass()) == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                throw new InvalidClassException(clazz.getName(), "Class doesn't extend " + clazz4.getName());
            }
            try {
                clazz2 = Class.forName("org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (!clazz3.equals(clazz2));
        Map map = this.cMapperMap2;
        synchronized (map) {
            if (this.cMapperMap2.containsKey(string)) {
                throw new IllegalArgumentException("Name already registered.");
            }
            this.cMapperMap2.put(string, clazz);
        }
        return true;
    }

    private void registerMappers() {
        ArrayList arrayList = MapperPackage.getPackage().getMapperClasses();
        int n = 0;
        while (n < arrayList.size()) {
            try {
                this.registerMapperWithParameters((Class)arrayList.get(n));
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        MapperRouter mapperRouter = MapperRouter.getMapperRouter();
        mapperRouter.generateMapperPackage();
    }

    private void generateMapperPackage() {
        ArrayList arrayList = this.scanPackage();
        String string = "com" + File.separator + "ibm" + File.separator + "tpc" + File.separator + "infrastructure" + File.separator + "mapping";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(String.valueOf(string) + File.separator + "MapperPackage.java"));
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("/** \n* (C) Copyright IBM Corp. 2006* All rights reserved. This program and the accompanying materials\n* are made available under the terms of the Eclipse Public License v1.0\n* which accompanies this distribution, and is available at\n* http://www.eclipse.org/legal/epl-v10.html\n */\n");
            printWriter.println("");
            printWriter.println("package org.eclipse.aperi.infrastructure.mapping;");
            printWriter.println("");
            printWriter.println("import java.util.ArrayList;");
            printWriter.println("");
            printWriter.println("public class MapperPackage {");
            printWriter.println("");
            printWriter.println("   private static ArrayList cMappers = new ArrayList();");
            printWriter.println("");
            printWriter.println("   private static MapperPackage stMapperPackage = new MapperPackage();");
            printWriter.println("");
            printWriter.println("   public static MapperPackage getPackage() {");
            printWriter.println("      return stMapperPackage;");
            printWriter.println("   } ");
            printWriter.println("");
            printWriter.println("   private MapperPackage() {");
            int n = 0;
            while (n < arrayList.size()) {
                printWriter.println("      cMappers.add(" + arrayList.get(n) + ".class);");
                ++n;
            }
            printWriter.println("   }");
            printWriter.println("");
            printWriter.println("   public ArrayList getMapperClasses() {");
            printWriter.println("      return cMappers;");
            printWriter.println("   }");
            printWriter.println("");
            printWriter.println("}");
            printWriter.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    private ArrayList scanPackage() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ClassLoader.getSystemResource(stPackageFileSep).getPath();
        File file = new File(string);
        String[] stringArray = file.list();
        String string2 = String.valueOf(this.getClass().getPackage().getName()) + ".DBAttributeMapper";
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n].substring(0, stringArray[n].indexOf("."));
            String string4 = stringArray[n].substring(stringArray[n].indexOf(".") + 1);
            if (string4.equals("class") && string3.indexOf(36) == -1) {
                boolean bl = false;
                try {
                    Class<?> clazz = Class.forName(String.valueOf(this.getClass().getPackage().getName()) + "." + string3);
                    clazz.getName();
                    Class<?> clazz2 = clazz;
                    while (clazz2.getName() != "java.lang.Object" && !bl) {
                        String string5 = (clazz2 = clazz2.getSuperclass()).getName();
                        if (!string5.equals(string2)) continue;
                        arrayList.add(string3);
                        bl = true;
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return arrayList;
    }

    public String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    protected void extensionAdded(String string) {
        this.handleDBAttributeMapperExtension(string, true);
    }

    protected void extensionRemoved(String string) {
        this.handleDBAttributeMapperExtension(string, false);
    }

    private void handleDBAttributeMapperExtension(String string, boolean bl) {
        IConfigurationElement[] iConfigurationElementArray;
        IExtension iExtension = this.getExtension(string);
        if (iExtension != null && (iConfigurationElementArray = iExtension.getConfigurationElements()) != null) {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[0].getChildren(ELEMENT_SMISDBMAPPERREGISTRATIONDATA);
            int n = 0;
            while (n < iConfigurationElementArray2.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n];
                this.registerDBAttributeMapperExtension(string, iConfigurationElement, bl);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDBAttributeMapperExtension(String string, IConfigurationElement iConfigurationElement, boolean bl) {
        if (ELEMENT_SMISDBMAPPERREGISTRATIONDATA.equals(iConfigurationElement.getName())) {
            UStack uStack = new UStack();
            uStack.push(iConfigurationElement.getAttribute(ATTR_CIMCLASSNAME));
            uStack.push(iConfigurationElement.getAttribute(ATTR_SMISVERSION));
            uStack.push(iConfigurationElement.getAttribute(ATTR_DEVICETYPE));
            uStack.push(iConfigurationElement.getAttribute(ATTR_SMISPROVIDERVERION));
            uStack.push(iConfigurationElement.getAttribute(ATTR_DEDICATED));
            Map map = this.cMapperMap1;
            synchronized (map) {
                String string2 = (String)uStack.pop();
                Map map2 = this.cMapperMap1;
                while (!uStack.empty()) {
                    map2 = MapperRouter.getInnerMap(map2, string2);
                    string2 = (String)uStack.pop();
                }
                if (map2.containsKey(string2)) {
                    throw new IllegalArgumentException("Pattern already registered.");
                }
                map2.put(string2, string);
            }
        } else {
            throw new IllegalArgumentException("No SMISMapperRegistrationData Extensionelement passed.");
        }
    }

    private static final class MatchGauge {
        private int mPreciseMatchCount;
        private int mLevel;
        private int mMatchPattern;

        public MatchGauge() {
            this.mPreciseMatchCount = 0;
            this.mLevel = 0;
            this.mMatchPattern = 0;
        }

        public MatchGauge(MatchGauge matchGauge) {
            this.mPreciseMatchCount = matchGauge.mPreciseMatchCount;
            this.mLevel = matchGauge.mLevel;
            this.mMatchPattern = matchGauge.mMatchPattern;
        }

        public MatchGauge countPreciseMatch() {
            ++this.mLevel;
            ++this.mPreciseMatchCount;
            this.mMatchPattern += 1 << this.mLevel;
            return this;
        }

        public MatchGauge countGenericMatch() {
            ++this.mLevel;
            return this;
        }

        public void markMismatch() {
            this.mPreciseMatchCount = -1;
        }

        public MatchGauge concat(MatchGauge matchGauge) {
            if (matchGauge.mPreciseMatchCount == -1) {
                this.markMismatch();
            } else {
                this.mPreciseMatchCount += matchGauge.mPreciseMatchCount;
                this.mMatchPattern += matchGauge.mMatchPattern << this.mLevel;
                this.mLevel += matchGauge.mLevel;
            }
            return this;
        }

        public boolean less(MatchGauge matchGauge) {
            return this.mPreciseMatchCount != matchGauge.mPreciseMatchCount ? this.mPreciseMatchCount < matchGauge.mPreciseMatchCount : this.mMatchPattern < matchGauge.mMatchPattern;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(this.mPreciseMatchCount);
            stringBuffer.append(',');
            stringBuffer.append(this.mMatchPattern);
            stringBuffer.append(',');
            stringBuffer.append(this.mLevel);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

