/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_PhysicalMediaToDBMapper
extends DBAttributeMapper {
    protected static final String SERIALNUMBER = "serialnumber";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "CIM_PhysicalMedia";
        String string2 = "1.0.2";
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        string2 = "1.0.3";
        DBAttributeMapper.RegistrationData registrationData2 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        string2 = "1.1.0";
        DBAttributeMapper.RegistrationData registrationData3 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData, registrationData2, registrationData3};
    }

    public SMISCIM_PhysicalMediaToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion("removeable", "Boolean");
        this.m_htAttribToMapperInfo.put("removeable", new MapperInfo(PhysicalVolume.getColumnInfo("REMOVABLE_MEDIUM")));
        this.m_htAttribToMapperInfo.put(SERIALNUMBER, new MapperInfo(PhysicalVolume.getColumnInfo("SERIAL_NUMBER")));
        this.m_dataConverter.addCalculationDataConversion("capacity", "/", "512");
        this.m_htAttribToMapperInfo.put("capacity", new MapperInfo(PhysicalVolume.getColumnInfo("CAPACITY")));
        this.m_htAttribToMapperInfo.put("manufacturedate", new MapperInfo(PhysicalVolume.getColumnInfo("MANUFACTURE_DATE")));
        this.m_htAttribToMapperInfo.put("tag", new MapperInfo(PhysicalVolume.getColumnInfo("TAG")));
        this.m_htAttribToMapperInfo.put("manufacturer", new MapperInfo(PhysicalVolume.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put("model", new MapperInfo(PhysicalVolume.getColumnInfo("MODEL_ID")));
        this.m_htAttribToMapperInfo.put("ref_diskgroup_id", new MapperInfo(PhysicalVolume.getColumnInfo("DISK_GROUP_ID")));
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(PhysicalVolume.getColumnInfo("SUBSYSTEM_ID")));
        ColumnInfo columnInfo = PhysicalVolume.getColumnInfo("DEVICE_ID");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("ref_physicalvolume_device_id", mapperInfo);
        ColumnInfo columnInfo3 = PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID");
        columnInfo3.setIsPrimaryKey();
        MapperInfo mapperInfo2 = new MapperInfo(columnInfo3);
        this.m_htAttribToMapperInfo.put("ref_physicalvolume_system_names_id", mapperInfo2);
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        String string2;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        String string3 = (String)hashtable.get("manufacturedate");
        if (string3 != null) {
            string2 = String.valueOf(string3.substring(0, 4)) + "-" + string3.substring(4, 6) + "-" + string3.substring(6, 8) + " " + string3.substring(8, 10) + ":" + string3.substring(10, 12) + ":" + string3.substring(12, 14) + "." + string3.substring(15, 21) + string3.substring(22);
            hashtable.put("manufacturedate", string2);
        }
        if ((string2 = (String)hashtable.get("ref_physicalvolume_system_names_id")) != null) {
            string2 = Normalizer.SystemNamesGetName(dBConnection, Short.parseShort(string2));
            hashtable.put("ref_physicalvolume_system_names_id", string2);
        }
        MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
        return mapperResult;
    }
}

