/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.LogConfigRequest;
import org.eclipse.aperi.logging.NativeLogManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;

public class LogConfigHandler {
    public static void handle(Request request, Response response) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.logging.LogConfigHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "handle", "request, response");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.logging.LogConfigRequest");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (RequestChecker.isDesiredType(clazz, request, response)) {
            LogConfigRequest logConfigRequest = (LogConfigRequest)request.requestData;
            try {
                if (logConfigRequest.doSet) {
                    TraceLoggerFactory.setTraceConfig(logConfigRequest.configMap, logConfigRequest.requestCode);
                    NativeLogManager.setTraceConfig(logConfigRequest.configMap, logConfigRequest.requestCode);
                } else {
                    response.responseData = TraceLoggerFactory.getTraceConfig(logConfigRequest.requestCode);
                }
                response.status = 0;
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.logging.LogConfigHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception(clazz3.getName(), "handle", localizableException);
                }
                response.errorMessage = localizableException.getMessage();
                response.status = (short)12;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.logging.LogConfigHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz4.getName(), "handle");
        }
    }
}

