/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SocketRegistry {
    private static boolean isActive;
    private static List registeredSockets;

    static {
        SocketRegistry.activate();
    }

    public static void activate() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.request.SocketRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "activate", "");
        }
        registeredSockets = new LinkedList();
        isActive = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.request.SocketRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deactivate() {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "deactivate", "");
        }
        if (!isActive) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz3.getName(), "deactivate");
            }
            return;
        }
        List list = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.request.SocketRegistry");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Object object = clazz;
        synchronized (clazz) {
            boolean bl = isActive;
            if (bl) {
                isActive = false;
                list = registeredSockets;
                registeredSockets = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bl && list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    Socket socket = (Socket)object.next();
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        Class<?> clazz4;
                        if (!TraceLogger.enableTrace) continue;
                        try {
                            clazz4 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception(clazz4.getName(), "deactivate", iOException);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz5.getName(), "deactivate");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Socket connect(String string, int n) throws UnknownHostException {
        Class<?> clazz;
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "connect", "host, port");
        }
        Socket socket = null;
        if (!isActive) {
            Class<?> clazz3;
            Socket socket2 = socket;
            if (!TraceLogger.enableTrace) return socket2;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz3.getName(), "connect", socket2);
            return socket2;
        }
        try {
            socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            Class<?> clazz4;
            if (TraceLogger.enableTrace) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz5.getName(), "connect", unknownHostException);
            }
            if (!TraceLogger.enableTrace) throw unknownHostException;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz4.getName(), "connect");
            throw unknownHostException;
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz6;
                try {
                    clazz6 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz6.getName(), "connect", iOException);
            }
            MessageLog.logException("GEN0040E", iOException, string, new Integer(n));
        }
        if (socket != null) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            object = clazz7;
            // MONITORENTER : clazz7
            if (isActive) {
                registeredSockets.add(socket);
            } else {
                block31: {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        Class<?> clazz8;
                        if (!TraceLogger.enableTrace) break block31;
                        try {
                            clazz8 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception(clazz8.getName(), "connect", iOException);
                    }
                }
                socket = null;
            }
            // MONITOREXIT : object
        }
        object = socket;
        if (!TraceLogger.enableTrace) return object;
        try {
            clazz = Class.forName("org.eclipse.aperi.request.SocketRegistry");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit(clazz.getName(), "connect", object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Socket socket) throws IOException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "close", "socket");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.request.SocketRegistry");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Class<?> clazz3 = clazz;
        synchronized (clazz) {
            if (isActive) {
                registeredSockets.remove(socket);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            socket.close();
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.request.SocketRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz4.getName(), "close");
            }
            return;
        }
    }
}

