/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.dbconnparms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.cmdline.BlockFormatter;
import org.eclipse.aperi.sanmgmt.dbconnparms.DBAccess;
import org.eclipse.aperi.sanmgmt.dbconnparms.data.DBConnPoolParms;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.util.GlobalProperties;

public class ConfigService
implements IConfigService,
IService,
ICliDispatcher {
    private static final long serialVersionUID = 20001130L;
    private static String className = "ConfigService";
    private DBConnPoolParms dbPoolParms = new DBConnPoolParms();
    private Properties dbProps = new Properties();
    private Properties setupProps = new Properties();
    private Properties userProps = new Properties();
    private Properties internalProps = new Properties();
    private Properties schedulerProps = new Properties();
    private Properties allTpcProps = new Properties();
    protected static ILogger traceLogger = null;
    protected static ILogger messageLogger = null;
    static final String TRACE_NAME = "aperi.logger.trace.dbparms";
    static final String MESSAGE_NAME = "aperi.logger.message.dbparms";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.dbconnparms.resources.SANDBParmsService";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.dbconnparms.resources.SANDBParmsText";
    private ResourceBundle rb = null;
    private static final String description = "Generic services for getting and saving application properties";
    public Status status = new Status(5, 9);
    public String propBaseFn = null;
    private boolean isManager = false;
    private Hashtable registerTable = new Hashtable();
    public static final String dbFile = "tsnmdbparms.properties";
    public static final String userFile = "user.properties";
    public static final String setupFile = "setup.properties";
    public static final String internalFile = "internal.properties";

    public native int[] exec(String var1, String[] var2, String[] var3, String var4, String var5, String var6, int var7, boolean var8, boolean var9);

    public ConfigService() {
        this.rb = ResourceBundle.getBundle(TEXT_BUNDLENAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        messageLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        messageLogger.setMessageFile(BUNDLENAME);
        className = this.getClass().getName();
    }

    public String getName() {
        return "ConfigService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("ConfigService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("ConfigService_Description");
    }

    public DBConnPoolParms getParms() {
        return this.dbPoolParms;
    }

    public String getVersion() {
        return "5.0.0";
    }

    private void updateDB(String string, String string2) throws SQLException {
        DBAccess dBAccess = new DBAccess();
        dBAccess.updateDB(string, string2, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readConnectionProps(String var1_1, Properties var2_2) {
        block18: {
            if (ConfigService.traceLogger.isLogging()) {
                ConfigService.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "readConnectionProps", "entered");
            }
            var3_3 = 0;
            var4_4 = null;
            try {
                try {
                    if (this.isManager && (var1_1 == null || var1_1.length() == 0)) {
                        var5_5 = new DBAccess();
                        var5_5.getProperties(null, var2_2);
                    } else if (new File(var1_1).exists()) {
                        var4_4 = new FileInputStream(var1_1);
                        var2_2.load(var4_4);
                    }
                    if (ConfigService.traceLogger.isLogging()) {
                        var5_5 = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbPassword");
                        if (var5_5 != null) {
                            this.dbProps.put("tivoli.sanmgmt.jdbc.dbPassword", "********");
                        }
                        var6_7 = var2_2.keySet().iterator();
                        while (true) {
                            if (!var6_7.hasNext()) {
                                if (var5_5 == null) break;
                                this.dbProps.put("tivoli.sanmgmt.jdbc.dbPassword", var5_5);
                                break;
                            }
                            var7_8 = (String)var6_7.next();
                            var8_9 = var2_2.getProperty(var7_8);
                            ConfigService.traceLogger.text(IRecordType.TYPE_MISC_DATA, this, "readConnectionProps", "SAN DB Connection parm: " + var7_8 + " = " + var8_9);
                        }
                    }
                    ConfigService.messageLogger.message(IRecordType.TYPE_INFO, (Object)ConfigService.className, "readConnectionProps", "DBParms_successfulReadingParms", var1_1);
                }
                catch (Exception var5_6) {
                    ConfigService.messageLogger.message(IRecordType.TYPE_ERR, (Object)ConfigService.className, "readConnectionProps", "DBParms_errorReadingParms", var1_1);
                    ConfigService.messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "readConnectionProps", var5_6);
                    var3_3 = -1;
                }
            }
            catch (Throwable var10_10) {
                var9_11 = null;
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (Exception var11_13) {
                        ConfigService.messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "readConnectionProps", var11_13);
                    }
                }
                var4_4 = null;
                if (ConfigService.traceLogger.isLogging() == false) throw var10_10;
                ConfigService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "readConnectionProps", "exited");
                throw var10_10;
            }
            {
                var9_12 = null;
                if (var4_4 == null) break block18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 324->332)] { 
lbl55:
            // 1 sources

            var4_4.close();
            break block18;
lbl57:
            // 1 sources

            catch (Exception var11_14) {
                ConfigService.messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "readConnectionProps", var11_14);
            }
        }
        var4_4 = null;
        if (ConfigService.traceLogger.isLogging() == false) return var3_3;
        ConfigService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "readConnectionProps", "exited");
        return var3_3;
    }

    public boolean shutdown() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "shutdown", "entered");
        }
        this.status.setRunStatus(11);
        if (this.isManager) {
            DBAccess dBAccess = new DBAccess();
            dBAccess.closeDS();
        }
        this.status.setRunStatus(10);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "shutdown", "exited");
        }
        return true;
    }

    public boolean startup() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "startup", "entered");
        }
        boolean bl = true;
        this.propBaseFn = String.valueOf(Variables.getConfigurationDirectory()) + "/";
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, this, "startup", "reading parms from " + this.propBaseFn);
        }
        int n = this.readConnectionProps(String.valueOf(this.propBaseFn) + setupFile, this.setupProps);
        this.processSetupParms();
        this.readConnectionProps(String.valueOf(this.propBaseFn) + userFile, this.userProps);
        this.processUserParms();
        String string = this.setupProps.getProperty("tsnm.type", "");
        if (string.equals("manager")) {
            this.isManager = true;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.isManager) {
            n2 = this.readConnectionProps(String.valueOf(this.propBaseFn) + dbFile, this.dbProps);
            this.processDBParms();
            new DBAccess();
            n3 = this.readConnectionProps(String.valueOf(this.propBaseFn) + internalFile, this.internalProps);
            this.processInternalParms();
            n4 = this.readConnectionProps(null, this.allTpcProps);
        }
        if (n + n2 + n3 + n4 != 0) {
            this.status.setRunStatus(2);
            bl = false;
        } else {
            this.status.setRunStatus(8);
            messageLogger.message(IRecordType.TYPE_INFO, this, "startup", "SANDBParmsService_ready");
        }
        if (this.isManager) {
            String string2 = this.getProperty("server_id", "database");
            String string3 = this.getProperty("installationPass", "setup");
            DBAccess dBAccess = new DBAccess();
            dBAccess.syncInstallPassword(string2, string3);
            this.setCIMClientProperties();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "startup", "exiting");
        }
        return bl;
    }

    private void setFabricProperties(String string, String string2, String string3) {
        block9: {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setFabricProperties", "entered");
            }
            if (this.isManager && (string == null || string.trim().length() == 0)) {
                try {
                    this.updateDB(string2, string3);
                }
                catch (SQLException sQLException) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "setFabricProperties-updateDB", sQLException);
                    }
                    break block9;
                }
            }
            File file = new File(string);
            if (file.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    properties.setProperty(string2, string3);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    properties.store(fileOutputStream, "Fabric properties file");
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    if (!traceLogger.isLogging()) break block9;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(setAuthenticationPw)", exception);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setFabricProperties", "exited");
        }
    }

    public String setAuthenticationPw(String string) {
        String string2;
        block5: {
            string2 = "";
            System.getProperty("default.appdir", "");
            int n = 0;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setAuthenticationPw", "entered");
            }
            try {
                String string3 = SRMCrypto.encrypt(string);
                ++n;
                this.setProperty("installationPass", "setup", string3);
                ++n;
                MiddlewareCrypto.setPassword(string3);
                String string4 = this.getProperty("server_id", "database");
                if (this.isManager) {
                    DBAccess dBAccess = new DBAccess();
                    dBAccess.syncInstallPassword(string4, string3);
                }
                string2 = this.rb.getString("installationPass_OK");
            }
            catch (Exception exception) {
                string2 = n > 1 ? this.rb.getString("setAuthNotOK2") : this.rb.getString("setAuthNotOK1");
                if (!traceLogger.isLogging()) break block5;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(setAuthenticationPw)", exception);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setAuthenticationPw", "exited");
        }
        return string2;
    }

    private String setPw(String string) {
        String string2;
        block4: {
            string2 = "";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setPw", "entered");
            }
            try {
                String string3 = SRMCrypto.encrypt(string);
                this.setProperty("tivoli.sanmgmt.jdbc.dbPassword", "database", string3);
                this.dbPoolParms.setPassword(string3);
                string2 = this.rb.getString("setOk");
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(setPw)", exception);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setPw", "exited");
        }
        return string2;
    }

    private String setSinglePw(String[] stringArray) {
        String string = stringArray[0].toLowerCase();
        String string2 = this.rb.getString("invalid");
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setSinglePw", "entered");
        }
        if (string.equals("-all")) {
            string2 = this.setAuthenticationPw(stringArray[1]);
            string2 = this.isManager ? String.valueOf(string2) + "\n" + this.setPw(stringArray[1]) : String.valueOf(string2) + "\n" + this.rb.getString("notManager");
        }
        if (string.equals("-db2")) {
            string2 = this.setPw(stringArray[1]);
        }
        if (string.equals("-auth")) {
            string2 = this.setAuthenticationPw(stringArray[1]);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setSinglePw", "exited");
        }
        return string2;
    }

    private String setPassword(String string, String[] stringArray) {
        String string2 = "";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setPassword", "entered");
        }
        if (string.toLowerCase().equals("setauthenticationpw")) {
            string2 = stringArray.length != 1 ? this.rb.getString("invalid") : this.setAuthenticationPw(stringArray[0]);
        }
        if (string.toLowerCase().equals("setpw")) {
            string2 = stringArray.length != 1 ? this.rb.getString("invalid") : this.setPw(stringArray[0]);
        }
        if (string.toLowerCase().equals("setsinglepw")) {
            string2 = stringArray.length != 2 ? this.rb.getString("invalid") : this.setSinglePw(stringArray);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setPassword", "exited");
        }
        return string2;
    }

    public String dispatch(String string, String[] stringArray) {
        String string2;
        block32: {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "dispatch", "entered");
            }
            string2 = "";
            if ((string = string.toLowerCase()).equals("setauthenticationpw")) {
                string2 = this.setPassword(string, stringArray);
            } else {
                block33: {
                    if (string.equals("help")) {
                        try {
                            BlockFormatter blockFormatter = new BlockFormatter();
                            String[] stringArray2 = new String[]{"display", this.rb.getString("help5")};
                            String[] stringArray3 = new String[]{"get", this.rb.getString("help6")};
                            String[] stringArray4 = new String[]{"set", String.valueOf(this.rb.getString("help7")) + " " + this.rb.getString("valid")};
                            String[] stringArray5 = new String[]{"setPw", this.rb.getString("help9")};
                            String[] stringArray6 = new String[]{"setAuthenticationPw", this.rb.getString("help11")};
                            String[] stringArray7 = new String[]{"setSinglePw", this.rb.getString("help13")};
                            int[] nArray = new int[]{20, 53};
                            string2 = String.valueOf(this.rb.getString("header")) + "\n" + this.rb.getString("header1") + "\n" + "\n" + this.rb.getString("help") + "\n" + this.rb.getString("help1") + "\n" + this.rb.getString("help2") + "\n" + this.rb.getString("help3") + "\n" + this.rb.getString("help8") + "\n" + this.rb.getString("help10") + "\n" + this.rb.getString("help12") + "\n" + "\n" + this.rb.getString("help15") + "\n" + "\n" + this.rb.getString("help4") + "\n" + blockFormatter.format(stringArray2, nArray) + blockFormatter.format(stringArray3, nArray) + blockFormatter.format(stringArray4, nArray) + blockFormatter.format(stringArray5, nArray) + blockFormatter.format(stringArray6, nArray) + blockFormatter.format(stringArray7, nArray);
                        }
                        catch (Exception exception) {
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(help)", exception);
                            }
                            break block32;
                        }
                    }
                    if (this.isManager) {
                        if (string.equals("set")) {
                            if (stringArray.length != 2) {
                                string2 = this.rb.getString("invalid");
                            } else {
                                String string3 = stringArray[0].toLowerCase();
                                if (string3.equals("snmptrapport") || string3.equals("hostpollinginterval") || string3.equals("snmpcommunityname") || string3.equals("fullattributescan") || string3.equals("srmurl") || string3.equals("outbandagentmonitorinterval") || string3.equals("snmpwritecommunityname") || string3.equals("snmpdefaults") || string3.equals("snmptimeouttracing") || string3.equals("snmptrace") || string3.equals("snmpretrycount") || string3.equals("snmpinitialtimeout") || string3.equals("performswitchping") || string3.equals("itsanmcapabilityscanretrycount") || string3.equals("itsanmqueryretrycount") || string3.equals("itsanmretrydelay")) {
                                    int n;
                                    String string4;
                                    boolean bl = true;
                                    if (string3.equals("fullattributescan")) {
                                        string4 = stringArray[1].toLowerCase();
                                        bl = string4.equals("never") || string4.equals("always") || string4.equals("pollnow") || string4.equals("timebased") || string4.equals("pollnowandtimebased");
                                    }
                                    if (string3.equals("performswitchping")) {
                                        string4 = stringArray[1].toLowerCase();
                                        bl = string4.equals("y") || string4.equals("n") || string4.equals("yes") || string4.equals("no");
                                    }
                                    if (string3.equals("snmptrace") || string3.equals("snmptimeouttracing")) {
                                        string4 = stringArray[1].toLowerCase();
                                        bl = string4.equals("on") || string4.equals("off");
                                    }
                                    string2 = bl ? ((n = this.setProperty(stringArray[0], "user", stringArray[1])) == 0 ? this.rb.getString("saved") : this.rb.getString("errorSaving")) : String.valueOf(this.rb.getString("badValue")) + " " + this.rb.getString("valid1");
                                } else {
                                    string2 = String.valueOf(this.rb.getString("badProperty")) + " " + this.rb.getString("valid");
                                }
                            }
                        } else if (string.equals("get")) {
                            if (stringArray.length != 1) {
                                string2 = this.rb.getString("invalid");
                            } else {
                                String string5 = this.getProperty(stringArray[0], "user");
                                string2 = String.valueOf(this.rb.getString("gotOk")) + string5;
                            }
                        } else {
                            if (string.equals("display")) {
                                try {
                                    int[] nArray = new int[]{40, 20};
                                    String string6 = null;
                                    String[] stringArray8 = new String[2];
                                    BlockFormatter blockFormatter = new BlockFormatter();
                                    string2 = String.valueOf(this.rb.getString("header")) + "\n" + this.rb.getString("header1") + "\n" + "\n" + this.rb.getString("displayHeader") + "\n";
                                    Enumeration<Object> enumeration = this.userProps.keys();
                                    while (enumeration.hasMoreElements()) {
                                        stringArray8[0] = string6 = enumeration.nextElement().toString();
                                        stringArray8[1] = this.userProps.getProperty(string6);
                                        string2 = String.valueOf(string2) + blockFormatter.format(stringArray8, nArray);
                                    }
                                    break block33;
                                }
                                catch (Exception exception) {
                                    if (traceLogger.isLogging()) {
                                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(display)", exception);
                                    }
                                    break block33;
                                }
                            }
                            if (string.equals("setpw") || string.equals("setsinglepw")) {
                                string2 = this.setPassword(string, stringArray);
                            } else if (string.equals("setsnmpdefaults")) {
                                int n = this.setProperty("SnmpTimeoutTracing", "user", "OFF");
                                n += this.setProperty("SnmpTrace", "user", "OFF");
                                n += this.setProperty("SnmpRetryCount", "user", "3");
                                n += this.setProperty("SnmpInitialTimeout", "user", "1000");
                                n += this.setProperty("PerformSwitchPing", "user", "NO");
                                n += this.setProperty("ITSANMCapabilityScanRetryCount", "user", "1");
                                n += this.setProperty("ITSANMQueryRetryCount", "user", "2");
                                string2 = (n += this.setProperty("ITSANMRetryDelay", "user", "100")) == 0 ? this.rb.getString("saved") : this.rb.getString("errorSaving");
                            } else {
                                string2 = this.rb.getString("badCommand");
                            }
                        }
                    } else {
                        string2 = this.rb.getString("notManager");
                    }
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "disptach", "exited");
                }
            }
        }
        return string2;
    }

    public void processSetupParms() {
    }

    public void processUserParms() {
    }

    public void processInternalParms() {
    }

    public void processDBParms() {
        int n;
        int n2;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "processDBParms", "entered");
        }
        try {
            n2 = Integer.parseInt(this.dbProps.getProperty("tivoli.sanmgmt.jdbc.conpool.min", "2"));
        }
        catch (Exception exception) {
            n2 = 2;
        }
        this.dbPoolParms.setPoolMin(n2);
        try {
            n = Integer.parseInt(this.dbProps.getProperty("tivoli.sanmgmt.jdbc.conpool.max", "10"));
        }
        catch (Exception exception) {
            n = 10;
        }
        this.dbPoolParms.setPoolMax(n);
        String string = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.database");
        this.dbPoolParms.setDbType(string);
        String string2 = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbDriver");
        this.dbPoolParms.setDriver(string2);
        String string3 = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbURL");
        this.dbPoolParms.setUrl(string3);
        boolean bl = false;
        String string4 = System.getProperty("os.name");
        traceLogger.text(IRecordType.TYPE_INFO, this, "processDBParms", string4);
        if (string4.toLowerCase().startsWith("linux")) {
            bl = true;
            traceLogger.text(IRecordType.TYPE_INFO, this, "processDBParms", "Linux Fabric Manager");
        } else {
            traceLogger.text(IRecordType.TYPE_INFO, this, "processDBParms", "Win or AIX Fabric Manager");
        }
        if (string.equalsIgnoreCase("db2") && !bl) {
            this.dbPoolParms.setAppDriver("COM.ibm.db2.jdbc.app.DB2Driver");
            if (this.dbPoolParms.getDriver().regionMatches(17, "app", 0, 3)) {
                this.dbPoolParms.setAppUrl(string3);
            } else {
                int n3 = string3.lastIndexOf(":");
                int n4 = string3.lastIndexOf("/");
                String string5 = String.valueOf(string3.substring(0, n3 + 1)) + string3.substring(n4 + 1);
                this.dbPoolParms.setAppUrl(string5);
            }
        } else {
            this.dbPoolParms.setAppDriver(string2);
            this.dbPoolParms.setAppUrl(string3);
        }
        this.dbPoolParms.setUser(this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbUser"));
        this.dbPoolParms.setSchema(this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbSchema"));
        String string6 = null;
        String string7 = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbPassword");
        try {
            if (string7 != null) {
                string6 = SRMCrypto.decrypt(string7);
            }
        }
        catch (Exception exception) {
            messageLogger.message(IRecordType.TYPE_ERR, className, "processDBParms", "DBParms_errorDecryptingPassword");
            messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "processDBParms", exception);
        }
        this.dbPoolParms.setPassword(string6);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "processDBParms", "exiting");
        }
    }

    public void processTpcParms() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int flush(Properties properties, String string) {
        int n = 0;
        if (this.isManager && (string == null || string.trim().length() == 0)) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return n;
                }
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)properties.get(string2);
                try {
                    this.updateDB(string2, string3);
                }
                catch (SQLException sQLException) {
                    n = -1;
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", sQLException);
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", sQLException);
                }
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(String.valueOf(this.propBaseFn) + string);
                properties.store(fileOutputStream, "Saved file");
            }
            catch (IOException iOException) {
                messageLogger.message(IRecordType.TYPE_ERR, (Object)className, "flush", "DBParms_errorSavingProperties", String.valueOf(this.propBaseFn) + string);
                messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", iOException);
                n = -1;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", iOException);
            }
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        try {}
        catch (IOException iOException) {
            messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", iOException);
            return n;
        }
        fileOutputStream.close();
        return n;
    }

    public String getDescription() {
        return description;
    }

    public Status getStatus() {
        return this.status;
    }

    public Properties getProperties(String string) {
        return (Properties)this.getPrivateProperties(string).clone();
    }

    private Properties getPrivateProperties(String string) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getPrivateProperties", "entered");
        }
        Properties properties = new Properties();
        if (string.equals("user")) {
            properties = this.userProps;
        } else if (string.equals("setup")) {
            properties = this.setupProps;
        } else if (string.equals("database")) {
            properties = this.dbProps;
        } else if (string.equals("internal")) {
            properties = this.internalProps;
        } else if (this.isManager) {
            DBAccess dBAccess = new DBAccess();
            properties = dBAccess.getProperties(string, properties);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getPrivateProperties", "exiting");
        }
        return properties;
    }

    public String getProperty(String string, String string2) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getProperty", "entered");
        }
        String string3 = null;
        String string4 = string;
        if (string2.equals("user")) {
            string4 = this.getPropertyName(this.userProps, string);
            string3 = this.userProps.getProperty(string4);
        } else if (string2.equals("setup")) {
            string4 = this.getPropertyName(this.setupProps, string);
            string3 = this.setupProps.getProperty(string4);
        } else if (string2.equals("database")) {
            string4 = this.getPropertyName(this.dbProps, string);
            string3 = this.dbProps.getProperty(string4);
        } else if (string2.equals("internal")) {
            string4 = this.getPropertyName(this.internalProps, string);
            string3 = this.internalProps.getProperty(string4);
        } else if (this.isManager) {
            string4 = this.getPropertyName(this.allTpcProps, string);
            DBAccess dBAccess = new DBAccess();
            string3 = dBAccess.readDB(string4);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getProperty", "exiting");
        }
        return string3;
    }

    public int setProperty(String string, String string2, String string3) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setProperty", "entered");
        }
        int n = -1;
        String string4 = string;
        if (string2.equals("user")) {
            string4 = this.getPropertyName(this.userProps, string);
            this.userProps.put(string4, string3);
            n = this.flush(this.userProps, userFile);
        } else if (string2.equals("setup")) {
            string4 = this.getPropertyName(this.setupProps, string);
            this.setupProps.put(string4, string3);
            n = this.flush(this.setupProps, setupFile);
        } else if (string2.equals("database")) {
            string4 = this.getPropertyName(this.dbProps, string);
            this.dbProps.put(string4, string3);
            n = this.flush(this.dbProps, dbFile);
        } else if (string2.equals("internal")) {
            string4 = this.getPropertyName(this.internalProps, string);
            this.internalProps.put(string4, string3);
            n = this.flush(this.internalProps, internalFile);
        } else if (this.isManager) {
            block16: {
                string4 = this.getPropertyName(this.allTpcProps, string);
                this.allTpcProps.put(string4, string3);
                DBAccess dBAccess = new DBAccess();
                n = 0;
                try {
                    dBAccess.updateDB(string4, string3, string2);
                }
                catch (SQLException sQLException) {
                    n = -1;
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "setProperty", sQLException);
                    if (!traceLogger.isLogging()) break block16;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "setProperty", sQLException);
                }
            }
            if (string2.equals("CIM")) {
                this.setCIMClientProperties();
            }
        } else {
            n = -2;
        }
        if (n == 0) {
            this.notify(string4, string2, string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setProperty", "exited");
        }
        return n;
    }

    private String getPropertyName(Properties properties, String string) {
        String string2 = string;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.equalsIgnoreCase(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public ArrayList getKeys(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Properties properties = null;
        Enumeration<Object> enumeration = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getKeys", "entered");
        }
        if (string.equals("user")) {
            properties = this.userProps;
        } else if (string.equals("setup")) {
            properties = this.setupProps;
        } else if (string.equals("database")) {
            properties = this.dbProps;
        } else if (string.equals("internal")) {
            properties = this.internalProps;
        } else if (this.isManager) {
            DBAccess dBAccess = new DBAccess();
            properties = dBAccess.getProperties(null, properties);
        } else {
            return arrayList;
        }
        enumeration = properties.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            arrayList.add(n, string2);
            ++n;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getKeys", "exited");
        }
        return arrayList;
    }

    public int remove(String string, String string2) {
        int n = -1;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "remove", "entered");
        }
        if (string2.equals("user")) {
            this.userProps.remove(string);
            n = this.flush(this.userProps, userFile);
        } else if (string2.equals("setup")) {
            this.setupProps.remove(string);
            n = this.flush(this.setupProps, setupFile);
        } else if (string2.equals("database")) {
            this.dbProps.remove(string);
            n = this.flush(this.dbProps, dbFile);
        } else if (string2.equals("internal")) {
            this.internalProps.remove(string);
            n = this.flush(this.internalProps, internalFile);
        } else if (this.isManager) {
            block15: {
                this.allTpcProps.remove(string);
                DBAccess dBAccess = new DBAccess();
                try {
                    dBAccess.removeDB(string);
                }
                catch (SQLException sQLException) {
                    n = -1;
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "remove", sQLException);
                    if (!traceLogger.isLogging()) break block15;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "remove", sQLException);
                }
            }
            if (string2.equals("CIM")) {
                this.setCIMClientProperties();
            }
        } else {
            n = -2;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "remove", "exited");
        }
        return n;
    }

    public int register(String string, String string2, String string3, String string4) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "register", "entered");
        }
        Vector vector = new Vector();
        String[] stringArray = new String[]{string3, string4};
        String string5 = (String.valueOf(string) + "?" + string2).toLowerCase();
        if (this.registerTable.containsKey(string5)) {
            vector = (Vector)this.registerTable.get(string5);
            boolean bl = false;
            int n = 0;
            while (n < vector.size()) {
                String[] stringArray2 = (String[])vector.elementAt(n);
                if (stringArray2[0].equals(string3) && stringArray2[1].equals(string4)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector.addElement(stringArray);
                this.registerTable.put(string5, vector);
            }
        } else {
            vector.addElement(stringArray);
            this.registerTable.put(string5, vector);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "register", "exited");
        }
        return 0;
    }

    public int deRegister(String string, String string2, String string3, String string4) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "deRegister", "entered");
        }
        Vector vector = new Vector();
        String string5 = (String.valueOf(string) + "?" + string2).toLowerCase();
        int n = -1;
        if (this.registerTable.containsKey(string5)) {
            vector = (Vector)this.registerTable.get(string5);
            int n2 = 0;
            while (n2 < vector.size()) {
                String[] stringArray = (String[])vector.elementAt(n2);
                if (stringArray[0].equals(string3) & stringArray[1].equals(string4)) {
                    vector.removeElementAt(n2);
                    if (vector.size() != 0) {
                        --n2;
                    }
                }
                ++n2;
            }
            if (vector.size() != 0) {
                this.registerTable.put(string5, vector);
            } else {
                this.registerTable.remove(string5);
            }
            n = 0;
        } else {
            messageLogger.message(IRecordType.TYPE_ERR, (Object)className, "deRegister", "DBParms_errorRemovingCallback", string5);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "deRegister", "exited");
        }
        return n;
    }

    private boolean notify(String string, String string2, String string3) {
        String string4;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "notify", "entered");
        }
        if (this.registerTable.containsKey(string4 = (String.valueOf(string) + "?" + string2).toLowerCase())) {
            Vector vector = (Vector)this.registerTable.get(string4);
            int n = 0;
            while (n < vector.size()) {
                Class<?> clazz;
                String[] stringArray = (String[])vector.elementAt(n);
                try {
                    clazz = Class.forName("org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                ICallback iCallback = (ICallback)ConnectorClient.getService((String)stringArray[0], clazz, (String)stringArray[1]);
                iCallback.propCallback(string, string2, string3);
                ++n;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "notify", "exited");
        }
        return true;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("dispatch", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("display", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("getProperty", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("getProperties", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("setProperty", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("setAuthenticationPw", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("remove", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("register", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("deRegister", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("getKeys", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("getParms", new Integer(RoleChecker.APERI_ADMIN));
        hashtable.put("getFcdeParms", new Integer(RoleChecker.APERI_ADMIN));
        return hashtable;
    }

    private void setCIMClientProperties() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setCIMClientProperties", "entered");
        }
        Properties properties = this.getProperties("CIM");
        GlobalProperties.loadProperties((Properties)properties);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setCIMClientProperties", "exited");
        }
    }
}

