/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;

public class Response
implements Serializable {
    private static final long serialVersionUID = 20001130L;
    public static final String VERSION_CONSTANT = "5.0.0";
    static final String MESSAGE_NAME = "aperi.logger.message.SanQueryEngine";
    static final String TRACE_NAME = "aperi.logger.trace.SanQueryEngine";
    public static transient ILogger msgLogger;
    public static transient ILogger traceLogger;
    private static String MSG_FILE;
    static final String className;
    private int returnCode;
    private byte[] data;
    private int level;
    private int benchmarkLevel;
    private String benchmarkLabel;
    private boolean sameAsBenchmark;
    public static int RETURN_CODE_OK;
    public static int RETURN_CODE_ERROR;
    public static int RETURN_CODE_INACTIVE_SCANNER;
    private Header header = null;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        RETURN_CODE_OK = 0;
        RETURN_CODE_ERROR = 47;
        RETURN_CODE_INACTIVE_SCANNER = 48;
    }

    public Response(int n, String[] stringArray, int n2, int n3, String string, boolean bl) {
        String string2 = "Response(rtnCode, data, level, bnchmrkLvl, bnchmrkLbl, sameAsBnchmrk)";
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        if ((msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME)) != null) {
            msgLogger.setMessageFile(MSG_FILE);
        }
        this.returnCode = n;
        this.data = (byte[])(stringArray != null && stringArray.length != 0 ? this.compressData(this.convertToByteArray(stringArray)) : null);
        this.level = n2;
        this.benchmarkLevel = n3;
        this.benchmarkLabel = string;
        this.sameAsBenchmark = bl;
        if (traceLogger != null && traceLogger.isLogging()) {
            String string3 = "Input: rc = " + this.returnCode + " sameAsBenchmark = " + this.sameAsBenchmark;
            string3 = this.data == null ? String.valueOf(string3) + ", uncompressed data is NULL" : String.valueOf(string3) + ", compressed data length = " + this.data.length;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, string3);
        }
    }

    public Response(int n, String[] stringArray) {
        String string = "Response(rtnCode, data)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        if ((traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME)) != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        if ((msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME)) != null) {
            msgLogger.setMessageFile(MSG_FILE);
        }
        this.returnCode = n;
        this.data = (byte[])(stringArray != null && stringArray.length != 0 ? this.compressData(this.convertToByteArray(stringArray)) : null);
        this.level = -1;
        this.benchmarkLevel = -1;
        this.benchmarkLabel = "";
        this.sameAsBenchmark = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            String string2 = "Input: rc = " + this.returnCode;
            string2 = this.data == null ? String.valueOf(string2) + ", uncompressed data is NULL" : String.valueOf(string2) + ", compressed data length = " + this.data.length;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, string2);
        }
    }

    public Response(int n, String string) {
        String string2 = "Response(rtnCode, data)";
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        if ((msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME)) != null) {
            msgLogger.setMessageFile(MSG_FILE);
        }
        this.returnCode = n;
        this.data = (byte[])(string != null && !string.equals("") ? this.compressData(string.getBytes()) : null);
        this.level = -1;
        this.benchmarkLevel = -1;
        this.benchmarkLabel = "";
        this.sameAsBenchmark = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            String string3 = "Input: rc = " + this.returnCode;
            string3 = this.data == null ? String.valueOf(string3) + ", uncompressed data is NULL" : String.valueOf(string3) + ", compressed data length = " + this.data.length;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, string3);
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public int getLevel() {
        return this.level;
    }

    public int getBenchmarkLevel() {
        return this.benchmarkLevel;
    }

    public String getBenchmarkLabel() {
        return this.benchmarkLabel;
    }

    public boolean isSameAsBenchmark() {
        return this.sameAsBenchmark;
    }

    public String getData() {
        if (this.data == null || this.data.length == 0) {
            return new String();
        }
        return new String(this.uncompressData(this.data));
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public String toString() {
        String string = new String();
        string = string.concat("\nResponse object\n");
        string = string.concat("  Return code = " + this.returnCode + "\n");
        string = string.concat("  Level = " + this.level + "\n");
        string = string.concat("  BenchmarkLevel = " + this.benchmarkLevel + "\n");
        string = string.concat("  BenchmarkLabel = \"" + this.benchmarkLabel + "\"\n\n");
        if (this.header != null) {
            string = string.concat(String.valueOf(this.header.toString()) + "\n\n");
        }
        if (this.data != null) {
            string = string.concat("  Data = \n" + this.getData() + "\n\n");
        }
        return string;
    }

    private byte[] compressData(byte[] byArray) {
        String string = "compressData";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        byte[] byArray2 = null;
        if (byArray != null && byArray.length != 0) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                gZIPOutputStream.write(byArray, 0, byArray.length);
                gZIPOutputStream.close();
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, iOException);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "QueryEngine_compressDataException", iOException);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return byArray2;
    }

    private byte[] uncompressData(byte[] byArray) {
        String string = "uncompressData";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        byte[] byArray2 = null;
        if (byArray != null && byArray.length != 0) {
            try {
                int n;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray3 = new byte[1024];
                while ((n = gZIPInputStream.read(byArray3, 0, byArray3.length)) != -1) {
                    byteArrayOutputStream.write(byArray3, 0, n);
                }
                gZIPInputStream.close();
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, iOException);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "QueryEngine_uncompressDataException", iOException);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return byArray2;
    }

    private String convertToString(String[] stringArray) {
        String string = "convertToString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        if (stringArray != null && stringArray.length != 0) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return string2;
    }

    private byte[] convertToByteArray(String[] stringArray) {
        String string = "convertToByteArray";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        byte[] byArray = null;
        if (stringArray != null && stringArray.length != 0) {
            byArray = this.convertToString(stringArray).getBytes();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return byArray;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setBenchmarkLevel(int n) {
        this.benchmarkLevel = n;
    }

    public void setBenchmarkLabel(String string) {
        this.benchmarkLabel = string;
    }

    public void setSameAsBenchmark(boolean bl) {
        this.sameAsBenchmark = bl;
    }
}

